
/*
  Liquid War 6 is a unique multiplayer wargame.
  Copyright (C)  2005, 2006, 2007, 2008  Christian Mauduit <ufoot@ufoot.org>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.
  

  Liquid War 6 homepage : http://www.gnu.org/software/liquidwar6/
  Contact author        : ufoot@ufoot.org
*/

#include <stdio.h>
#include <string.h>

#include "liquidwar6.h"

int
check_arg (char *arg)
{
  char *keyword = NULL;
  char *equal = NULL;
  int ret = 0;

  keyword = lw6sys_str_copy (arg);
  if (keyword)
    {
      equal = strchr (keyword, '=');
      if (equal)
	{
	  (*equal) = '\0';
	}
      ret = lw6hlp_is_documented (keyword) && lw6hlp_is_listed (keyword);
      LW6SYS_FREE (keyword);
    }

  return ret;
}

/**
 * lw6_process_non_run_options:
 *
 * @argc: the number of command-line args, as passed to main()
 * @argv: an array of strings containing command-line args, as passed to main()
 * @run_game: a pointer to a boolean which will contain true (1) if the
 *   game must be launched, or false (0) if the option is such that game 
 *   must be skipped. Example: --copyright, --help, ...
 *
 * Return value: non-zero if success, 0 if error. The error can be, for
 *   instance, the test suite returning "no, tests were not OK".
 */
int
lw6_process_non_run_options (int argc, char *argv[], int *run_game)
{
  int i;
  int ret = 1;
  char *path = NULL;
  char *value = NULL;

  (*run_game) = 1;
  for (i = 1; i < argc; ++i)
    {
      /*
       * Syntax check, done now to let "/?" pass
       */
      if (!check_arg (argv[i]))
	{
	  lw6sys_log (LW6SYS_LOG_WARNING, _("unknown option \"%s\""),
		      argv[i]);
	  (*run_game) = 0;
	}
      else if (lw6sys_arg_match ("help", argv[i]) ||
	       lw6sys_arg_match ("h", argv[i])
	       || lw6sys_arg_match ("?", argv[i]))
	{
	  lw6_print_help ();
	  (*run_game) = 0;
	}
      else if (lw6sys_arg_match ("version", argv[i]) ||
	       lw6sys_arg_match ("v", argv[i]))
	{
	  lw6_print_version ();
	  (*run_game) = 0;
	}
      else if (lw6sys_arg_match ("copyright", argv[i]) ||
	       lw6sys_arg_match ("copyleft", argv[i]) ||
	       lw6sys_arg_match ("copy", argv[i]) ||
	       lw6sys_arg_match ("c", argv[i]))
	{
	  lw6_print_long_copyright ();
	  (*run_game) = 0;
	}
      /*
       * Some other low-level options
       */
      else if (lw6sys_arg_match ("test", argv[i]))
	{
	  ret = lw6sys_test ()
	    && lw6map_test ()
	    && lw6ker_test () /* && lw6dyn_test() */  && lw6cns_test ()
	    && lw6hlp_test ()
	    && lw6cfg_test () && lw6ldr_test () && lw6tsk_test ()
	    && lw6gui_test () && lw6gfx_test () && lw6snd_test ()
	    && lw6img_test () && lw6net_test () && lw6cli_test ()
	    && lw6srv_test () && lw6p2p_test () && lw6_test ();
	  (*run_game) = 0;
	}
      else if (lw6sys_arg_match ("reset", argv[i]))
	{
	  lw6cfg_reset (argc, argv);
	  (*run_game) = 0;
	}
      else if (lw6sys_arg_match ("defaults", argv[i]))
	{
	  lw6cfg_reset (argc, argv);
	}
      else if (lw6sys_arg_match ("pedigree", argv[i]))
	{
	  lw6_print_pedigree ();
	  (*run_game) = 0;
	}
      else if (lw6sys_arg_match ("list", argv[i]))
	{
	  lw6_print_list ();
	  (*run_game) = 0;
	}
      else if (lw6sys_arg_match ("about", argv[i]))
	{
	  value = lw6sys_arg_get_value (argc, argv, "about");
	  if (value)
	    {
	      lw6_print_about (value);
	      LW6SYS_FREE (value);
	    }
	  (*run_game) = 0;
	}
      /*
       * Specific list
       */
      else if (lw6sys_arg_match ("list-quick", argv[i]))
	{
	  lw6_print_list_quick ();
	  (*run_game) = 0;
	}
      else if (lw6sys_arg_match ("list-doc", argv[i]))
	{
	  lw6_print_list_doc ();
	  (*run_game) = 0;
	}
      else if (lw6sys_arg_match ("list-show", argv[i]))
	{
	  lw6_print_list_show ();
	  (*run_game) = 0;
	}
      else if (lw6sys_arg_match ("list-path", argv[i]))
	{
	  lw6_print_list_path ();
	  (*run_game) = 0;
	}
      else if (lw6sys_arg_match ("list-players", argv[i]))
	{
	  lw6_print_list_players ();
	  (*run_game) = 0;
	}
      else if (lw6sys_arg_match ("list-input", argv[i]))
	{
	  lw6_print_list_input ();
	  (*run_game) = 0;
	}
      else if (lw6sys_arg_match ("list-graphics", argv[i]))
	{
	  lw6_print_list_graphics ();
	  (*run_game) = 0;
	}
      else if (lw6sys_arg_match ("list-sound", argv[i]))
	{
	  lw6_print_list_sound ();
	  (*run_game) = 0;
	}
      else if (lw6sys_arg_match ("list-network", argv[i]))
	{
	  lw6_print_list_network ();
	  (*run_game) = 0;
	}
      else if (lw6sys_arg_match ("list-map", argv[i]))
	{
	  lw6_print_list_map ();
	  (*run_game) = 0;
	}
      else if (lw6sys_arg_match ("list-map-options", argv[i]))
	{
	  lw6_print_list_map_options ();
	  (*run_game) = 0;
	}
      else if (lw6sys_arg_match ("list-map-style", argv[i]))
	{
	  lw6_print_list_map_style ();
	  (*run_game) = 0;
	}
      else if (lw6sys_arg_match ("list-funcs", argv[i]))
	{
	  lw6_print_list_funcs ();
	  (*run_game) = 0;
	}
      else if (lw6sys_arg_match ("list-hooks", argv[i]))
	{
	  lw6_print_list_hooks ();
	  (*run_game) = 0;
	}
      else if (lw6sys_arg_match ("list-tuning", argv[i]))
	{
	  lw6_print_list_tuning ();
	  (*run_game) = 0;
	}
      else if (lw6sys_arg_match ("list-aliases", argv[i]))
	{
	  lw6_print_list_aliases ();
	  (*run_game) = 0;
	}
      else if (lw6sys_arg_match ("example-options-xml", argv[i]))
	{
	  lw6ldr_print_example_options_xml (stdout);
	  (*run_game) = 0;
	}
      else if (lw6sys_arg_match ("example-style-xml", argv[i]))
	{
	  lw6ldr_print_example_style_xml (stdout);
	  (*run_game) = 0;
	}
      /*
       * Show any build_XXX LW specific value
       */
      else if (lw6sys_arg_match ("show-build-package-tarname", argv[i]))
	{
	  printf ("%s\n", lw6sys_build_get_package_tarname ());
	  (*run_game) = 0;
	}
      else if (lw6sys_arg_match ("show-build-package-name", argv[i]))
	{
	  printf ("%s\n", lw6sys_build_get_package_name ());
	  (*run_game) = 0;
	}
      else if (lw6sys_arg_match ("show-build-package-string", argv[i]))
	{
	  printf ("%s\n", lw6sys_build_get_package_string ());
	  (*run_game) = 0;
	}
      else if (lw6sys_arg_match ("show-build-version", argv[i]))
	{
	  printf ("%s\n", lw6sys_build_get_version ());
	  (*run_game) = 0;
	}
      else if (lw6sys_arg_match ("show-build-codename", argv[i]))
	{
	  printf ("%s\n", lw6sys_build_get_codename ());
	  (*run_game) = 0;
	}
      else if (lw6sys_arg_match ("show-build-stamp", argv[i]))
	{
	  printf ("%s\n", lw6sys_build_get_stamp ());
	  (*run_game) = 0;
	}
      else if (lw6sys_arg_match ("show-build-md5sum", argv[i]))
	{
	  printf ("%s\n", lw6sys_build_get_md5sum ());
	  (*run_game) = 0;
	}
      else if (lw6sys_arg_match ("show-build-copyright", argv[i]))
	{
	  printf ("%s\n", lw6sys_build_get_copyright ());
	  (*run_game) = 0;
	}
      else if (lw6sys_arg_match ("show-build-license", argv[i]))
	{
	  printf ("%s\n", lw6sys_build_get_license ());
	  (*run_game) = 0;
	}
      else if (lw6sys_arg_match ("show-build-configure-args", argv[i]))
	{
	  printf ("%s\n", lw6sys_build_get_configure_args ());
	  (*run_game) = 0;
	}
      else if (lw6sys_arg_match ("show-build-cflags", argv[i]))
	{
	  printf ("%s\n", lw6sys_build_get_cflags ());
	  (*run_game) = 0;
	}
      else if (lw6sys_arg_match ("show-build-ldflags", argv[i]))
	{
	  printf ("%s\n", lw6sys_build_get_ldflags ());
	  (*run_game) = 0;
	}
      else if (lw6sys_arg_match ("show-build-hostname", argv[i]))
	{
	  printf ("%s\n", lw6sys_build_get_hostname ());
	  (*run_game) = 0;
	}
      else if (lw6sys_arg_match ("show-build-date", argv[i]))
	{
	  printf ("%s\n", lw6sys_build_get_date ());
	  (*run_game) = 0;
	}
      else if (lw6sys_arg_match ("show-build-time", argv[i]))
	{
	  printf ("%s\n", lw6sys_build_get_time ());
	  (*run_game) = 0;
	}
      else if (lw6sys_arg_match ("show-build-target-cpu", argv[i]))
	{
	  printf ("%s\n", lw6sys_build_get_target_cpu ());
	  (*run_game) = 0;
	}
      else if (lw6sys_arg_match ("show-build-target-os", argv[i]))
	{
	  printf ("%s\n", lw6sys_build_get_target_os ());
	  (*run_game) = 0;
	}
      else if (lw6sys_arg_match ("show-build-top-srcdir", argv[i]))
	{
	  printf ("%s\n", lw6sys_build_get_top_srcdir ());
	  (*run_game) = 0;
	}
      else if (lw6sys_arg_match ("show-build-prefix", argv[i]))
	{
	  printf ("%s\n", lw6sys_build_get_prefix ());
	  (*run_game) = 0;
	}
      else if (lw6sys_arg_match ("show-build-datadir", argv[i]))
	{
	  printf ("%s\n", lw6sys_build_get_datadir ());
	  (*run_game) = 0;
	}
      else if (lw6sys_arg_match ("show-build-libdir", argv[i]))
	{
	  printf ("%s\n", lw6sys_build_get_libdir ());
	  (*run_game) = 0;
	}
      else if (lw6sys_arg_match ("show-build-includedir", argv[i]))
	{
	  printf ("%s\n", lw6sys_build_get_includedir ());
	  (*run_game) = 0;
	}
      else if (lw6sys_arg_match ("show-build-localedir", argv[i]))
	{
	  printf ("%s\n", lw6sys_build_get_localedir ());
	  (*run_game) = 0;
	}
      else if (lw6sys_arg_match ("show-build-docdir", argv[i]))
	{
	  printf ("%s\n", lw6sys_build_get_docdir ());
	  (*run_game) = 0;
	}
      /*
       * Show any interesting default path
       */
      else if (lw6sys_arg_match ("show-default-user-dir", argv[i]))
	{
	  path = lw6sys_get_default_user_dir ();
	  if (path)
	    {
	      printf ("%s\n", path);
	      path = NULL;
	    }
	  (*run_game) = 0;
	}
      else if (lw6sys_arg_match ("show-default-config-file", argv[i]))
	{
	  path = lw6sys_get_default_config_file ();
	  if (path)
	    {
	      printf ("%s\n", path);
	      path = NULL;
	    }
	  (*run_game) = 0;
	}
      else if (lw6sys_arg_match ("show-default-log-file", argv[i]))
	{
	  path = lw6sys_get_default_log_file ();
	  if (path)
	    {
	      printf ("%s\n", path);
	      path = NULL;
	    }
	  (*run_game) = 0;
	}
      else if (lw6sys_arg_match ("show-default-prefix", argv[i]))
	{
	  path = lw6sys_get_default_prefix ();
	  if (path)
	    {
	      printf ("%s\n", path);
	      path = NULL;
	    }
	  (*run_game) = 0;
	}
      else if (lw6sys_arg_match ("show-default-mod-dir", argv[i]))
	{
	  path = lw6sys_get_default_mod_dir ();
	  if (path)
	    {
	      printf ("%s\n", path);
	      path = NULL;
	    }
	  (*run_game) = 0;
	}
      else if (lw6sys_arg_match ("show-default-data-dir", argv[i]))
	{
	  path = lw6sys_get_default_data_dir ();
	  if (path)
	    {
	      printf ("%s\n", path);
	      path = NULL;
	    }
	  (*run_game) = 0;
	}
      else if (lw6sys_arg_match ("show-default-map-dir", argv[i]))
	{
	  path = lw6sys_get_default_map_dir ();
	  if (path)
	    {
	      printf ("%s\n", path);
	      path = NULL;
	    }
	  (*run_game) = 0;
	}
      else if (lw6sys_arg_match ("show-default-map-path", argv[i]))
	{
	  path = lw6sys_get_default_map_path ();
	  if (path)
	    {
	      printf ("%s\n", path);
	      path = NULL;
	    }
	  (*run_game) = 0;
	}
      else if (lw6sys_arg_match ("show-default-script-file", argv[i]))
	{
	  path = lw6sys_get_default_script_file ();
	  if (path)
	    {
	      printf ("%s\n", path);
	      path = NULL;
	    }
	  (*run_game) = 0;
	}
      /*
       * Show any interesting path
       */
      else if (lw6sys_arg_match ("show-user-dir", argv[i]))
	{
	  path = lw6cfg_unified_get_user_dir (argc, argv);
	  if (path)
	    {
	      printf ("%s\n", path);
	      path = NULL;
	    }
	  (*run_game) = 0;
	}
      else if (lw6sys_arg_match ("show-config-file", argv[i]))
	{
	  path = lw6sys_get_config_file (argc, argv);
	  if (path)
	    {
	      printf ("%s\n", path);
	      path = NULL;
	    }
	  (*run_game) = 0;
	}
      else if (lw6sys_arg_match ("show-log-file", argv[i]))
	{
	  path = lw6cfg_unified_get_log_file (argc, argv);
	  if (path)
	    {
	      printf ("%s\n", path);
	      path = NULL;
	    }
	  (*run_game) = 0;
	}
      else if (lw6sys_arg_match ("show-prefix", argv[i]))
	{
	  path = lw6sys_get_prefix (argc, argv);
	  if (path)
	    {
	      printf ("%s\n", path);
	      path = NULL;
	    }
	  (*run_game) = 0;
	}
      else if (lw6sys_arg_match ("show-mod-dir", argv[i]))
	{
	  path = lw6sys_get_mod_dir (argc, argv);
	  if (path)
	    {
	      printf ("%s\n", path);
	      path = NULL;
	    }
	  (*run_game) = 0;
	}
      else if (lw6sys_arg_match ("show-data-dir", argv[i]))
	{
	  path = lw6sys_get_data_dir (argc, argv);
	  if (path)
	    {
	      printf ("%s\n", path);
	      path = NULL;
	    }
	  (*run_game) = 0;
	}
      else if (lw6sys_arg_match ("show-map-dir", argv[i]))
	{
	  path = lw6sys_get_map_dir (argc, argv);
	  if (path)
	    {
	      printf ("%s\n", path);
	      path = NULL;
	    }
	  (*run_game) = 0;
	}
      else if (lw6sys_arg_match ("show-map-path", argv[i]))
	{
	  path = lw6cfg_unified_get_map_path (argc, argv);
	  if (path)
	    {
	      printf ("%s\n", path);
	      path = NULL;
	    }
	  (*run_game) = 0;
	}
      else if (lw6sys_arg_match ("show-script-file", argv[i]))
	{
	  path = lw6sys_get_script_file (argc, argv);
	  if (path)
	    {
	      printf ("%s\n", path);
	      path = NULL;
	    }
	  (*run_game) = 0;
	}
    }

  return ret;
}
