
/*
  Liquid War 6 is a unique multiplayer wargame.
  Copyright (C)  2005, 2006, 2007, 2008  Christian Mauduit <ufoot@ufoot.org>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.
  

  Liquid War 6 homepage : http://www.gnu.org/software/liquidwar6/
  Contact author        : ufoot@ufoot.org
*/

#include <stdio.h>
#include <string.h>
#include <time.h>

#include "liquidwar6.h"

void
lw6_print_help ()
{
  lw6sys_list_t *list;

  printf ("\n");
  printf
    (_("Usage: %s [--option1[=value1]] ... [--optionN[=valueN]]\n"),
     lw6sys_build_get_package_tarname ());
  printf ("\n");

  list = lw6hlp_list_quick ();
  if (list)
    {
      lw6hlp_print_content (&list, stdout);
      lw6sys_list_free (list);
    }

  printf
    (_("Online manual: http://www.gnu.org/software/liquidwar6/manual/\n"));
  printf ("\n");
  printf (_("Report bugs to <bug-liquidwar6@gnu.org>\n"));
  printf ("\n");

  fflush (stdout);
}

void
lw6_print_version ()
{
  scm_init_guile ();

  printf ("%s (%s) %s\n", lw6sys_build_get_package_tarname (),
	  lw6sys_build_get_package_name (), lw6sys_build_get_version ());
  lw6_print_short_copyright ();
}

void
lw6_print_short_copyright ()
{
  printf ("%s\n", lw6sys_build_get_copyright ());
  printf (_
	  ("License GPLv3+: GNU GPL version 3 or later <http://gnu.org/licenses/gpl.html>\n"
	   "This is free software: you are free to change and redistribute it.\n"
	   "There is NO WARRANTY, to the extent permitted by law.\n"));
  fflush (stdout);
}

void
lw6_print_long_copyright ()
{
  printf
    ("%s",
     "Liquid War 6 is a unique multiplayer wargame.\n"
     "Copyright (C)  2005, 2006, 2007, 2008  Christian Mauduit <ufoot@ufoot.org>\n"
     "\n"
     "This program is free software; you can redistribute it and/or modify\n"
     "it under the terms of the GNU General Public License as published by\n"
     "the Free Software Foundation, either version 3 of the License, or\n"
     "(at your option) any later version.\n"
     "\n"
     "This program is distributed in the hope that it will be useful,\n"
     "but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
     "MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
     "GNU General Public License for more details.\n"
     "\n"
     "You should have received a copy of the GNU General Public License\n"
     "along with this program.  If not, see <http://www.gnu.org/licenses/>.\n"
     "Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA\n");
  fflush (stdout);
}

void
lw6_print_pedigree ()
{
  printf ("package_tarname: %s\n", lw6sys_build_get_package_tarname ());
  printf ("package_name: %s\n", lw6sys_build_get_package_name ());
  printf ("package_string: %s\n", lw6sys_build_get_package_string ());
  printf ("version: %s\n", lw6sys_build_get_version ());
  printf ("codename: %s\n", lw6sys_build_get_codename ());
  printf ("stamp: %s\n", lw6sys_build_get_stamp ());
  printf ("md5sum: %s\n", lw6sys_build_get_md5sum ());
  printf ("copyright: %s\n", lw6sys_build_get_copyright ());
  printf ("license: %s\n", lw6sys_build_get_license ());
  printf ("configure_args: %s\n", lw6sys_build_get_configure_args ());
  printf ("cflags: %s\n", lw6sys_build_get_cflags ());
  printf ("ldflags: %s\n", lw6sys_build_get_ldflags ());
  printf ("hostname: %s\n", lw6sys_build_get_hostname ());
  printf ("date: %s\n", lw6sys_build_get_date ());
  printf ("time: %s\n", lw6sys_build_get_time ());
  printf ("target_cpu: %s\n", lw6sys_build_get_target_cpu ());
  printf ("target_os: %s\n", lw6sys_build_get_target_os ());
  printf ("top_srcdir: %s\n", lw6sys_build_get_top_srcdir ());
  printf ("prefix: %s\n", lw6sys_build_get_prefix ());
  printf ("datadir: %s\n", lw6sys_build_get_datadir ());
  printf ("libdir: %s\n", lw6sys_build_get_libdir ());
  printf ("includedir: %s\n", lw6sys_build_get_includedir ());
  printf ("localedir: %s\n", lw6sys_build_get_localedir ());
  printf ("docdir: %s\n", lw6sys_build_get_docdir ());
  fflush (stdout);
}

void
lw6_print_list_quick ()
{
  lw6sys_list_t *list;

  list = lw6hlp_list_quick ();
  if (list)
    {
      lw6hlp_print_keyword (&list, stdout);
      lw6sys_list_free (list);
    }
}

void
lw6_print_list_doc ()
{
  lw6sys_list_t *list;

  list = lw6hlp_list_doc ();
  if (list)
    {
      lw6hlp_print_keyword (&list, stdout);
      lw6sys_list_free (list);
    }
}

void
lw6_print_list_show ()
{
  lw6sys_list_t *list;

  list = lw6hlp_list_show ();
  if (list)
    {
      lw6hlp_print_keyword (&list, stdout);
      lw6sys_list_free (list);
    }
}

void
lw6_print_list_path ()
{
  lw6sys_list_t *list;

  list = lw6hlp_list_path ();
  if (list)
    {
      lw6hlp_print_keyword (&list, stdout);
      lw6sys_list_free (list);
    }
}

void
lw6_print_list_players ()
{
  lw6sys_list_t *list;

  list = lw6hlp_list_players ();
  if (list)
    {
      lw6hlp_print_keyword (&list, stdout);
      lw6sys_list_free (list);
    }
}

void
lw6_print_list_input ()
{
  lw6sys_list_t *list;

  list = lw6hlp_list_input ();
  if (list)
    {
      lw6hlp_print_keyword (&list, stdout);
      lw6sys_list_free (list);
    }
}

void
lw6_print_list_graphics ()
{
  lw6sys_list_t *list;

  list = lw6hlp_list_graphics ();
  if (list)
    {
      lw6hlp_print_keyword (&list, stdout);
      lw6sys_list_free (list);
    }
}

void
lw6_print_list_sound ()
{
  lw6sys_list_t *list;

  list = lw6hlp_list_sound ();
  if (list)
    {
      lw6hlp_print_keyword (&list, stdout);
      lw6sys_list_free (list);
    }
}

void
lw6_print_list_network ()
{
  lw6sys_list_t *list;

  list = lw6hlp_list_network ();
  if (list)
    {
      lw6hlp_print_keyword (&list, stdout);
      lw6sys_list_free (list);
    }
}

void
lw6_print_list_map ()
{
  lw6sys_list_t *list;

  list = lw6hlp_list_map ();
  if (list)
    {
      lw6hlp_print_keyword (&list, stdout);
      lw6sys_list_free (list);
    }
}

void
lw6_print_list_map_options ()
{
  lw6sys_list_t *list;

  list = lw6hlp_list_map_options ();
  if (list)
    {
      lw6hlp_print_keyword (&list, stdout);
      lw6sys_list_free (list);
    }
}

void
lw6_print_list_map_style ()
{
  lw6sys_list_t *list;

  list = lw6hlp_list_map_style ();
  if (list)
    {
      lw6hlp_print_keyword (&list, stdout);
      lw6sys_list_free (list);
    }
}

void
lw6_print_list_funcs ()
{
  lw6sys_list_t *list;

  list = lw6hlp_list_funcs ();
  if (list)
    {
      lw6hlp_print_keyword (&list, stdout);
      lw6sys_list_free (list);
    }
}

void
lw6_print_list_hooks ()
{
  lw6sys_list_t *list;

  list = lw6hlp_list_hooks ();
  if (list)
    {
      lw6hlp_print_keyword (&list, stdout);
      lw6sys_list_free (list);
    }
}

void
lw6_print_list_tuning ()
{
  lw6sys_list_t *list;

  list = lw6hlp_list_tuning ();
  if (list)
    {
      lw6hlp_print_keyword (&list, stdout);
      lw6sys_list_free (list);
    }
}

void
lw6_print_list_aliases ()
{
  lw6sys_list_t *list;

  list = lw6hlp_list_aliases ();
  if (list)
    {
      lw6hlp_print_keyword (&list, stdout);
      lw6sys_list_free (list);
    }
}

void
lw6_print_list ()
{
  lw6sys_list_t *list;

  list = lw6hlp_list ();
  if (list)
    {
      lw6hlp_print_keyword (&list, stdout);
      lw6sys_list_free (list);
    }
}

void
lw6_print_about (char *keyword)
{
  char *doc;

  doc =
    lw6sys_str_reformat (lw6hlp_about (NULL, keyword),
			 LW6SYS_REFORMAT_DEFAULT_PREFIX,
			 LW6SYS_REFORMAT_DEFAULT_NB_COLUMNS);
  if (doc)
    {
      printf ("%s", doc);
      fflush (stdout);
      LW6SYS_FREE (doc);
    }
}

void
lw6_print_hello (int argc, char *argv[])
{
  lw6sys_log (LW6SYS_LOG_INFO, _("hello"));

  lw6sys_build_log_pedigree ();
  lw6sys_options_log_defaults ();
  lw6sys_options_log (argc, argv);

  lw6sys_log (LW6SYS_LOG_INFO, _("approx. %d megabytes available"),
	      lw6sys_megabytes_available ());
  if (lw6sys_is_big_endian ())
    {
      lw6sys_log (LW6SYS_LOG_INFO, _("big endian system (ppc-like)"));
    }
  if (lw6sys_is_little_endian ())
    {
      lw6sys_log (LW6SYS_LOG_INFO, _("little endian system (x86-like)"));
    }
}

void
lw6_print_goodbye ()
{
  lw6sys_log (LW6SYS_LOG_INFO,
	      _("more info on http://www.gnu.org/software/liquidwar6/"));
  lw6sys_log (LW6SYS_LOG_INFO, _("goodbye"));
}
