/*
  Liquid War 6 is a unique multiplayer wargame.
  Copyright (C)  2005, 2006, 2007, 2008  Christian Mauduit <ufoot@ufoot.org>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.


  Liquid War 6 homepage : http://www.gnu.org/software/liquidwar6/
  Contact author        : ufoot@ufoot.org
*/

#include "config.h"
#include "map.h"

void
lw6map_color_invert (lw6map_color_couple_t * color)
{
  lw6sys_color_8_t tmp;

  tmp = color->fg;
  color->fg = color->bg;
  color->bg = tmp;
}

void
lw6map_auto_colors (lw6map_style_t * style)
{
  if (style->hud_color_auto)
    {
      style->hud_color_frame = style->background_color_base;
      style->hud_color_text = style->background_color_alternate;
    }

  if (style->menu_color_auto)
    {
      style->menu_color_default = style->background_color_alternate;
      style->menu_color_selected = style->background_color_alternate;
      lw6map_color_invert (&style->menu_color_selected);
      style->menu_color_disabled = style->background_color_base;
    }

  if (style->view_color_auto)
    {
      style->view_color_cursor = style->background_color_alternate;
      style->view_color_map = style->background_color_base;
    }

  if (style->system_color_auto)
    {
      style->system_color = style->background_color_alternate;
    }
}
