/*
  Liquid War 6 is a unique multiplayer wargame.
  Copyright (C)  2005, 2006, 2007, 2008  Christian Mauduit <ufoot@ufoot.org>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.


  Liquid War 6 homepage : http://www.gnu.org/software/liquidwar6/
  Contact author        : ufoot@ufoot.org
*/

#include <string.h>
#include <stdio.h>

#include "config.h"
#include "map.h"

void
lw6map_metadata_defaults (lw6map_metadata_t * metadata)
{
  lw6map_metadata_clear (metadata);

  metadata->title = lw6sys_new_sprintf (_("Default map"));
  metadata->readme =
    lw6sys_new_sprintf (_("Default map generated by %s"),
			lw6sys_build_get_package_string ());

  if ((!metadata->title) || (!metadata->readme))
    {
      lw6sys_log (LW6SYS_LOG_WARNING,
		  _("unable to construct default map metadata"));
    }
}

/*
 * Clears a metadata.
 */
void
lw6map_metadata_clear (lw6map_metadata_t * metadata)
{
  if (metadata)
    {
      if (metadata->title)
	{
	  LW6SYS_FREE (metadata->title);
	}
      if (metadata->readme)
	{
	  LW6SYS_FREE (metadata->readme);
	}
      memset (metadata, 0, sizeof (lw6map_metadata_t));

      /*
       * We don't free the metadata pointer itself, this
       * is a "clear" function, not a "free".
       */
    }
}
