/*
  Liquid War 6 is a unique multiplayer wargame.
  Copyright (C)  2005, 2006, 2007, 2008  Christian Mauduit <ufoot@ufoot.org>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.


  Liquid War 6 homepage : http://www.gnu.org/software/liquidwar6/
  Contact author        : ufoot@ufoot.org
*/

#include <string.h>

#include "config.h"
#include "map.h"

char *LW6MAP_OPTIONS_LIST[] = {
  "total-time",
  "respawn-team",
  "moves-per-round",
  "spreads-per-round",
  "rounds-per-sec",
  "fighter-attack",
  "fighter-defense",
  "fighter-new-health",
  "side-attack-factor",
  "side-defense-factor",
  "nb-move-tries",
  "nb-attack-tries",
  "nb-defense-tries",
  "single-army-surface",
  "total-armies-surface",
  "max-nb-teams",
  "x-polarity",
  "y-polarity",
  "max-zone-size",
  "min-map-width",
  "max-map-width",
  "min-map-height",
  "max-map-height",
  "min-map-surface",
  "max-map-surface",
  "bot-wait-between-moves",
  "bot-nb-move-steps",
  "round-delta",
  "max-round-delta",
  "max-cursor-pot",
  "cursor-pot-init",
  "max-cursor-pot-offset",
  NULL				// very important that this list is NULL-terminated
};

static lw6map_options_t default_options = {
  LW6MAP_OPTIONS_DEFAULT_TOTAL_TIME,
  LW6MAP_OPTIONS_DEFAULT_RESPAWN_TEAM,
  LW6MAP_OPTIONS_DEFAULT_MOVES_PER_ROUND,
  LW6MAP_OPTIONS_DEFAULT_SPREADS_PER_ROUND,
  LW6MAP_OPTIONS_DEFAULT_ROUNDS_PER_SEC,
  LW6MAP_OPTIONS_DEFAULT_FIGHTER_ATTACK,
  LW6MAP_OPTIONS_DEFAULT_FIGHTER_DEFENSE,
  LW6MAP_OPTIONS_DEFAULT_FIGHTER_NEW_HEALTH,
  LW6MAP_OPTIONS_DEFAULT_SIDE_ATTACK_FACTOR,
  LW6MAP_OPTIONS_DEFAULT_SIDE_DEFENSE_FACTOR,
  LW6MAP_OPTIONS_DEFAULT_NB_MOVE_TRIES,
  LW6MAP_OPTIONS_DEFAULT_NB_ATTACK_TRIES,
  LW6MAP_OPTIONS_DEFAULT_NB_DEFENSE_TRIES,
  LW6MAP_OPTIONS_DEFAULT_SINGLE_ARMY_SURFACE,
  LW6MAP_OPTIONS_DEFAULT_TOTAL_ARMIES_SURFACE,
  LW6MAP_OPTIONS_DEFAULT_MAX_NB_TEAMS,
  LW6MAP_OPTIONS_DEFAULT_X_POLARITY,
  LW6MAP_OPTIONS_DEFAULT_Y_POLARITY,
  LW6MAP_OPTIONS_DEFAULT_MAX_ZONE_SIZE,
  LW6MAP_OPTIONS_DEFAULT_MIN_MAP_WIDTH,
  LW6MAP_OPTIONS_DEFAULT_MAX_MAP_WIDTH,
  LW6MAP_OPTIONS_DEFAULT_MIN_MAP_HEIGHT,
  LW6MAP_OPTIONS_DEFAULT_MAX_MAP_HEIGHT,
  LW6MAP_OPTIONS_DEFAULT_MIN_MAP_SURFACE,
  LW6MAP_OPTIONS_DEFAULT_MAX_MAP_SURFACE,
  LW6MAP_OPTIONS_DEFAULT_BOT_WAIT_BETWEEN_MOVES,
  LW6MAP_OPTIONS_DEFAULT_BOT_NB_MOVE_STEPS,
  LW6MAP_OPTIONS_DEFAULT_ROUND_DELTA,
  LW6MAP_OPTIONS_DEFAULT_MAX_ROUND_DELTA,
  LW6MAP_OPTIONS_DEFAULT_MAX_CURSOR_POT,
  LW6MAP_OPTIONS_DEFAULT_CURSOR_POT_INIT,
  LW6MAP_OPTIONS_DEFAULT_MAX_CURSOR_POT_OFFSET
};

static lw6map_options_t min_options = {
  LW6MAP_OPTIONS_MIN_TOTAL_TIME,
  LW6MAP_OPTIONS_MIN_RESPAWN_TEAM,
  LW6MAP_OPTIONS_MIN_MOVES_PER_ROUND,
  LW6MAP_OPTIONS_MIN_SPREADS_PER_ROUND,
  LW6MAP_OPTIONS_MIN_ROUNDS_PER_SEC,
  LW6MAP_OPTIONS_MIN_FIGHTER_ATTACK,
  LW6MAP_OPTIONS_MIN_FIGHTER_DEFENSE,
  LW6MAP_OPTIONS_MIN_FIGHTER_NEW_HEALTH,
  LW6MAP_OPTIONS_MIN_SIDE_ATTACK_FACTOR,
  LW6MAP_OPTIONS_MIN_SIDE_DEFENSE_FACTOR,
  LW6MAP_OPTIONS_MIN_NB_MOVE_TRIES,
  LW6MAP_OPTIONS_MIN_NB_ATTACK_TRIES,
  LW6MAP_OPTIONS_MIN_NB_DEFENSE_TRIES,
  LW6MAP_OPTIONS_MIN_SINGLE_ARMY_SURFACE,
  LW6MAP_OPTIONS_MIN_TOTAL_ARMIES_SURFACE,
  LW6MAP_OPTIONS_MIN_MAX_NB_TEAMS,
  LW6MAP_OPTIONS_MIN_X_POLARITY,
  LW6MAP_OPTIONS_MIN_Y_POLARITY,
  LW6MAP_OPTIONS_MIN_MAX_ZONE_SIZE,
  LW6MAP_OPTIONS_MIN_MIN_MAP_WIDTH,
  LW6MAP_OPTIONS_MIN_MAX_MAP_WIDTH,
  LW6MAP_OPTIONS_MIN_MIN_MAP_HEIGHT,
  LW6MAP_OPTIONS_MIN_MAX_MAP_HEIGHT,
  LW6MAP_OPTIONS_MIN_MIN_MAP_SURFACE,
  LW6MAP_OPTIONS_MIN_MAX_MAP_SURFACE,
  LW6MAP_OPTIONS_MIN_BOT_WAIT_BETWEEN_MOVES,
  LW6MAP_OPTIONS_MIN_BOT_NB_MOVE_STEPS,
  LW6MAP_OPTIONS_MIN_ROUND_DELTA,
  LW6MAP_OPTIONS_MIN_MAX_ROUND_DELTA,
  LW6MAP_OPTIONS_MIN_MAX_CURSOR_POT,
  LW6MAP_OPTIONS_MIN_CURSOR_POT_INIT,
  LW6MAP_OPTIONS_MIN_MAX_CURSOR_POT_OFFSET
};

static lw6map_options_t max_options = {
  LW6MAP_OPTIONS_MAX_TOTAL_TIME,
  LW6MAP_OPTIONS_MAX_RESPAWN_TEAM,
  LW6MAP_OPTIONS_MAX_MOVES_PER_ROUND,
  LW6MAP_OPTIONS_MAX_SPREADS_PER_ROUND,
  LW6MAP_OPTIONS_MAX_ROUNDS_PER_SEC,
  LW6MAP_OPTIONS_MAX_FIGHTER_ATTACK,
  LW6MAP_OPTIONS_MAX_FIGHTER_DEFENSE,
  LW6MAP_OPTIONS_MAX_FIGHTER_NEW_HEALTH,
  LW6MAP_OPTIONS_MAX_SIDE_ATTACK_FACTOR,
  LW6MAP_OPTIONS_MAX_SIDE_DEFENSE_FACTOR,
  LW6MAP_OPTIONS_MAX_NB_MOVE_TRIES,
  LW6MAP_OPTIONS_MAX_NB_ATTACK_TRIES,
  LW6MAP_OPTIONS_MAX_NB_DEFENSE_TRIES,
  LW6MAP_OPTIONS_MAX_SINGLE_ARMY_SURFACE,
  LW6MAP_OPTIONS_MAX_TOTAL_ARMIES_SURFACE,
  LW6MAP_OPTIONS_MAX_MAX_NB_TEAMS,
  LW6MAP_OPTIONS_MAX_X_POLARITY,
  LW6MAP_OPTIONS_MAX_Y_POLARITY,
  LW6MAP_OPTIONS_MAX_MAX_ZONE_SIZE,
  LW6MAP_OPTIONS_MAX_MIN_MAP_WIDTH,
  LW6MAP_OPTIONS_MAX_MAX_MAP_WIDTH,
  LW6MAP_OPTIONS_MAX_MIN_MAP_HEIGHT,
  LW6MAP_OPTIONS_MAX_MAX_MAP_HEIGHT,
  LW6MAP_OPTIONS_MAX_MIN_MAP_SURFACE,
  LW6MAP_OPTIONS_MAX_MAX_MAP_SURFACE,
  LW6MAP_OPTIONS_MAX_BOT_WAIT_BETWEEN_MOVES,
  LW6MAP_OPTIONS_MAX_BOT_NB_MOVE_STEPS,
  LW6MAP_OPTIONS_MAX_ROUND_DELTA,
  LW6MAP_OPTIONS_MAX_MAX_ROUND_DELTA,
  LW6MAP_OPTIONS_MAX_MAX_CURSOR_POT,
  LW6MAP_OPTIONS_MAX_CURSOR_POT_INIT,
  LW6MAP_OPTIONS_MAX_MAX_CURSOR_POT_OFFSET
};

void
lw6map_options_defaults (lw6map_options_t * options)
{
  lw6map_options_copy (options, &default_options);
}

void
lw6map_options_copy (lw6map_options_t * dst, lw6map_options_t * src)
{
  /*
   * Note that in this context, we'd better not use strings
   * in this structure, or code would become a bit more complex.
   */
  memcpy (dst, src, sizeof (lw6map_options_t));
}

void
lw6map_options_update_checksum (lw6map_options_t *
				options, u_int32_t * checksum)
{
  lw6sys_checksum_update_int32 (checksum, options->total_time);
  lw6sys_checksum_update_int32 (checksum, options->respawn_team);
  lw6sys_checksum_update_int32 (checksum, options->moves_per_round);
  lw6sys_checksum_update_int32 (checksum, options->spreads_per_round);
  lw6sys_checksum_update_int32 (checksum, options->rounds_per_sec);
  lw6sys_checksum_update_int32 (checksum, options->fighter_attack);
  lw6sys_checksum_update_int32 (checksum, options->fighter_defense);
  lw6sys_checksum_update_int32 (checksum, options->fighter_new_health);
  lw6sys_checksum_update_int32 (checksum, options->side_attack_factor);
  lw6sys_checksum_update_int32 (checksum, options->side_defense_factor);
  lw6sys_checksum_update_int32 (checksum, options->nb_move_tries);
  lw6sys_checksum_update_int32 (checksum, options->nb_attack_tries);
  lw6sys_checksum_update_int32 (checksum, options->nb_defense_tries);
  lw6sys_checksum_update_int32 (checksum, options->single_army_surface);
  lw6sys_checksum_update_int32 (checksum, options->total_armies_surface);
  lw6sys_checksum_update_int32 (checksum, options->max_nb_teams);
  lw6sys_checksum_update_int32 (checksum, options->x_polarity);
  lw6sys_checksum_update_int32 (checksum, options->y_polarity);
  lw6sys_checksum_update_int32 (checksum, options->max_zone_size);
  lw6sys_checksum_update_int32 (checksum, options->min_map_width);
  lw6sys_checksum_update_int32 (checksum, options->max_map_width);
  lw6sys_checksum_update_int32 (checksum, options->min_map_height);
  lw6sys_checksum_update_int32 (checksum, options->max_map_height);
  lw6sys_checksum_update_int32 (checksum, options->min_map_surface);
  lw6sys_checksum_update_int32 (checksum, options->max_map_surface);
  lw6sys_checksum_update_int32 (checksum, options->bot_wait_between_moves);
  lw6sys_checksum_update_int32 (checksum, options->bot_nb_move_steps);
  lw6sys_checksum_update_int32 (checksum, options->round_delta);
  lw6sys_checksum_update_int32 (checksum, options->max_round_delta);
  lw6sys_checksum_update_int32 (checksum, options->max_cursor_pot);
  lw6sys_checksum_update_int32 (checksum, options->cursor_pot_init);
  lw6sys_checksum_update_int32 (checksum, options->max_cursor_pot_offset);
}

int32_t *
get_options_int_ptr (lw6map_options_t * options, char *key)
{
  int32_t *ret = NULL;

  if (options && key)
    {
      if (!strcmp (key, "total-time"))
	{
	  ret = &(options->total_time);
	}
      else if (!strcmp (key, "respawn-team"))
	{
	  ret = &(options->respawn_team);
	}
      else if (!strcmp (key, "moves-per-round"))
	{
	  ret = &(options->moves_per_round);
	}
      else if (!strcmp (key, "spreads-per-round"))
	{
	  ret = &(options->spreads_per_round);
	}
      else if (!strcmp (key, "rounds-per-sec"))
	{
	  ret = &(options->rounds_per_sec);
	}
      else if (!strcmp (key, "fighter-attack"))
	{
	  ret = &(options->fighter_attack);
	}
      else if (!strcmp (key, "fighter-defense"))
	{
	  ret = &(options->fighter_defense);
	}
      else if (!strcmp (key, "fighter-new-health"))
	{
	  ret = &(options->fighter_new_health);
	}
      else if (!strcmp (key, "side-attack-factor"))
	{
	  ret = &(options->side_attack_factor);
	}
      else if (!strcmp (key, "side-defense-factor"))
	{
	  ret = &(options->side_defense_factor);
	}
      else if (!strcmp (key, "nb-move-tries"))
	{
	  ret = &(options->nb_move_tries);
	}
      else if (!strcmp (key, "nb-attack-tries"))
	{
	  ret = &(options->nb_attack_tries);
	}
      else if (!strcmp (key, "nb-defense-tries"))
	{
	  ret = &(options->nb_defense_tries);
	}
      else if (!strcmp (key, "single-army-surface"))
	{
	  ret = &(options->single_army_surface);
	}
      else if (!strcmp (key, "total-armies-surface"))
	{
	  ret = &(options->total_armies_surface);
	}
      else if (!strcmp (key, "max-nb-teams"))
	{
	  ret = &(options->max_nb_teams);
	}
      else if (!strcmp (key, "x-polarity"))
	{
	  ret = &(options->x_polarity);
	}
      else if (!strcmp (key, "y-polarity"))
	{
	  ret = &(options->y_polarity);
	}
      else if (!strcmp (key, "max-zone-size"))
	{
	  ret = &(options->max_zone_size);
	}
      else if (!strcmp (key, "min-map-width"))
	{
	  ret = &(options->min_map_width);
	}
      else if (!strcmp (key, "max-map-width"))
	{
	  ret = &(options->max_map_width);
	}
      else if (!strcmp (key, "min-map-height"))
	{
	  ret = &(options->min_map_height);
	}
      else if (!strcmp (key, "max-map-height"))
	{
	  ret = &(options->max_map_height);
	}
      else if (!strcmp (key, "min-map-surface"))
	{
	  ret = &(options->min_map_surface);
	}
      else if (!strcmp (key, "max-map-surface"))
	{
	  ret = &(options->max_map_surface);
	}
      else if (!strcmp (key, "bot-wait-between-moves"))
	{
	  ret = &(options->bot_wait_between_moves);
	}
      else if (!strcmp (key, "bot-nb-move-steps"))
	{
	  ret = &(options->bot_nb_move_steps);
	}
      else if (!strcmp (key, "round-delta"))
	{
	  ret = &(options->round_delta);
	}
      else if (!strcmp (key, "max-round-delta"))
	{
	  ret = &(options->max_round_delta);
	}
      else if (!strcmp (key, "max-cursor-pot"))
	{
	  ret = &(options->max_cursor_pot);
	}
      else if (!strcmp (key, "cursor-pot-init"))
	{
	  ret = &(options->cursor_pot_init);
	}
      else if (!strcmp (key, "max-cursor-pot-offset"))
	{
	  ret = &(options->max_cursor_pot_offset);
	}
      else
	{
	  lw6sys_log (LW6SYS_LOG_WARNING,
		      _
		      ("static options key \"%s\" does not exist, can't get a pointer on its value"),
		      key);
	}
    }

  return ret;
}

int32_t
lw6map_options_get_default (char *key)
{
  int32_t *ptr;
  int32_t ret = 0;

  ptr = get_options_int_ptr (&default_options, key);
  if (ptr)
    {
      ret = (*ptr);
    }

  return ret;
}

int32_t
lw6map_options_get_min (char *key)
{
  int32_t *ptr;
  int32_t ret = 0;

  ptr = get_options_int_ptr (&min_options, key);
  if (ptr)
    {
      ret = (*ptr);
    }

  return ret;
}

int32_t
lw6map_options_get_max (char *key)
{
  int32_t *ptr;
  int32_t ret = 0;

  ptr = get_options_int_ptr (&max_options, key);
  if (ptr)
    {
      ret = (*ptr);
    }

  return ret;
}

int32_t
lw6map_options_get_int (lw6map_options_t * options, char *key)
{
  int32_t ret = 0;
  int32_t *ptr;
  int32_t min_value;
  int32_t max_value;

  ptr = get_options_int_ptr (options, key);
  if (ptr)
    {
      min_value = lw6map_options_get_min (key);
      max_value = lw6map_options_get_max (key);
      if ((*ptr) < min_value)
	{
	  lw6sys_log (LW6SYS_LOG_WARNING,
		      _
		      ("can't get static option \"%s\" (%d), it's too small, returning min value %d instead"),
		      key, (*ptr), min_value);
	  ret = min_value;
	}
      else if ((*ptr) > max_value)
	{
	  lw6sys_log (LW6SYS_LOG_WARNING,
		      _
		      ("can't get static option \"%s\" (%d), it's too big, returning max value %d instead"),
		      key, (*ptr), max_value);
	  ret = max_value;
	}
      else
	{
	  ret = (*ptr);
	}
    }

  return ret;
}

int
lw6map_options_set_int (lw6map_options_t * options, char *key, int32_t value)
{
  int32_t *ptr;
  int32_t min_value;
  int32_t max_value;
  int ret = 0;

  ptr = get_options_int_ptr (options, key);
  if (ptr)
    {
      min_value = lw6map_options_get_min (key);
      max_value = lw6map_options_get_max (key);
      if (value < min_value)
	{
	  lw6sys_log (LW6SYS_LOG_WARNING,
		      _
		      ("can't set static option \"%s\" to value %d, it's too small, using min value %d"),
		      key, value, min_value);
	  (*ptr) = min_value;
	}
      else if (value > max_value)
	{
	  lw6sys_log (LW6SYS_LOG_WARNING,
		      _
		      ("can't set static option \"%s\" to value %d, it's too big, using max value %d"),
		      key, value, max_value);
	  (*ptr) = max_value;
	}
      else
	{
	  (*ptr) = value;
	}
      ret = 1;
    }

  return ret;
}

int
lw6map_options_get_bool (lw6map_options_t * options, char *key)
{
  return lw6map_options_get_int (options, key) ? 1 : 0;
}

int
lw6map_options_set_bool (lw6map_options_t * options, char *key, int value)
{
  return lw6map_options_set_int (options, key, value ? 1 : 0);
}

void
lw6map_options_clear (lw6map_options_t * options)
{
  if (options)
    {
      memset (options, 0, sizeof (lw6map_options_t));
    }
}
