/*
  Liquid War 6 is a unique multiplayer wargame.
  Copyright (C)  2005, 2006, 2007, 2008  Christian Mauduit <ufoot@ufoot.org>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.


  Liquid War 6 homepage : http://www.gnu.org/software/liquidwar6/
  Contact author        : ufoot@ufoot.org
*/

#include <string.h>

#include "config.h"
#include "map.h"

void
lw6map_param_defaults (lw6map_param_t * param)
{
  lw6map_options_defaults (&(param->options));
  lw6map_style_defaults (&(param->style));
}

/*
 * Clears a param.
 */
void
lw6map_param_clear (lw6map_param_t * param)
{
  if (param)
    {
      lw6map_options_clear (&(param->options));
      lw6map_style_clear (&(param->style));

      /*
       * We don't free the param pointer itself, this
       * is a "clear" function, not a "free".
       */
    }
}

/*
 * Like with clear, *dst must be either initialized or
 * totally zeroed, else function will fail (core dump)
 */
void
lw6map_param_copy (lw6map_param_t * dst, lw6map_param_t * src)
{
  lw6map_options_copy (&(dst->options), &(src->options));
  lw6map_style_copy (&(dst->style), &(src->style));
}

void
lw6map_param_set_int (lw6map_param_t * param, char *key, int value)
{
}

void
lw6map_param_set_bool (lw6map_param_t * param, char *key, int value)
{
}

void
lw6map_param_set_float (lw6map_param_t * param, char *key, float value)
{
}

void
lw6map_param_set_string (lw6map_param_t * param, char *key, char *value)
{
}

/*
 * For colors, we should probably read them as strings, or have
 * the right type in Guile.
 */
