/*
  Liquid War 6 is a unique multiplayer wargame.
  Copyright (C)  2005, 2006, 2007, 2008  Christian Mauduit <ufoot@ufoot.org>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.


  Liquid War 6 homepage : http://www.gnu.org/software/liquidwar6/
  Contact author        : ufoot@ufoot.org
*/

#include <string.h>
#include <math.h>

#include "config.h"
#include "map.h"

void
lw6map_resampler_init (lw6map_resampler_t * resampler,
		       lw6map_options_t * static_options,
		       lw6sys_wh_t * source_shape,
		       lw6sys_wh_t * display_shape, float target_ratio,
		       float fighter_scale)
{
  lw6sys_wh_t target_shape;
  float f;

  memset (resampler, 0, sizeof (lw6map_resampler_t));

  target_shape.w = display_shape->w / fighter_scale;
  target_shape.h = display_shape->h / fighter_scale;

  if (target_shape.w > 0 && target_shape.h > 0)
    {
      f =
	target_ratio / (((float) target_shape.w) / ((float) target_shape.h));
      if (f > 1.0f)
	{
	  target_shape.w *= f;
	}
      else if (f < 1.0f)
	{
	  target_shape.h /= f;
	}
    }

  if (target_shape.w * target_shape.h > static_options->max_map_surface)
    {
      f =
	sqrt ((((float) target_shape.w) * ((float) target_shape.h)) /
	      ((float) static_options->max_map_surface));
      target_shape.w /= f;
      target_shape.h /= f;
    }

  if (target_shape.w * target_shape.h < static_options->min_map_surface)
    {
      f =
	sqrt (((float) static_options->min_map_surface) /
	      (((float) target_shape.w) * ((float) target_shape.h)));
      target_shape.w *= f;
      target_shape.h *= f;
    }

  target_shape.w = lw6sys_min (target_shape.w, static_options->max_map_width);
  target_shape.h =
    lw6sys_min (target_shape.h, static_options->max_map_height);

  target_shape.w = lw6sys_max (target_shape.w, static_options->min_map_width);
  target_shape.h =
    lw6sys_max (target_shape.h, static_options->min_map_height);

  resampler->target_shape = target_shape;
  resampler->source_shape = (*source_shape);
  resampler->scale_x =
    ((float) (resampler->target_shape.w)) /
    ((float) (resampler->source_shape.w));
  resampler->scale_y =
    ((float) (resampler->target_shape.h)) /
    ((float) (resampler->source_shape.h));
}

static void
check_bounds (int *x, int *y, lw6sys_wh_t * shape)
{
  (*x) = lw6sys_min ((*x), shape->w - 1);
  (*y) = lw6sys_min ((*y), shape->h - 1);
  (*x) = lw6sys_max ((*x), 0);
  (*y) = lw6sys_max ((*y), 0);
}

void
lw6map_resampler_source2target (lw6map_resampler_t * resampler, int *target_x,
				int *target_y, int source_x, int source_y)
{
  (*target_x) = (int) (source_x * resampler->scale_x);
  (*target_y) = (int) (source_y * resampler->scale_y);
  check_bounds (target_x, target_y, &(resampler->target_shape));
}

void
lw6map_resampler_target2source (lw6map_resampler_t * resampler, int *source_x,
				int *source_y, int target_x, int target_y)
{
  (*source_x) = (int) (target_x / resampler->scale_x);
  (*source_y) = (int) (target_y / resampler->scale_y);
  check_bounds (source_x, source_y, &(resampler->source_shape));
}
