/*
  Liquid War 6 is a unique multiplayer wargame.
  Copyright (C)  2005, 2006, 2007, 2008  Christian Mauduit <ufoot@ufoot.org>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.


  Liquid War 6 homepage : http://www.gnu.org/software/liquidwar6/
  Contact author        : ufoot@ufoot.org
*/

#include <string.h>

#include "config.h"
#include "map.h"

void
lw6map_style_defaults (lw6map_style_t * style)
{
  lw6map_style_clear (style);

  style->keep_ratio = LW6MAP_STYLE_DEFAULT_KEEP_RATIO;
  style->zoom = LW6MAP_STYLE_DEFAULT_ZOOM;
  style->fighter_scale = LW6MAP_STYLE_DEFAULT_FIGHTER_SCALE;
  style->use_texture = LW6MAP_STYLE_DEFAULT_USE_TEXTURE;
  style->background_style =
    lw6sys_str_copy (LW6MAP_STYLE_DEFAULT_BACKGROUND_STYLE);
  style->hud_style = lw6sys_str_copy (LW6MAP_STYLE_DEFAULT_HUD_STYLE);
  style->menu_style = lw6sys_str_copy (LW6MAP_STYLE_DEFAULT_MENU_STYLE);
  style->view_style = lw6sys_str_copy (LW6MAP_STYLE_DEFAULT_VIEW_STYLE);
  style->background_density = LW6MAP_STYLE_DEFAULT_BACKGROUND_DENSITY;
  style->background_speed = LW6MAP_STYLE_DEFAULT_BACKGROUND_SPEED;
  style->background_color_auto = LW6MAP_STYLE_DEFAULT_BACKGROUND_COLOR_AUTO;
  style->hud_color_auto = LW6MAP_STYLE_DEFAULT_HUD_COLOR_AUTO;
  style->menu_color_auto = LW6MAP_STYLE_DEFAULT_MENU_COLOR_AUTO;
  style->view_color_auto = LW6MAP_STYLE_DEFAULT_VIEW_COLOR_AUTO;
  style->system_color_auto = LW6MAP_STYLE_DEFAULT_SYSTEM_COLOR_AUTO;
  style->background_color_base.bg =
    lw6sys_color_a_to_8 (LW6MAP_STYLE_DEFAULT_BACKGROUND_COLOR_BASE_BG);
  style->background_color_base.fg =
    lw6sys_color_a_to_8 (LW6MAP_STYLE_DEFAULT_BACKGROUND_COLOR_BASE_FG);
  style->background_color_alternate.bg =
    lw6sys_color_a_to_8 (LW6MAP_STYLE_DEFAULT_BACKGROUND_COLOR_ALTERNATE_BG);
  style->background_color_alternate.fg =
    lw6sys_color_a_to_8 (LW6MAP_STYLE_DEFAULT_BACKGROUND_COLOR_ALTERNATE_FG);
  style->hud_color_frame.bg =
    lw6sys_color_a_to_8 (LW6MAP_STYLE_DEFAULT_HUD_COLOR_FRAME_BG);
  style->hud_color_frame.fg =
    lw6sys_color_a_to_8 (LW6MAP_STYLE_DEFAULT_HUD_COLOR_FRAME_FG);
  style->hud_color_text.bg =
    lw6sys_color_a_to_8 (LW6MAP_STYLE_DEFAULT_HUD_COLOR_TEXT_BG);
  style->hud_color_text.fg =
    lw6sys_color_a_to_8 (LW6MAP_STYLE_DEFAULT_HUD_COLOR_TEXT_FG);
  style->menu_color_default.bg =
    lw6sys_color_a_to_8 (LW6MAP_STYLE_DEFAULT_MENU_COLOR_DEFAULT_BG);
  style->menu_color_default.fg =
    lw6sys_color_a_to_8 (LW6MAP_STYLE_DEFAULT_MENU_COLOR_DEFAULT_FG);
  style->menu_color_selected.bg =
    lw6sys_color_a_to_8 (LW6MAP_STYLE_DEFAULT_MENU_COLOR_SELECTED_BG);
  style->menu_color_selected.fg =
    lw6sys_color_a_to_8 (LW6MAP_STYLE_DEFAULT_MENU_COLOR_SELECTED_FG);
  style->menu_color_disabled.bg =
    lw6sys_color_a_to_8 (LW6MAP_STYLE_DEFAULT_MENU_COLOR_DISABLED_BG);
  style->menu_color_disabled.fg =
    lw6sys_color_a_to_8 (LW6MAP_STYLE_DEFAULT_MENU_COLOR_DISABLED_FG);
  style->view_color_cursor.bg =
    lw6sys_color_a_to_8 (LW6MAP_STYLE_DEFAULT_VIEW_COLOR_CURSOR_BG);
  style->view_color_cursor.fg =
    lw6sys_color_a_to_8 (LW6MAP_STYLE_DEFAULT_VIEW_COLOR_CURSOR_FG);
  style->view_color_map.bg =
    lw6sys_color_a_to_8 (LW6MAP_STYLE_DEFAULT_VIEW_COLOR_MAP_BG);
  style->view_color_map.fg =
    lw6sys_color_a_to_8 (LW6MAP_STYLE_DEFAULT_VIEW_COLOR_MAP_FG);
  style->system_color.bg =
    lw6sys_color_a_to_8 (LW6MAP_STYLE_DEFAULT_SYSTEM_COLOR_BG);
  style->system_color.fg =
    lw6sys_color_a_to_8 (LW6MAP_STYLE_DEFAULT_SYSTEM_COLOR_FG);
  style->team_colors[LW6MAP_TEAM_COLOR_RED] =
    lw6sys_color_a_to_8 (LW6MAP_STYLE_DEFAULT_TEAM_COLOR_RED);
  style->team_colors[LW6MAP_TEAM_COLOR_GREEN] =
    lw6sys_color_a_to_8 (LW6MAP_STYLE_DEFAULT_TEAM_COLOR_GREEN);
  style->team_colors[LW6MAP_TEAM_COLOR_BLUE] =
    lw6sys_color_a_to_8 (LW6MAP_STYLE_DEFAULT_TEAM_COLOR_BLUE);
  style->team_colors[LW6MAP_TEAM_COLOR_YELLOW] =
    lw6sys_color_a_to_8 (LW6MAP_STYLE_DEFAULT_TEAM_COLOR_YELLOW);
  style->team_colors[LW6MAP_TEAM_COLOR_CYAN] =
    lw6sys_color_a_to_8 (LW6MAP_STYLE_DEFAULT_TEAM_COLOR_CYAN);
  style->team_colors[LW6MAP_TEAM_COLOR_MAGENTA] =
    lw6sys_color_a_to_8 (LW6MAP_STYLE_DEFAULT_TEAM_COLOR_MAGENTA);
  style->team_colors[LW6MAP_TEAM_COLOR_ORANGE] =
    lw6sys_color_a_to_8 (LW6MAP_STYLE_DEFAULT_TEAM_COLOR_ORANGE);
  style->team_colors[LW6MAP_TEAM_COLOR_LIGHTBLUE] =
    lw6sys_color_a_to_8 (LW6MAP_STYLE_DEFAULT_TEAM_COLOR_LIGHTBLUE);
  style->team_colors[LW6MAP_TEAM_COLOR_PURPLE] =
    lw6sys_color_a_to_8 (LW6MAP_STYLE_DEFAULT_TEAM_COLOR_PURPLE);
  style->team_colors[LW6MAP_TEAM_COLOR_PINK] =
    lw6sys_color_a_to_8 (LW6MAP_STYLE_DEFAULT_TEAM_COLOR_PINK);
}

/*
 * Note that this function won't work on an unitialized
 * structure, structure must be zeroed by some CALLOC
 * or something, else automatic freeing of pointers
 * will fail.
 */
void
lw6map_style_clear (lw6map_style_t * style)
{
  if (style)
    {
      if (style->background_style)
	{
	  LW6SYS_FREE (style->background_style);
	}

      if (style->hud_style)
	{
	  LW6SYS_FREE (style->hud_style);
	}

      if (style->menu_style)
	{
	  LW6SYS_FREE (style->menu_style);
	}

      if (style->view_style)
	{
	  LW6SYS_FREE (style->view_style);
	}

      memset (style, 0, sizeof (lw6map_style_t));
    }
}

/*
 * Like with clear, *dst must be either initialized or
 * totally zeroed, else function will fail (core dump)
 */
void
lw6map_style_copy (lw6map_style_t * dst, lw6map_style_t * src)
{
  lw6map_style_clear (dst);
  memcpy (dst, src, sizeof (lw6map_style_t));

  if (src->background_style)
    {
      dst->background_style = lw6sys_str_copy (src->background_style);
    }
  if (src->hud_style)
    {
      dst->hud_style = lw6sys_str_copy (src->hud_style);
    }
  if (src->menu_style)
    {
      dst->menu_style = lw6sys_str_copy (src->menu_style);
    }
  if (src->view_style)
    {
      dst->view_style = lw6sys_str_copy (src->view_style);
    }
}

int
lw6map_style_set (lw6map_style_t * style, char *key, char *value)
{
  int ret = 1;

  if (lw6sys_arg_match ("keep-ratio", key))
    {
      style->keep_ratio = lw6sys_atob (value);
    }
  else if (lw6sys_arg_match ("zoom", key))
    {
      style->zoom = lw6sys_atof (value);
    }
  else if (lw6sys_arg_match ("fighter-scale", key))
    {
      style->fighter_scale = lw6sys_atof (value);
    }
  else if (lw6sys_arg_match ("use-texture", key))
    {
      style->use_texture = lw6sys_atob (value);
    }
  else if (lw6sys_arg_match ("background-style", key))
    {
      if (style->background_style)
	{
	  LW6SYS_FREE (style->background_style);
	}
      style->background_style = lw6sys_str_copy (value);
    }
  else if (lw6sys_arg_match ("hud-style", key))
    {
      if (style->hud_style)
	{
	  LW6SYS_FREE (style->hud_style);
	}
      style->hud_style = lw6sys_str_copy (value);
    }
  else if (lw6sys_arg_match ("menu-style", key))
    {
      if (style->menu_style)
	{
	  LW6SYS_FREE (style->menu_style);
	}
      style->menu_style = lw6sys_str_copy (value);
    }
  else if (lw6sys_arg_match ("view-style", key))
    {
      if (style->view_style)
	{
	  LW6SYS_FREE (style->view_style);
	}
      style->view_style = lw6sys_str_copy (value);
    }
  else if (lw6sys_arg_match ("background-density", key))
    {
      style->background_density = lw6sys_atof (value);
    }
  else if (lw6sys_arg_match ("background-speed", key))
    {
      style->background_speed = lw6sys_atof (value);
    }
  else if (lw6sys_arg_match ("background-color-auto", key))
    {
      style->background_color_auto = lw6sys_atob (value);
    }
  else if (lw6sys_arg_match ("hud-color-auto", key))
    {
      style->hud_color_auto = lw6sys_atob (value);
    }
  else if (lw6sys_arg_match ("menu-color-auto", key))
    {
      style->menu_color_auto = lw6sys_atob (value);
    }
  else if (lw6sys_arg_match ("view-color-auto", key))
    {
      style->view_color_auto = lw6sys_atob (value);
    }
  else if (lw6sys_arg_match ("system-color-auto", key))
    {
      style->system_color_auto = lw6sys_atob (value);
    }
  else if (lw6sys_arg_match ("background-color-base-bg", key))
    {
      style->background_color_base.bg = lw6sys_color_a_to_8 (value);
    }
  else if (lw6sys_arg_match ("background-color-base-fg", key))
    {
      style->background_color_base.fg = lw6sys_color_a_to_8 (value);
    }
  else if (lw6sys_arg_match ("background-color-alternate-bg", key))
    {
      style->background_color_alternate.bg = lw6sys_color_a_to_8 (value);
    }
  else if (lw6sys_arg_match ("background-color-alternate-fg", key))
    {
      style->background_color_alternate.fg = lw6sys_color_a_to_8 (value);
    }
  else if (lw6sys_arg_match ("hud-color-frame-bg", key))
    {
      style->hud_color_frame.bg = lw6sys_color_a_to_8 (value);
    }
  else if (lw6sys_arg_match ("hud-color-frame-fg", key))
    {
      style->hud_color_frame.fg = lw6sys_color_a_to_8 (value);
    }
  else if (lw6sys_arg_match ("hud-color-text-bg", key))
    {
      style->hud_color_text.bg = lw6sys_color_a_to_8 (value);
    }
  else if (lw6sys_arg_match ("hud-color-text-fg", key))
    {
      style->hud_color_text.fg = lw6sys_color_a_to_8 (value);
    }
  else if (lw6sys_arg_match ("menu-color-default-bg", key))
    {
      style->menu_color_default.bg = lw6sys_color_a_to_8 (value);
    }
  else if (lw6sys_arg_match ("menu-color-default-fg", key))
    {
      style->menu_color_default.fg = lw6sys_color_a_to_8 (value);
    }
  else if (lw6sys_arg_match ("menu-color-selected-bg", key))
    {
      style->menu_color_selected.bg = lw6sys_color_a_to_8 (value);
    }
  else if (lw6sys_arg_match ("menu-color-selected-fg", key))
    {
      style->menu_color_selected.fg = lw6sys_color_a_to_8 (value);
    }
  else if (lw6sys_arg_match ("menu-color-disabled-bg", key))
    {
      style->menu_color_disabled.bg = lw6sys_color_a_to_8 (value);
    }
  else if (lw6sys_arg_match ("menu-color-disabled-fg", key))
    {
      style->menu_color_disabled.fg = lw6sys_color_a_to_8 (value);
    }
  else if (lw6sys_arg_match ("view-color-cursor-bg", key))
    {
      style->view_color_cursor.bg = lw6sys_color_a_to_8 (value);
    }
  else if (lw6sys_arg_match ("view-color-cursor-fg", key))
    {
      style->view_color_cursor.fg = lw6sys_color_a_to_8 (value);
    }
  else if (lw6sys_arg_match ("view-color-map-bg", key))
    {
      style->view_color_map.bg = lw6sys_color_a_to_8 (value);
    }
  else if (lw6sys_arg_match ("view-color-map-fg", key))
    {
      style->view_color_map.fg = lw6sys_color_a_to_8 (value);
    }
  else if (lw6sys_arg_match ("system-color-bg", key))
    {
      style->system_color.bg = lw6sys_color_a_to_8 (value);
    }
  else if (lw6sys_arg_match ("system-color-fg", key))
    {
      style->system_color.fg = lw6sys_color_a_to_8 (value);
    }
  else if (lw6sys_arg_match ("team-color-red", key))
    {
      style->team_colors[LW6MAP_TEAM_COLOR_RED] = lw6sys_color_a_to_8 (value);
    }
  else if (lw6sys_arg_match ("team-color-green", key))
    {
      style->team_colors[LW6MAP_TEAM_COLOR_GREEN] =
	lw6sys_color_a_to_8 (value);
    }
  else if (lw6sys_arg_match ("team-color-blue", key))
    {
      style->team_colors[LW6MAP_TEAM_COLOR_BLUE] =
	lw6sys_color_a_to_8 (value);
    }
  else if (lw6sys_arg_match ("team-color-yellow", key))
    {
      style->team_colors[LW6MAP_TEAM_COLOR_YELLOW] =
	lw6sys_color_a_to_8 (value);
    }
  else if (lw6sys_arg_match ("team-color-cyan", key))
    {
      style->team_colors[LW6MAP_TEAM_COLOR_CYAN] =
	lw6sys_color_a_to_8 (value);
    }
  else if (lw6sys_arg_match ("team-color-magenta", key))
    {
      style->team_colors[LW6MAP_TEAM_COLOR_MAGENTA] =
	lw6sys_color_a_to_8 (value);
    }
  else if (lw6sys_arg_match ("team-color-orange", key))
    {
      style->team_colors[LW6MAP_TEAM_COLOR_ORANGE] =
	lw6sys_color_a_to_8 (value);
    }
  else if (lw6sys_arg_match ("team-color-lightblue", key))
    {
      style->team_colors[LW6MAP_TEAM_COLOR_LIGHTBLUE] =
	lw6sys_color_a_to_8 (value);
    }
  else if (lw6sys_arg_match ("team-color-purple", key))
    {
      style->team_colors[LW6MAP_TEAM_COLOR_PURPLE] =
	lw6sys_color_a_to_8 (value);
    }
  else if (lw6sys_arg_match ("team-color-pink", key))
    {
      style->team_colors[LW6MAP_TEAM_COLOR_PINK] =
	lw6sys_color_a_to_8 (value);
    }
  else
    {
      ret = 0;			// no entry matches
    }

  return ret;
}
