/*
  Liquid War 6 is a unique multiplayer wargame.
  Copyright (C)  2005, 2006, 2007, 2008  Christian Mauduit <ufoot@ufoot.org>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.


  Liquid War 6 homepage : http://www.gnu.org/software/liquidwar6/
  Contact author        : ufoot@ufoot.org
*/

#include <string.h>

#include "config.h"
#include "map.h"

void
lw6map_texture_defaults (lw6map_texture_t * texture)
{
  int x, y;

  lw6map_texture_clear (texture);

  texture->shape.w = LW6MAP_OPTIONS_DEFAULT_MIN_MAP_WIDTH;
  texture->shape.h = LW6MAP_OPTIONS_DEFAULT_MIN_MAP_HEIGHT;
  texture->data =
    (lw6sys_color_8_t *) LW6SYS_MALLOC (texture->shape.w *
					texture->shape.h *
					sizeof (lw6sys_color_8_t *));

  if (texture->data)
    {
      for (y = 0; y < texture->shape.h; ++y)
	{
	  for (x = 0; x < texture->shape.w; ++x)
	    {
	      lw6map_texture_set (texture, x, y, LW6SYS_COLOR_8_WHITE);
	    }
	}
    }
  else
    {
      lw6sys_log (LW6SYS_LOG_WARNING,
		  _("unable to construct default map texture"));
      texture->shape.w = 0;
      texture->shape.h = 0;
    }
}

/*
 * Clears a texture.
 */
void
lw6map_texture_clear (lw6map_texture_t * texture)
{
  if (texture->data)
    {
      LW6SYS_FREE (texture->data);
    }

  memset (texture, 0, sizeof (lw6map_texture_t));
}

int
lw6map_texture_coord_from_depth (lw6map_level_t * level, int *texture_x,
				 int *texture_y, int depth_x, int depth_y)
{
  int ret = 0;

  if (level->depth.shape.w > 0 && level->depth.shape.h > 0)
    {
      (*texture_x) =
	(depth_x * level->texture.shape.w) / level->depth.shape.w;
      (*texture_y) =
	(depth_y * level->texture.shape.h) / level->depth.shape.h;
      (*texture_x) =
	lw6sys_max (0, lw6sys_min (level->texture.shape.w - 1, *texture_x));
      (*texture_y) =
	lw6sys_max (0, lw6sys_min (level->texture.shape.h - 1, *texture_y));
      ret = 1;
    }
  else
    {
      (*texture_x) = 0;
      (*texture_y) = 0;
    }

  return ret;
}

lw6sys_color_8_t
lw6map_texture_get_with_depth_coord (lw6map_level_t * level, int depth_x,
				     int depth_y)
{
  lw6sys_color_8_t ret = LW6SYS_COLOR_8_BLACK;
  int texture_x;
  int texture_y;

  if (lw6map_texture_coord_from_depth
      (level, &texture_x, &texture_y, depth_x, depth_y))
    {
      ret = lw6map_texture_get (&level->texture, texture_x, texture_y);
    }

  return ret;
}
