
/*
  Liquid War 6 is a unique multiplayer wargame.
  Copyright (C)  2005, 2006, 2007, 2008  Christian Mauduit <ufoot@ufoot.org>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.
  

  Liquid War 6 homepage : http://www.gnu.org/software/liquidwar6/
  Contact author        : ufoot@ufoot.org
*/

#include <sys/types.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <sys/socket.h>
#include <sys/signal.h>
#include <fcntl.h>
#include <unistd.h>
#include <string.h>
#include <errno.h>

#include "config.h"
#include "net.h"
#include "net-internal.h"

int
lw6net_udp_client ()
{
  int sock;

  sock = socket (AF_INET, SOCK_DGRAM, 0);

  sock = (sock >= 0) ? sock : -1;

  if (sock >= 0)
    {
      lw6sys_log (LW6SYS_LOG_INFO, _("new UDP socket %d"), sock);
      _lw6net_global_context->socket_counters.open_counter++;

      fcntl (sock, F_SETFL, O_NONBLOCK);
    }

  return sock;
}

int
lw6net_udp_server (char *ip, int port)
{
  int sock;

  sock = _lw6net_socket_bind (ip, port, SOCK_DGRAM);
  if (sock >= 0)
    {
      fcntl (sock, F_SETFL, O_NONBLOCK);
    }

  return sock;
}

int
lw6net_udp_send (int sock, char *buf, int len, char *ip, int port)
{
  int size_send = 0;
  struct sockaddr_in name;
  int res;

  name.sin_family = AF_INET;
  if (inet_aton (ip, &name.sin_addr) != 0)
    {
      name.sin_port = htons (port);
      res =
	sendto (sock, buf, len, 0, (struct sockaddr *) &name, sizeof (name));
      if (res >= 0)
	{
	  size_send = res;
	}
    }

  return size_send;
}

static int
udp_recv (int sock, char *buf,
	  int len, char **incoming_ip, int *incoming_port, int flag)
{
  int recv_size = 0;
  struct sockaddr_in name;
  socklen_t namelen = sizeof (struct sockaddr_in);
  int res;

  memset (&name, 0, sizeof (name));

  res = recvfrom (sock, buf, len, flag, (struct sockaddr *) &name, &namelen);
  if (res >= 0)
    {
      recv_size = res;
      if (incoming_ip)
	{
	  (*incoming_ip) = _lw6net_inet_ntoa (name.sin_addr);
	}
      if (incoming_port)
	{
	  (*incoming_port) = (int) ntohs (name.sin_port);
	}
    }
  else
    {
      if (incoming_ip)
	{
	  (*incoming_ip) = NULL;
	}
      if (incoming_port)
	{
	  (*incoming_port) = 0;
	}
    }

  return recv_size;
}

int
lw6net_udp_peek (int sock, char *buf, int len,
		 char **incoming_ip, int *incoming_port)
{
  return udp_recv (sock, buf, len, incoming_ip, incoming_port, MSG_PEEK);
}

int
lw6net_udp_recv (int sock, char *buf,
		 int len, char **incoming_ip, int *incoming_port)
{
  return udp_recv (sock, buf, len, incoming_ip, incoming_port, 0);
}
