/*
  Liquid War 6 is a unique multiplayer wargame.
  Copyright (C)  2005, 2006, 2007, 2008  Christian Mauduit <ufoot@ufoot.org>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.


  Liquid War 6 homepage : http://www.gnu.org/software/liquidwar6/
  Contact author        : ufoot@ufoot.org
*/

#include <stdio.h>
#include <string.h>

#include "config.h"
#include "../snd.h"
#include "mod-ogg.h"
#include "mod-ogg-internal.h"


static int
play_sound (void *snd_context, int sound_id)
{
  int ret = 0;

  _mod_ogg_context_t *mod_ogg_context = (_mod_ogg_context_t *) snd_context;

  if (mod_ogg_context)
    {
      ret = _mod_ogg_play_sound (mod_ogg_context, sound_id);
    }

  return ret;
}

static int
play_music (void *snd_context, char *music_name)
{
  int ret = 0;

  _mod_ogg_context_t *mod_ogg_context = (_mod_ogg_context_t *) snd_context;

  if (mod_ogg_context)
    {
      ret = _mod_ogg_play_music (mod_ogg_context, music_name);
    }

  return ret;
}

static void *
init (int argc, char *argv[], float sound_volume, float music_volume)
{
  _mod_ogg_context_t *mod_ogg_context =
    _mod_ogg_init (argc, argv, sound_volume, music_volume);

  return (void *) mod_ogg_context;
}

static void
set_sound_volume (void *snd_context, float volume)
{
  _mod_ogg_context_t *mod_ogg_context = (_mod_ogg_context_t *) snd_context;

  if (mod_ogg_context)
    {
      _mod_ogg_set_sound_volume (mod_ogg_context, volume);
    }
}

static void
set_music_volume (void *snd_context, float volume)
{
  _mod_ogg_context_t *mod_ogg_context = (_mod_ogg_context_t *) snd_context;

  if (mod_ogg_context)
    {
      _mod_ogg_set_music_volume (mod_ogg_context, volume);
    }
}

static void
quit (void *snd_context)
{
  _mod_ogg_context_t *mod_ogg_context = (_mod_ogg_context_t *) snd_context;

  if (mod_ogg_context)
    {
      _mod_ogg_quit (mod_ogg_context);
    }
}

lw6snd_backend_t *
mod_ogg_create_backend ()
{
  lw6snd_backend_t *backend;

  backend = LW6SYS_MALLOC (sizeof (lw6snd_backend_t));
  if (backend)
    {
      memset (backend, 0, sizeof (lw6snd_backend_t));

      backend->play_sound = play_sound;
      backend->play_music = play_music;
      backend->init = init;
      backend->set_sound_volume = set_sound_volume;
      backend->set_music_volume = set_music_volume;
      backend->quit = quit;
    }

  return backend;
}
