
/*
  Liquid War 6 is a unique multiplayer wargame.
  Copyright (C)  2005, 2006, 2007, 2008  Christian Mauduit <ufoot@ufoot.org>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.
  

  Liquid War 6 homepage : http://www.gnu.org/software/liquidwar6/
  Contact author        : ufoot@ufoot.org
*/

#include <string.h>

#include "config.h"
#include "snd.h"
#include "mod-csound/mod-csound.h"
#include "mod-ogg/mod-ogg.h"

lw6sys_assoc_t *
lw6snd_get_backends (int argc, char *argv[])
{
  lw6sys_assoc_t *ret = NULL;

  ret = lw6sys_assoc_new (NULL);
  if (ret)
    {
      lw6sys_assoc_set (&ret, "ogg", (void *) _("Ogg Vorbis"));
      lw6sys_assoc_set (&ret, "csound", (void *) _("Csound"));
    }

  return ret;
}

lw6snd_backend_t *
lw6snd_create_backend (int argc, char *argv[], char *name)
{
  lw6snd_backend_t *backend = NULL;

#ifdef MOD_CSOUND
  if (name && !strcmp (name, "csound"))
    {
      backend = mod_csound_create_backend ();
    }
#endif
#ifdef MOD_OGG
  if (name && !strcmp (name, "ogg"))
    {
      backend = mod_ogg_create_backend ();
    }
#endif

  if (backend)
    {
      backend->argc = argc;
      backend->argv = argv;
    }
  else
    {
      lw6sys_log (LW6SYS_LOG_WARNING,
		  _("sound backend \"%s\" does not exist"), name);
    }

  return backend;
}

void
lw6snd_destroy_backend (lw6snd_backend_t * backend)
{
  LW6SYS_FREE (backend);
}
