/*
  Liquid War 6 is a unique multiplayer wargame.
  Copyright (C)  2005, 2006, 2007, 2008  Christian Mauduit <ufoot@ufoot.org>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.


  Liquid War 6 homepage : http://www.gnu.org/software/liquidwar6/
  Contact author        : ufoot@ufoot.org
*/

#include <stdio.h>
#include <string.h>

#include "config.h"
#include "../srv.h"
#include "mod-tcpd.h"
#include "mod-tcpd-internal.h"

static void *
init ()
{
  _tcpd_context_t *tcpd_context = _mod_tcpd_init ();

  return (void *) tcpd_context;
}

static void
quit (void *srv_context)
{
  _tcpd_context_t *tcpd_context = (_tcpd_context_t *) srv_context;

  if (tcpd_context)
    {
      _mod_tcpd_quit (tcpd_context);
    }
}

static int
can_handle_tcp (void *srv_context, lw6srv_tcp_accepter_t * tcp_accepter)
{
  _tcpd_context_t *tcpd_context = (_tcpd_context_t *) srv_context;
  int ret = 0;

  if (tcpd_context)
    {
      ret = _mod_tcpd_can_handle_tcp (tcpd_context, tcp_accepter);
    }

  return ret;
}

static int
can_handle_udp (void *srv_context, lw6srv_udp_buffer_t * udp_buffer)
{
  _tcpd_context_t *tcpd_context = (_tcpd_context_t *) srv_context;
  int ret = 0;

  if (tcpd_context)
    {
      ret = _mod_tcpd_can_handle_udp (tcpd_context, udp_buffer);
    }

  return ret;
}

static lw6srv_connection_t *
accept_tcp (void *srv_context, lw6srv_tcp_accepter_t * tcp_accepter,
	    char *password)
{
  _tcpd_context_t *tcpd_context = (_tcpd_context_t *) srv_context;
  lw6srv_connection_t *ret = NULL;

  if (tcpd_context)
    {
      ret = _mod_tcpd_accept_tcp (tcpd_context, tcp_accepter, password);
    }

  return ret;
}

static lw6srv_connection_t *
new_udp (void *srv_context, lw6srv_udp_buffer_t * udp_buffer, char *password)
{
  _tcpd_context_t *tcpd_context = (_tcpd_context_t *) srv_context;
  lw6srv_connection_t *ret = NULL;

  if (tcpd_context)
    {
      ret = _mod_tcpd_new_udp (tcpd_context, udp_buffer, password);
    }

  return ret;
}

static int
is_associated_with_udp (void *srv_context, lw6srv_connection_t * connection,
			lw6srv_udp_buffer_t * udp_buffer)
{
  _tcpd_context_t *tcpd_context = (_tcpd_context_t *) srv_context;
  int ret = 0;

  if (tcpd_context)
    {
      ret =
	_mod_tcpd_is_associated_with_udp (tcpd_context, connection,
					  udp_buffer);
    }

  return ret;
}

static int
update_with_udp (void *srv_context, lw6srv_connection_t * connection,
		 lw6srv_udp_buffer_t * udp_buffer)
{
  _tcpd_context_t *tcpd_context = (_tcpd_context_t *) srv_context;
  int ret = 0;

  if (tcpd_context)
    {
      ret = _mod_tcpd_update_with_udp (tcpd_context, connection, udp_buffer);
    }

  return ret;
}

static void
close (void *srv_context, lw6srv_connection_t * connection)
{
  _tcpd_context_t *tcpd_context = (_tcpd_context_t *) srv_context;
  if (tcpd_context)
    {
      _mod_tcpd_close (tcpd_context, connection);
    }
}

static int
send (void *srv_context, lw6srv_connection_t * connection, char *message)
{
  _tcpd_context_t *tcpd_context = (_tcpd_context_t *) srv_context;
  int ret = 0;

  if (tcpd_context)
    {
      ret = _mod_tcpd_send (tcpd_context, connection, message);
    }

  return ret;
}

static char *
recv (void *srv_context, lw6srv_connection_t * connection)
{
  _tcpd_context_t *tcpd_context = (_tcpd_context_t *) srv_context;
  char *ret = NULL;

  if (tcpd_context)
    {
      ret = _mod_tcpd_recv (tcpd_context, connection);
    }

  return ret;
}

static int
is_alive (void *srv_context, lw6srv_connection_t * connection)
{
  _tcpd_context_t *tcpd_context = (_tcpd_context_t *) srv_context;
  int ret = 0;

  if (tcpd_context)
    {
      ret = _mod_tcpd_is_alive (tcpd_context, connection);
    }

  return ret;
}

static char *
repr (void *srv_context, lw6srv_connection_t * connection)
{
  _tcpd_context_t *tcpd_context = (_tcpd_context_t *) srv_context;
  char *ret = NULL;

  if (tcpd_context)
    {
      ret = _mod_tcpd_repr (tcpd_context, connection);
    }

  return ret;
}

static char *
error (void *srv_context, lw6srv_connection_t * connection)
{
  _tcpd_context_t *tcpd_context = (_tcpd_context_t *) srv_context;
  char *ret = NULL;

  if (tcpd_context)
    {
      ret = _mod_tcpd_error (tcpd_context, connection);
    }

  return ret;
}

lw6srv_backend_t *
mod_tcpd_create_backend ()
{
  lw6srv_backend_t *backend;

  backend = LW6SYS_MALLOC (sizeof (lw6srv_backend_t));
  if (backend)
    {
      memset (backend, 0, sizeof (lw6srv_backend_t));

      backend->init = init;
      backend->quit = quit;
      backend->can_handle_tcp = can_handle_tcp;
      backend->can_handle_udp = can_handle_udp;
      backend->accept_tcp = accept_tcp;
      backend->new_udp = new_udp;
      backend->is_associated_with_udp = is_associated_with_udp;
      backend->update_with_udp = update_with_udp;
      backend->close = close;
      backend->send = send;
      backend->recv = recv;
      backend->is_alive = is_alive;
      backend->repr = repr;
      backend->error = error;
    }

  return backend;
}
