
/*
  Liquid War 6 is a unique multiplayer wargame.
  Copyright (C)  2005, 2006, 2007, 2008  Christian Mauduit <ufoot@ufoot.org>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.
  

  Liquid War 6 homepage : http://www.gnu.org/software/liquidwar6/
  Contact author        : ufoot@ufoot.org
*/

#include "config.h"
#include "../srv.h"
#include "mod-tcpd-internal.h"

_tcpd_context_t *
_mod_tcpd_init ()
{
  _tcpd_context_t *srv_context = NULL;

  srv_context = (_tcpd_context_t *) LW6SYS_CALLOC (sizeof (_tcpd_context_t));
  if (!srv_context)
    {
      /*
       * No use to continue if this basic malloc fails...
       */
      exit (1);
    }

  lw6sys_log (LW6SYS_LOG_INFO, _("tcpd init"));

  return srv_context;
}

void
_mod_tcpd_quit (_tcpd_context_t * srv_context)
{
  lw6sys_log (LW6SYS_LOG_INFO, _("tcpd quit"));
  LW6SYS_FREE (srv_context);
}
