/*
  Liquid War 6 is a unique multiplayer wargame.
  Copyright (C)  2005, 2006, 2007, 2008  Christian Mauduit <ufoot@ufoot.org>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.


  Liquid War 6 homepage : http://www.gnu.org/software/liquidwar6/
  Contact author        : ufoot@ufoot.org
*/

#include <stdio.h>
#include <string.h>

#include "config.h"
#include "../srv.h"
#include "mod-udpd.h"
#include "mod-udpd-internal.h"

static void *
init ()
{
  _udpd_context_t *udpd_context = _mod_udpd_init ();

  return (void *) udpd_context;
}

static void
quit (void *srv_context)
{
  _udpd_context_t *udpd_context = (_udpd_context_t *) srv_context;

  if (udpd_context)
    {
      _mod_udpd_quit (udpd_context);
    }
}

static int
can_handle_tcp (void *srv_context, lw6srv_tcp_accepter_t * tcp_accepter)
{
  _udpd_context_t *udpd_context = (_udpd_context_t *) srv_context;
  int ret = 0;

  if (udpd_context)
    {
      ret = _mod_udpd_can_handle_tcp (udpd_context, tcp_accepter);
    }

  return ret;
}

static int
can_handle_udp (void *srv_context, lw6srv_udp_buffer_t * udp_buffer)
{
  _udpd_context_t *udpd_context = (_udpd_context_t *) srv_context;
  int ret = 0;

  if (udpd_context)
    {
      ret = _mod_udpd_can_handle_udp (udpd_context, udp_buffer);
    }

  return ret;
}

static lw6srv_connection_t *
accept_tcp (void *srv_context, lw6srv_tcp_accepter_t * tcp_accepter,
	    char *password)
{
  _udpd_context_t *udpd_context = (_udpd_context_t *) srv_context;
  lw6srv_connection_t *ret = NULL;

  if (udpd_context)
    {
      ret = _mod_udpd_accept_tcp (udpd_context, tcp_accepter, password);
    }

  return ret;
}

static lw6srv_connection_t *
new_udp (void *srv_context, lw6srv_udp_buffer_t * udp_buffer, char *password)
{
  _udpd_context_t *udpd_context = (_udpd_context_t *) srv_context;
  lw6srv_connection_t *ret = NULL;

  if (udpd_context)
    {
      ret = _mod_udpd_new_udp (udpd_context, udp_buffer, password);
    }

  return ret;
}

static int
is_associated_with_udp (void *srv_context, lw6srv_connection_t * connection,
			lw6srv_udp_buffer_t * udp_buffer)
{
  _udpd_context_t *udpd_context = (_udpd_context_t *) srv_context;
  int ret = 0;

  if (udpd_context)
    {
      ret =
	_mod_udpd_is_associated_with_udp (udpd_context, connection,
					  udp_buffer);
    }

  return ret;
}

static int
update_with_udp (void *srv_context, lw6srv_connection_t * connection,
		 lw6srv_udp_buffer_t * udp_buffer)
{
  _udpd_context_t *udpd_context = (_udpd_context_t *) srv_context;
  int ret = 0;

  if (udpd_context)
    {
      ret = _mod_udpd_update_with_udp (udpd_context, connection, udp_buffer);
    }

  return ret;
}

static void
close (void *srv_context, lw6srv_connection_t * connection)
{
  _udpd_context_t *udpd_context = (_udpd_context_t *) srv_context;

  if (udpd_context)
    {
      _mod_udpd_close (udpd_context, connection);
    }
}

static int
send (void *srv_context, lw6srv_connection_t * connection, char *message)
{
  _udpd_context_t *udpd_context = (_udpd_context_t *) srv_context;
  int ret = 0;

  if (udpd_context)
    {
      ret = _mod_udpd_send (udpd_context, connection, message);
    }

  return ret;
}

static char *
recv (void *srv_context, lw6srv_connection_t * connection)
{
  _udpd_context_t *udpd_context = (_udpd_context_t *) srv_context;
  char *ret = NULL;

  if (udpd_context)
    {
      ret = _mod_udpd_recv (udpd_context, connection);
    }

  return ret;
}

static int
is_alive (void *srv_context, lw6srv_connection_t * connection)
{
  _udpd_context_t *udpd_context = (_udpd_context_t *) srv_context;
  int ret = 0;

  if (udpd_context)
    {
      ret = _mod_udpd_is_alive (udpd_context, connection);
    }

  return ret;
}

static char *
repr (void *srv_context, lw6srv_connection_t * connection)
{
  _udpd_context_t *udpd_context = (_udpd_context_t *) srv_context;
  char *ret = NULL;

  if (udpd_context)
    {
      ret = _mod_udpd_repr (udpd_context, connection);
    }

  return ret;
}

static char *
error (void *srv_context, lw6srv_connection_t * connection)
{
  _udpd_context_t *udpd_context = (_udpd_context_t *) srv_context;
  char *ret = NULL;

  if (udpd_context)
    {
      ret = _mod_udpd_error (udpd_context, connection);
    }

  return ret;
}

lw6srv_backend_t *
mod_udpd_create_backend ()
{
  lw6srv_backend_t *backend;

  backend = LW6SYS_MALLOC (sizeof (lw6srv_backend_t));
  if (backend)
    {
      memset (backend, 0, sizeof (lw6srv_backend_t));

      backend->init = init;
      backend->quit = quit;
      backend->can_handle_tcp = can_handle_tcp;
      backend->can_handle_udp = can_handle_udp;
      backend->accept_tcp = accept_tcp;
      backend->new_udp = new_udp;
      backend->is_associated_with_udp = is_associated_with_udp;
      backend->update_with_udp = update_with_udp;
      backend->close = close;
      backend->send = send;
      backend->recv = recv;
      backend->is_alive = is_alive;
      backend->repr = repr;
      backend->error = error;
    }

  return backend;
}
