
/*
  Liquid War 6 is a unique multiplayer wargame.
  Copyright (C)  2005, 2006, 2007, 2008  Christian Mauduit <ufoot@ufoot.org>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.
  

  Liquid War 6 homepage : http://www.gnu.org/software/liquidwar6/
  Contact author        : ufoot@ufoot.org
*/

#include <string.h>

#include "config.h"
#include "sys.h"

int
lw6sys_sort_int_callback (lw6sys_list_t ** list_a, lw6sys_list_t ** list_b)
{
  int ret = 0;
  int a, b;

  a = *((int *) ((*list_a)->data));
  b = *((int *) ((*list_b)->data));

  if (a < b)
    {
      ret = -1;
    }
  else if (a > b)
    {
      ret = 1;
    }

  return ret;
}

int
lw6sys_sort_int_desc_callback (lw6sys_list_t ** list_a,
			       lw6sys_list_t ** list_b)
{
  int ret = 0;
  int a, b;

  a = *((int *) ((*list_a)->data));
  b = *((int *) ((*list_b)->data));

  if (a < b)
    {
      ret = 1;
    }
  else if (a > b)
    {
      ret = -1;
    }

  return ret;
}

int
lw6sys_sort_float_callback (lw6sys_list_t ** list_a, lw6sys_list_t ** list_b)
{
  int ret = 0;
  float a, b;

  a = *((float *) ((*list_a)->data));
  b = *((float *) ((*list_b)->data));

  if (a < b)
    {
      ret = -1;
    }
  else if (a > b)
    {
      ret = 1;
    }

  return ret;
}

int
lw6sys_sort_float_desc_callback (lw6sys_list_t ** list_a,
				 lw6sys_list_t ** list_b)
{
  int ret = 0;
  float a, b;

  a = *((float *) ((*list_a)->data));
  b = *((float *) ((*list_b)->data));

  if (a < b)
    {
      ret = 1;
    }
  else if (a > b)
    {
      ret = -1;
    }

  return ret;
}

int
lw6sys_sort_str_callback (lw6sys_list_t ** list_a, lw6sys_list_t ** list_b)
{
  int ret = 0;

  ret = strcmp ((char *) ((*list_a)->data), (char *) ((*list_b)->data));

  return ret;
}

int
lw6sys_sort_str_desc_callback (lw6sys_list_t ** list_a,
			       lw6sys_list_t ** list_b)
{
  int ret = 0;

  ret = -strcmp ((char *) ((*list_a)->data), (char *) ((*list_b)->data));

  return ret;
}

void
lw6sys_sort (lw6sys_list_t ** list, LW6SYS_SORT_CALLBACK_FUNC sort_func)
{
  int length, i;
  lw6sys_list_t **array;
  lw6sys_list_t *pos;
  lw6sys_list_t *end;

  length = lw6sys_list_length (*list);
  if (length > 0)
    {
      array =
	(lw6sys_list_t **) LW6SYS_CALLOC (length * sizeof (lw6sys_list_t *));
      if (array)
	{
	  for (pos = (*list), i = 0; pos->next_item != NULL;
	       pos = lw6sys_list_next (pos), i++)
	    {
	      array[i] = pos;
	    }
	  if (i != length)
	    {
	      lw6sys_log (LW6SYS_LOG_WARNING,
			  _("sort error, i=%d, length=%d"), i, length);
	    }
	  end = pos;

	  // do the sort using a function that knows how to do the job
	  qsort (array, length, sizeof (lw6sys_list_t *), (void *) sort_func);

	  for (i = 0; i < length - 1; ++i)
	    {
	      array[i]->next_item = array[i + 1];
	    }
	  array[length - 1]->next_item = end;

	  (*list) = array[0];

	  LW6SYS_FREE (array);
	}
    }
}
