/*
  Liquid War 6 is a unique multiplayer wargame.
  Copyright (C)  2005, 2006, 2007, 2008  Christian Mauduit <ufoot@ufoot.org>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.
  

  Liquid War 6 homepage : http://www.gnu.org/software/liquidwar6/
  Contact author        : ufoot@ufoot.org
*/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <string.h>

#include "cli.h"

lw6sys_assoc_t *
lw6cli_get_backends (int argc, char *argv[])
{
  lw6sys_assoc_t *ret = NULL;
  char *path;

  ret = lw6sys_assoc_new (NULL);
  if (ret)
    {
      path = lw6dyn_path_find_backend (argc, argv, "cli", "tcp");
      if (path)
	{
	  lw6sys_assoc_set (&ret, "tcp", (void *) _("TCP"));
	  LW6SYS_FREE (path);
	}
      path = lw6dyn_path_find_backend (argc, argv, "cli", "udp");
      if (path)
	{
	  lw6sys_assoc_set (&ret, "udp", (void *) _("UDP"));
	  LW6SYS_FREE (path);
	}
      path = lw6dyn_path_find_backend (argc, argv, "cli", "http");
      if (path)
	{
	  lw6sys_assoc_set (&ret, "http", (void *) _("HTTP"));
	  LW6SYS_FREE (path);
	}
    }

  return ret;
}

lw6cli_backend_t *
lw6cli_create_backend (int argc, char *argv[], char *name)
{
  lw6cli_backend_t *backend = NULL;
  lw6dyn_dl_handle_t *backend_handle = NULL;

  backend_handle = lw6dyn_dlopen_backend (argc, argv, "cli", name);

  if (backend_handle)
    {
      char *init_func_name;
      lw6cli_backend_t *(*init_func) ();

      init_func_name = lw6sys_new_sprintf ("mod_%s_create_backend", name);
      if (init_func_name)
	{
	  init_func = lw6dyn_dlsym (backend_handle, init_func_name);
	  if (init_func)
	    {
	      backend = init_func ();
	    }
	  else
	    {
	      lw6sys_log (LW6SYS_LOG_WARNING,
			  _
			  ("unable to find function \"%s\" in server backend \"%s\""),
			  init_func_name, name);
	    }

	  LW6SYS_FREE (init_func_name);
	}
    }


  if (backend && backend_handle)
    {
      backend->dl_handle = backend_handle;
      backend->argc = argc;
      backend->argv = argv;
    }
  else
    {
      lw6sys_log (LW6SYS_LOG_WARNING,
		  _("unable to open server backend \"%s\""), name);
    }

  return backend;
}

void
lw6cli_destroy_backend (lw6cli_backend_t * backend)
{
  lw6dyn_dlclose_backend (backend->dl_handle);
  LW6SYS_FREE (backend);
}
