/*
  Liquid War 6 is a unique multiplayer wargame.
  Copyright (C)  2005, 2006, 2007, 2008  Christian Mauduit <ufoot@ufoot.org>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.
  

  Liquid War 6 homepage : http://www.gnu.org/software/liquidwar6/
  Contact author        : ufoot@ufoot.org
*/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "gfx.h"

static void
_warning (char *func_name)
{
  lw6sys_log (LW6SYS_LOG_WARNING,
	      _("gfx backend function \"%s\" is not defined"), func_name);
}

void
lw6gfx_display_background (lw6gfx_backend_t * backend, lw6gui_look_t * look)
{
  LW6SYS_BACKEND_FUNCION_BEGIN;

  if (backend->display_background)
    {
      backend->display_background (backend->gfx_context, look);
    }
  else
    {
      _warning ("display_background");
    }

  LW6SYS_BACKEND_FUNCION_END;
}

void
lw6gfx_display_hud (lw6gfx_backend_t * backend, lw6gui_look_t * look,
		    lw6ker_game_state_t * game_state)
{
  LW6SYS_BACKEND_FUNCION_BEGIN;

  if (backend->display_hud)
    {
      backend->display_hud (backend->gfx_context, look, game_state);
    }
  else
    {
      _warning ("display_hud_fg");
    }

  LW6SYS_BACKEND_FUNCION_END;
}

int
lw6gfx_poll_key (lw6gfx_backend_t * backend, lw6gui_keypress_t * keypress)
{
  int ret = 0;

  LW6SYS_BACKEND_FUNCION_BEGIN;

  if (backend->poll_key)
    {
      ret = backend->poll_key (backend->gfx_context, keypress);
    }
  else
    {
      _warning ("poll_key");
    }

  return ret;

  LW6SYS_BACKEND_FUNCION_END;
}

int
lw6gfx_is_key_esc (lw6gfx_backend_t * backend, int keysym)
{
  int ret = 0;

  LW6SYS_BACKEND_FUNCION_BEGIN;

  if (backend->is_key_esc)
    {
      ret = backend->is_key_esc (backend->gfx_context, keysym);
    }
  else
    {
      _warning ("is_key_esc");
    }

  LW6SYS_BACKEND_FUNCION_END;

  return ret;
}

int
lw6gfx_is_key_enter (lw6gfx_backend_t * backend, int keysym)
{
  int ret = 0;

  LW6SYS_BACKEND_FUNCION_BEGIN;

  if (backend->is_key_enter)
    {
      ret = backend->is_key_enter (backend->gfx_context, keysym);
    }
  else
    {
      _warning ("is_key_enter");
    }

  LW6SYS_BACKEND_FUNCION_END;

  return ret;
}

int
lw6gfx_is_key_up (lw6gfx_backend_t * backend, int keysym)
{
  int ret = 0;

  LW6SYS_BACKEND_FUNCION_BEGIN;

  if (backend->is_key_up)
    {
      ret = backend->is_key_up (backend->gfx_context, keysym);
    }
  else
    {
      _warning ("is_key_up");
    }

  LW6SYS_BACKEND_FUNCION_END;

  return ret;
}

int
lw6gfx_is_key_down (lw6gfx_backend_t * backend, int keysym)
{
  int ret = 0;

  LW6SYS_BACKEND_FUNCION_BEGIN;

  if (backend->is_key_down)
    {
      ret = backend->is_key_down (backend->gfx_context, keysym);
    }
  else
    {
      _warning ("is_key_down");
    }

  LW6SYS_BACKEND_FUNCION_END;

  return ret;
}

int
lw6gfx_is_key_left (lw6gfx_backend_t * backend, int keysym)
{
  int ret = 0;

  LW6SYS_BACKEND_FUNCION_BEGIN;

  if (backend->is_key_left)
    {
      ret = backend->is_key_left (backend->gfx_context, keysym);
    }
  else
    {
      _warning ("is_key_left");
    }

  LW6SYS_BACKEND_FUNCION_END;

  return ret;
}

int
lw6gfx_is_key_right (lw6gfx_backend_t * backend, int keysym)
{
  int ret = 0;

  LW6SYS_BACKEND_FUNCION_BEGIN;

  if (backend->is_key_right)
    {
      ret = backend->is_key_right (backend->gfx_context, keysym);
    }
  else
    {
      _warning ("is_key_right");
    }

  LW6SYS_BACKEND_FUNCION_END;

  return ret;
}

int
lw6gfx_poll_quit (lw6gfx_backend_t * backend)
{
  int ret = 0;

  LW6SYS_BACKEND_FUNCION_BEGIN;

  if (backend->poll_quit)
    {
      ret = backend->poll_quit (backend->gfx_context);
    }
  else
    {
      _warning ("poll_quit");
    }

  LW6SYS_BACKEND_FUNCION_END;

  return ret;
}

void
lw6gfx_send_quit (lw6gfx_backend_t * backend)
{
  LW6SYS_BACKEND_FUNCION_BEGIN;

  if (backend->send_quit)
    {
      backend->send_quit (backend->gfx_context);
    }
  else
    {
      _warning ("send_quit");
    }

  LW6SYS_BACKEND_FUNCION_END;
}

int
lw6gfx_get_key_state (lw6gfx_backend_t * backend, int keysym)
{
  int ret = 0;

  LW6SYS_BACKEND_FUNCION_BEGIN;

  if (backend->get_key_state)
    {
      ret = backend->get_key_state (backend->gfx_context, keysym);
    }
  else
    {
      _warning ("get_key_state");
    }

  LW6SYS_BACKEND_FUNCION_END;

  return ret;
}

int
lw6gfx_poll_mouse_move (lw6gfx_backend_t * backend, int *x, int *y)
{
  int ret = 0;

  LW6SYS_BACKEND_FUNCION_BEGIN;

  if (backend->poll_mouse_move)
    {
      ret = backend->poll_mouse_move (backend->gfx_context, x, y);
    }
  else
    {
      _warning ("poll_mouse_move");
    }

  LW6SYS_BACKEND_FUNCION_END;

  return ret;
}

int
lw6gfx_poll_mouse_button_left (lw6gfx_backend_t * backend)
{
  int ret = 0;

  LW6SYS_BACKEND_FUNCION_BEGIN;

  if (backend->poll_mouse_button_left)
    {
      ret = backend->poll_mouse_button_left (backend->gfx_context);
    }
  else
    {
      _warning ("poll_mouse_button_left");
    }

  LW6SYS_BACKEND_FUNCION_END;

  return ret;
}

int
lw6gfx_poll_mouse_button_right (lw6gfx_backend_t * backend)
{
  int ret = 0;

  LW6SYS_BACKEND_FUNCION_BEGIN;

  if (backend->poll_mouse_button_right)
    {
      ret = backend->poll_mouse_button_right (backend->gfx_context);
    }
  else
    {
      _warning ("poll_mouse_button_right");
    }

  LW6SYS_BACKEND_FUNCION_END;

  return ret;
}

int
lw6gfx_poll_mouse_wheel_up (lw6gfx_backend_t * backend)
{
  int ret = 0;

  LW6SYS_BACKEND_FUNCION_BEGIN;

  if (backend->poll_mouse_wheel_up)
    {
      ret = backend->poll_mouse_wheel_up (backend->gfx_context);
    }
  else
    {
      _warning ("poll_mouse_wheel_up");
    }

  LW6SYS_BACKEND_FUNCION_END;

  return ret;
}

int
lw6gfx_poll_mouse_wheel_down (lw6gfx_backend_t * backend)
{
  int ret = 0;

  LW6SYS_BACKEND_FUNCION_BEGIN;

  if (backend->poll_mouse_wheel_down)
    {
      ret = backend->poll_mouse_wheel_down (backend->gfx_context);
    }
  else
    {
      _warning ("poll_mouse_wheel_down");
    }

  LW6SYS_BACKEND_FUNCION_END;

  return ret;
}

void
lw6gfx_get_mouse_state (lw6gfx_backend_t * backend, int *x, int *y,
			int *button_left, int *button_right)
{
  LW6SYS_BACKEND_FUNCION_BEGIN;

  if (backend->get_mouse_state)
    {
      backend->get_mouse_state (backend->gfx_context, x, y, button_left,
				button_right);
    }
  else
    {
      _warning ("get_mouse_state");
    }

  LW6SYS_BACKEND_FUNCION_END;
}

int
lw6gfx_poll_joystick_up (lw6gfx_backend_t * backend, int i)
{
  int ret = 0;

  LW6SYS_BACKEND_FUNCION_BEGIN;

  if (backend->poll_joystick_up)
    {
      ret = backend->poll_joystick_up (backend->gfx_context, i);
    }
  else
    {
      _warning ("poll_joystick_up");
    }

  LW6SYS_BACKEND_FUNCION_END;

  return ret;
}

int
lw6gfx_poll_joystick_down (lw6gfx_backend_t * backend, int i)
{
  int ret = 0;

  LW6SYS_BACKEND_FUNCION_BEGIN;

  if (backend->poll_joystick_down)
    {
      ret = backend->poll_joystick_down (backend->gfx_context, i);
    }
  else
    {
      _warning ("poll_joystick_down");
    }

  LW6SYS_BACKEND_FUNCION_END;

  return ret;
}

int
lw6gfx_poll_joystick_left (lw6gfx_backend_t * backend, int i)
{
  int ret = 0;

  LW6SYS_BACKEND_FUNCION_BEGIN;

  if (backend->poll_joystick_left)
    {
      ret = backend->poll_joystick_left (backend->gfx_context, i);
    }
  else
    {
      _warning ("poll_joystick_left");
    }

  LW6SYS_BACKEND_FUNCION_END;

  return ret;
}

int
lw6gfx_poll_joystick_right (lw6gfx_backend_t * backend, int i)
{
  int ret = 0;

  LW6SYS_BACKEND_FUNCION_BEGIN;

  if (backend->poll_joystick_right)
    {
      ret = backend->poll_joystick_right (backend->gfx_context, i);
    }
  else
    {
      _warning ("poll_joystick_right");
    }

  LW6SYS_BACKEND_FUNCION_END;

  return ret;
}

int
lw6gfx_poll_joystick_button (lw6gfx_backend_t * backend, int i, int b)
{
  int ret = 0;

  LW6SYS_BACKEND_FUNCION_BEGIN;

  if (backend->poll_joystick_button)
    {
      ret = backend->poll_joystick_button (backend->gfx_context, i, b);
    }
  else
    {
      _warning ("poll_joystick_button");
    }

  LW6SYS_BACKEND_FUNCION_END;

  return ret;
}

void
lw6gfx_get_joystick_state (lw6gfx_backend_t * backend, int *x, int *y,
			   int *button, int i, int b)
{
  LW6SYS_BACKEND_FUNCION_BEGIN;

  if (backend->get_joystick_state)
    {
      backend->get_joystick_state (backend->gfx_context, x, y, button, i, b);
    }
  else
    {
      _warning ("get_joystick_state");
    }

  LW6SYS_BACKEND_FUNCION_END;
}

void
lw6gfx_display_log (lw6gfx_backend_t * backend, lw6gui_look_t * look,
		    char **log_list)
{
  LW6SYS_BACKEND_FUNCION_BEGIN;

  if (backend->display_log)
    {
      backend->display_log (backend->gfx_context, look, log_list);
    }
  else
    {
      _warning ("display_log");
    }

  LW6SYS_BACKEND_FUNCION_END;
}

void
lw6gfx_display_fps (lw6gfx_backend_t * backend, lw6gui_look_t * look, int fps)
{
  LW6SYS_BACKEND_FUNCION_BEGIN;

  if (backend->display_fps)
    {
      backend->display_fps (backend->gfx_context, look, fps);
    }
  else
    {
      _warning ("display_fps");
    }

  LW6SYS_BACKEND_FUNCION_END;
}

void
lw6gfx_display_map_preview (lw6gfx_backend_t * backend, lw6gui_look_t * look,
			    lw6map_level_t * level)
{
  LW6SYS_BACKEND_FUNCION_BEGIN;

  if (backend->display_map_preview)
    {
      backend->display_map_preview (backend->gfx_context, look, level);
    }
  else
    {
      _warning ("display_map_preview");
    }

  LW6SYS_BACKEND_FUNCION_END;
}

void
lw6gfx_display_map_zones (lw6gfx_backend_t * backend, lw6gui_look_t * look,
			  lw6ker_game_struct_t * game_struct)
{
  LW6SYS_BACKEND_FUNCION_BEGIN;

  if (backend->display_map_zones)
    {
      backend->display_map_zones (backend->gfx_context, look, game_struct);
    }
  else
    {
      _warning ("display_map_zones");
    }

  LW6SYS_BACKEND_FUNCION_END;
}

void
lw6gfx_display_map_gradient (lw6gfx_backend_t * backend, lw6gui_look_t * look,
			     lw6ker_game_state_t * game_state, int team_id)
{
  LW6SYS_BACKEND_FUNCION_BEGIN;

  if (backend->display_map_gradient)
    {
      backend->display_map_gradient (backend->gfx_context, look, game_state,
				     team_id);
    }
  else
    {
      _warning ("display_map_gradient");
    }

  LW6SYS_BACKEND_FUNCION_END;
}

void
lw6gfx_display_game (lw6gfx_backend_t * backend,
		     lw6gui_look_t * look, lw6ker_game_state_t * game_state)
{
  LW6SYS_BACKEND_FUNCION_BEGIN;

  if (backend->display_game)
    {
      backend->display_game (backend->gfx_context, look, game_state);
    }
  else
    {
      _warning ("display_game");
    }

  LW6SYS_BACKEND_FUNCION_END;
}

void
lw6gfx_pick_map_coord (lw6gfx_backend_t * backend, lw6gui_look_t * look,
		       int *map_x, int *map_y,
		       lw6ker_game_state_t * game_state, int screen_x,
		       int screen_y)
{
  LW6SYS_BACKEND_FUNCION_BEGIN;

  if (backend->pick_map_coord)
    {
      backend->pick_map_coord (backend->gfx_context, look, map_x, map_y,
			       game_state, screen_x, screen_y);
    }
  else
    {
      _warning ("pick_map_coord");
    }

  LW6SYS_BACKEND_FUNCION_END;
}

void
lw6gfx_display_menu (lw6gfx_backend_t * backend, lw6gui_look_t * look,
		     lw6gui_menu_t * menu)
{
  LW6SYS_BACKEND_FUNCION_BEGIN;

  if (backend->display_menu)
    {
      backend->display_menu (backend->gfx_context, look, menu);
    }
  else
    {
      _warning ("display_menu");
    }

  LW6SYS_BACKEND_FUNCION_END;
}

void
lw6gfx_pick_menuitem (lw6gfx_backend_t * backend, lw6gui_look_t * look,
		      int *position, int *scroll, lw6gui_menu_t * menu,
		      int screen_x, int screen_y)
{
  LW6SYS_BACKEND_FUNCION_BEGIN;

  if (backend->pick_menuitem)
    {
      backend->pick_menuitem (backend->gfx_context, look, position, scroll,
			      menu, screen_x, screen_y);
    }
  else
    {
      _warning ("pick_menuitem");
    }

  LW6SYS_BACKEND_FUNCION_END;
}

int
lw6gfx_warp_mouse_on_menuitem (lw6gfx_backend_t * backend,
			       lw6gui_look_t * look, lw6gui_menu_t * menu,
			       int position)
{
  int ret = 0;

  LW6SYS_BACKEND_FUNCION_BEGIN;

  if (backend->warp_mouse_on_menuitem)
    {
      ret = backend->warp_mouse_on_menuitem (backend->gfx_context, look, menu,
					     position);
    }
  else
    {
      _warning ("warp_mouse_on_menuitem");
    }

  LW6SYS_BACKEND_FUNCION_END;

  return ret;
}

void
lw6gfx_prepare_buffer (lw6gfx_backend_t * backend, lw6gui_look_t * look)
{
  LW6SYS_BACKEND_FUNCION_BEGIN;

  if (backend->prepare_buffer)
    {
      backend->prepare_buffer (backend->gfx_context, look);
    }
  else
    {
      _warning ("prepare_buffer");
    }

  LW6SYS_BACKEND_FUNCION_END;
}

void
lw6gfx_swap_buffers (lw6gfx_backend_t * backend)
{
  LW6SYS_BACKEND_FUNCION_BEGIN;

  if (backend->swap_buffers)
    {
      backend->swap_buffers (backend->gfx_context);
    }
  else
    {
      _warning ("swap_buffers");
    }

  LW6SYS_BACKEND_FUNCION_END;
}

int
lw6gfx_init (lw6gfx_backend_t * backend, int width,
	     int height, int fullscreen,
	     void (*resize_callback) (int width, int height, int fullscreen),
	     int ticks)
{
  LW6SYS_BACKEND_FUNCION_BEGIN;

  if (backend->init)
    {
      backend->gfx_context =
	backend->init (backend->argc, backend->argv, width, height,
		       fullscreen, resize_callback, ticks);
    }
  else
    {
      _warning ("init");
    }

  LW6SYS_BACKEND_FUNCION_END;

  return backend->gfx_context ? 1 : 0;
}

void
lw6gfx_get_low_resolution (lw6gfx_backend_t * backend, int *width,
			   int *height)
{
  LW6SYS_BACKEND_FUNCION_BEGIN;

  if (backend->get_low_resolution)
    {
      backend->get_low_resolution (backend->gfx_context, width, height);
    }
  else
    {
      _warning ("get_low_resolution");
    }

  LW6SYS_BACKEND_FUNCION_END;
}

void
lw6gfx_get_standard_resolution (lw6gfx_backend_t * backend, int *width,
				int *height)
{
  LW6SYS_BACKEND_FUNCION_BEGIN;

  if (backend->get_standard_resolution)
    {
      backend->get_standard_resolution (backend->gfx_context, width, height);
    }
  else
    {
      _warning ("get_standard_resolution");
    }

  LW6SYS_BACKEND_FUNCION_END;
}

void
lw6gfx_get_high_resolution (lw6gfx_backend_t * backend, int *width,
			    int *height)
{
  LW6SYS_BACKEND_FUNCION_BEGIN;

  if (backend->get_high_resolution)
    {
      backend->get_high_resolution (backend->gfx_context, width, height);
    }
  else
    {
      _warning ("get_high_resolution");
    }

  LW6SYS_BACKEND_FUNCION_END;
}

int
lw6gfx_set_video_mode (lw6gfx_backend_t * backend, int width, int height,
		       int fullscreen, void (*resize_callback) (int width,
								int height,
								int
								fullscreen))
{
  int ret = 0;

  LW6SYS_BACKEND_FUNCION_BEGIN;

  if (backend->set_video_mode)
    {
      ret =
	backend->set_video_mode (backend->gfx_context, width, height,
				 fullscreen, resize_callback);
    }
  else
    {
      _warning ("set_video_mode");
    }

  LW6SYS_BACKEND_FUNCION_END;

  return ret;
}

int
lw6gfx_get_video_mode (lw6gfx_backend_t * backend, int *width, int *height,
		       int *fullscreen)
{
  int ret = 0;

  LW6SYS_BACKEND_FUNCION_BEGIN;

  if (backend->get_video_mode)
    {
      ret =
	backend->get_video_mode (backend->gfx_context, width, height,
				 fullscreen);
    }
  else
    {
      _warning ("get_video_mode");
    }

  LW6SYS_BACKEND_FUNCION_END;

  return ret;
}

void
lw6gfx_quit (lw6gfx_backend_t * backend)
{
  LW6SYS_BACKEND_FUNCION_BEGIN;

  if (backend->quit)
    {
      backend->quit (backend->gfx_context);
      backend->gfx_context = NULL;
    }
  else
    {
      _warning ("quit");
    }

  LW6SYS_BACKEND_FUNCION_END;
}

void
lw6gfx_delay (lw6gfx_backend_t * backend, int ms)
{
  LW6SYS_BACKEND_FUNCION_BEGIN;

  if (backend->delay)
    {
      backend->delay (backend->gfx_context, ms);
    }
  else
    {
      _warning ("delay");
    }

  LW6SYS_BACKEND_FUNCION_END;
}

int
lw6gfx_get_ticks (lw6gfx_backend_t * backend)
{
  int ret = 0;

  LW6SYS_BACKEND_FUNCION_BEGIN;

  if (backend->get_ticks)
    {
      ret = backend->get_ticks (backend->gfx_context);
    }
  else
    {
      _warning ("get_ticks");
    }

  LW6SYS_BACKEND_FUNCION_END;

  return ret;
}
