/*
  Liquid War 6 is a unique multiplayer wargame.
  Copyright (C)  2005, 2006, 2007, 2008  Christian Mauduit <ufoot@ufoot.org>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.
  

  Liquid War 6 homepage : http://www.gnu.org/software/liquidwar6/
  Contact author        : ufoot@ufoot.org
*/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <string.h>

#include "../../gfx.h"
#include "../../../cfg/cfg.h"
#include "gl-utils.h"
#include "gl-utils-internal.h"

#define CONST_FILE "utils/gl-utils-const.xml"

static void
read_callback (void *callback_data, char *element, char *key, char *value)
{
  mod_gl_utils_const_data_t *const_data;

  const_data = (mod_gl_utils_const_data_t *) callback_data;

  if (!strcmp (element, "int"))
    {
      lw6cfg_read_xml_int (key, value, "menu-font-size",
			   &const_data->menu_font_size);
      lw6cfg_read_xml_int (key, value, "system-font-size",
			   &const_data->system_font_size);
      lw6cfg_read_xml_int (key, value, "system-font-dw",
			   &const_data->system_font_dw);
      lw6cfg_read_xml_int (key, value, "system-font-dh",
			   &const_data->system_font_dh);
      lw6cfg_read_xml_int (key, value, "joystick-limit-up",
			   &const_data->joystick_limit_up);
      lw6cfg_read_xml_int (key, value, "joystick-limit-down",
			   &const_data->joystick_limit_down);
      lw6cfg_read_xml_int (key, value, "joystick-limit-left",
			   &const_data->joystick_limit_left);
      lw6cfg_read_xml_int (key, value, "joystick-limit-right",
			   &const_data->joystick_limit_right);
    }

  if (!strcmp (element, "float"))
    {
      lw6cfg_read_xml_float (key, value, "quit-sleep",
			     &const_data->quit_sleep);
      lw6cfg_read_xml_float (key, value, "persp-fovy",
			     &const_data->persp_fovy);
      lw6cfg_read_xml_float (key, value, "persp-znear",
			     &const_data->persp_znear);
      lw6cfg_read_xml_float (key, value, "persp-zfar",
			     &const_data->persp_zfar);
      lw6cfg_read_xml_float (key, value, "system-font-hcoef",
			     &const_data->system_font_hcoef);
      lw6cfg_read_xml_float (key, value, "gradient-opacity",
			     &const_data->gradient_opacity);
      lw6cfg_read_xml_float (key, value, "zones-opacity",
			     &const_data->zones_opacity);
      lw6cfg_read_xml_float (key, value, "mainlight-r",
			     &const_data->mainlight_r);
      lw6cfg_read_xml_float (key, value, "mainlight-g",
			     &const_data->mainlight_g);
      lw6cfg_read_xml_float (key, value, "mainlight-b",
			     &const_data->mainlight_b);
      lw6cfg_read_xml_float (key, value, "mainlight-a",
			     &const_data->mainlight_a);
      lw6cfg_read_xml_float (key, value, "mainlight-x",
			     &const_data->mainlight_x);
      lw6cfg_read_xml_float (key, value, "mainlight-y",
			     &const_data->mainlight_y);
      lw6cfg_read_xml_float (key, value, "mainlight-z",
			     &const_data->mainlight_z);
    }
}

/*
 * Loads constants.
 */
int
_mod_gl_utils_load_consts (mod_gl_utils_context_t * context)
{
  int ret = 0;
  char *const_file = NULL;

  const_file = lw6sys_path_concat (context->path.data_dir, CONST_FILE);

  if (const_file)
    {
      lw6sys_log (LW6SYS_LOG_INFO, _("reading \"%s\""), const_file);

      ret =
	lw6cfg_read_key_value_xml_file (const_file, read_callback,
					(void *) &(context->const_data));

      LW6SYS_FREE (const_file);
    }

  return ret;
}

/*
 * Unload constants, free memory
 */
void
_mod_gl_utils_unload_consts (mod_gl_utils_context_t * context)
{
  memset (&context->const_data, 0, sizeof (mod_gl_utils_const_data_t));
}
