/*
  Liquid War 6 is a unique multiplayer wargame.
  Copyright (C)  2005, 2006, 2007, 2008  Christian Mauduit <ufoot@ufoot.org>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.
  

  Liquid War 6 homepage : http://www.gnu.org/software/liquidwar6/
  Contact author        : ufoot@ufoot.org
*/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <string.h>

#include "hlp.h"

static char *
about (LW6HLP_TYPE * type, char *keyword)
{
  char *ret = NULL;
  LW6HLP_TYPE dummy = LW6HLP_TYPE_STR;

  if (!type)
    {
      type = &dummy;
    }
  else
    {
      (*type) = dummy;
    }

  /*
   * System, non-run
   */
  if (lw6hlp_match (keyword, "copyright")
      || lw6hlp_match (keyword, "copyleft"))
    {
      (*type) = LW6HLP_TYPE_VOID;
      ret = _("Returns the copyright notice for the program.");
    }
  else if (lw6hlp_match (keyword, "version"))
    {
      (*type) = LW6HLP_TYPE_VOID;
      ret =
	_
	("Returns the version of the program, as defined by the GNU Coding Standards.");
    }
  else if (lw6hlp_match (keyword, "help"))
    {
      (*type) = LW6HLP_TYPE_VOID;
      ret = _("Returns a short help for the program.");
    }
  else if (lw6hlp_match (keyword, "test"))
    {
      (*type) = LW6HLP_TYPE_VOID;
      ret =
	_
	("Runs a (hopefully) complete test suite which will call most internal Liquid War 6 functions and check out wether they work, in a simple context, without any game interference. Usefull for troubleshooting.");
    }
  else if (lw6hlp_match (keyword, "reset"))
    {
      (*type) = LW6HLP_TYPE_VOID;
      ret =
	_
	("Clears the config file so that the game will run with defaults next time. The idea is to get rid of traces of previous executions.");
    }
  else if (lw6hlp_match (keyword, "defaults"))
    {
      (*type) = LW6HLP_TYPE_VOID;
      ret =
	_
	("Clears the config file and run the game with default settings. The difference with '--reset' is that '--defaults' runs the game, while '--reset' does not.");
    }
  else if (lw6hlp_match (keyword, "pedigree"))
    {
      (*type) = LW6HLP_TYPE_VOID;
      ret =
	_
	("Display all build values, these are general constants which can help debugging, tracing what binary you are running, and so on. It's a good idea to take a look at the output of 'pedigree' if you have problems running the game.");
    }
  else if (lw6hlp_match (keyword, "audit"))
    {
      (*type) = LW6HLP_TYPE_VOID;
      ret =
	_
	("Display all path values, defaults and current settings. This output is very usefull to track down problems such as missing directories, broken installations. If you get an error message that suggests some file is missing, then give this option a try.");
    }
  else if (lw6hlp_match (keyword, "modules"))
    {
      (*type) = LW6HLP_TYPE_VOID;
      ret =
	_
	("Tells which modules have been enabled when the game was compiled. It's still possible to add or remove modules afterwards, but this option allows you to know how things were at first.");
    }
  else if (lw6hlp_match (keyword, "list"))
    {
      (*type) = LW6HLP_TYPE_VOID;
      ret =
	_
	("Returns the list of all keywords which can be queried for information. This includes command-line options, environment variables, and so on. This is the companion option of '--about'. Results obtained with '--list' can be passed to '--about'.");
    }
  else if (lw6hlp_match (keyword, "about"))
    {
      (*type) = LW6HLP_TYPE_STR;
      ret =
	_
	("Will allow you to get informations about a given keyword. Let's say that, for instance, you want informations about the keyword 'map-path'. Simply run 'liquidwar6 --about=map-path'. Note that this internal self-documentation system can describe command line switches as well as XML config file parameters or environment variables, and even some Guile script functions. The '--list' command line switch will give you the list of all available keywords.");
    }
  else if (lw6hlp_match (keyword, "debug"))
    {
      (*type) = LW6HLP_TYPE_VOID;
      ret =
	_
	("Enables debug mode. This will turn on maximum log information, and display everything on stderr, even messages which are normally only stored in the log file.");
    }
  /*
   * Advanced doc
   */
  else if (lw6hlp_match (keyword, "list-quick"))
    {
      (*type) = LW6HLP_TYPE_VOID;
      ret =
	_
	("List quick help entries, this includes the GNU standard options and a few troubleshooting tools.");
    }

  else if (lw6hlp_match (keyword, "list-doc"))
    {
      (*type) = LW6HLP_TYPE_VOID;
      ret =
	_
	("List documentation-related command line options. These commands allow you to list all the keywords related to a given domain.");
    }

  else if (lw6hlp_match (keyword, "list-show"))
    {
      (*type) = LW6HLP_TYPE_VOID;
      ret =
	_
	("List command-line options which will display on the console many internal parameters. Usefull when debugging.");
    }

  else if (lw6hlp_match (keyword, "list-path"))
    {
      (*type) = LW6HLP_TYPE_VOID;
      ret =
	_
	("List parameters which allow you to override the defaults of the game, and force the game your own file paths and directories.");
    }

  else if (lw6hlp_match (keyword, "list-players"))
    {
      (*type) = LW6HLP_TYPE_VOID;
      ret = _("List player-related entries, that is to say 'who plays'.");
    }

  else if (lw6hlp_match (keyword, "list-input"))
    {
      (*type) = LW6HLP_TYPE_VOID;
      ret =
	_
	("List input (AKA controls) related options. Use these to change keyboard, joystick and mouse settingds.");
    }

  else if (lw6hlp_match (keyword, "list-graphics"))
    {
      (*type) = LW6HLP_TYPE_VOID;
      ret = _("List graphics options (resolution, fullscreen...).");
    }

  else if (lw6hlp_match (keyword, "list-sound"))
    {
      (*type) = LW6HLP_TYPE_VOID;
      ret = _("List sound options (volume...).");
    }

  else if (lw6hlp_match (keyword, "list-network"))
    {
      (*type) = LW6HLP_TYPE_VOID;
      ret = _("List network options.");
    }

  else if (lw6hlp_match (keyword, "list-map"))
    {
      (*type) = LW6HLP_TYPE_VOID;
      ret =
	_
	("List map-related entries, excluding options.xml and style.xml entries.");
    }

  else if (lw6hlp_match (keyword, "list-map-options"))
    {
      (*type) = LW6HLP_TYPE_VOID;
      ret =
	_
	("List 'options.xml' entries. These parameters enable you to modify the gameplay.");
    }

  else if (lw6hlp_match (keyword, "list-map-style"))
    {
      (*type) = LW6HLP_TYPE_VOID;
      ret =
	_
	("List 'style.xml' entries. These parameters enable you to modify the aspect of the game.");
    }

  else if (lw6hlp_match (keyword, "list-funcs"))
    {
      (*type) = LW6HLP_TYPE_VOID;
      ret =
	_
	("List the C-functions which are exported to Guile, thus usable in scripts.");
    }

  else if (lw6hlp_match (keyword, "list-hooks"))
    {
      (*type) = LW6HLP_TYPE_VOID;
      ret = _("List user-modifiable hooks.");
    }

  else if (lw6hlp_match (keyword, "list-tuning"))
    {
      (*type) = LW6HLP_TYPE_VOID;
      ret =
	_
	("List advanced options which can be used for fine-tuning the game.");
    }

  else if (lw6hlp_match (keyword, "list-aliases"))
    {
      (*type) = LW6HLP_TYPE_VOID;
      ret = _("List the keyword aliases. These are here for convenience.");
    }
  else if (lw6hlp_match (keyword, "example-options-xml"))
    {
      (*type) = LW6HLP_TYPE_VOID;
      ret =
	_
	("Dumps on stdout an example options.xml file. Such a file is normally shipped with the game. It is indeed generated using this command.");
    }
  else if (lw6hlp_match (keyword, "example-style-xml"))
    {
      (*type) = LW6HLP_TYPE_VOID;
      ret =
	_
	("Dumps on stdout an example style.xml file. Such a file is normally shipped with the game. It is indeed generated using this command.");
    }
  /*
   * Build values
   */
  else if (lw6hlp_match (keyword, "show-build-package-tarname"))
    {
      (*type) = LW6HLP_TYPE_VOID;
      ret = _("Shows the package tarname, that is, liquidwar6.");
    }
  else if (lw6hlp_match (keyword, "show-build-package-name"))
    {
      (*type) = LW6HLP_TYPE_VOID;
      ret = _("Shows the package name, that is, 'Liquid War 6'.");
    }
  else if (lw6hlp_match (keyword, "show-build-package-string"))
    {
      (*type) = LW6HLP_TYPE_VOID;
      ret = _("Shows the package string, that is, 'Liquid War 6 <version>");
    }
  else if (lw6hlp_match (keyword, "show-build-version"))
    {
      (*type) = LW6HLP_TYPE_VOID;
      ret =
	_
	("Shows the version. Note that this is different from the standard GNU 'version' command line option which shows a complete message with a short copyright notice. This one will just return the version, without the package tarname or anything else.");
    }
  else if (lw6hlp_match (keyword, "show-build-codename"))
    {
      (*type) = LW6HLP_TYPE_VOID;
      ret =
	_
	("Shows the codename associated with this version, generally the name of someone famous who is war-related (a general, an emperor...).");
    }
  else if (lw6hlp_match (keyword, "show-build-stamp"))
    {
      (*type) = LW6HLP_TYPE_VOID;
      ret =
	_
	("Shows the build stamp. A very usefull value, more precise than the version to track down binaries. It is incremented each time the core C code is updated. It won't reflect all the programs for it does not take scripts in account, but if you are running a work-in-progress version, it might be very convenient to use this to know what your are running exactly.");
    }
  else if (lw6hlp_match (keyword, "show-build-md5sum"))
    {
      (*type) = LW6HLP_TYPE_VOID;
      ret =
	_
	("Shows the MD5 checksum, which has been calculated from the C source files. Complementary with 'show-build-stamp'.");
    }
  else if (lw6hlp_match (keyword, "show-build-copyright"))
    {
      (*type) = LW6HLP_TYPE_VOID;
      ret = _("Shows a very short copyright notice.");
    }
  else if (lw6hlp_match (keyword, "show-build-license"))
    {
      (*type) = LW6HLP_TYPE_VOID;
      ret = _("Shows the license of the program (GNU GPL v3 or later).");
    }
  else if (lw6hlp_match (keyword, "show-build-configure-args"))
    {
      (*type) = LW6HLP_TYPE_VOID;
      ret =
	_
	("Shows the arguments that have been passed to the GNU Autoconf './configure' script when building the program. This can be very usefull if you want to know how the program has been built.");
    }
  else if (lw6hlp_match (keyword, "show-build-gcc-version"))
    {
      (*type) = LW6HLP_TYPE_VOID;
      ret =
	_
	("Returns the version of the GNU C compiler which was used to compile the program.");
    }
  else if (lw6hlp_match (keyword, "show-build-cflags"))
    {
      (*type) = LW6HLP_TYPE_VOID;
      ret =
	_
	("Shows what value you should put in 'CFLAGS' (environment variable) if you want to compile programs that use Liquid War 6 as a library, and include 'liquidwar6.h'.");
    }
  else if (lw6hlp_match (keyword, "show-build-ldflags"))
    {
      (*type) = LW6HLP_TYPE_VOID;
      ret =
	_
	("Shows what value you should put in 'LDFLAGS' (environment variable) if you want to link programs against libliquidwar6.");
    }
  else if (lw6hlp_match (keyword, "show-build-hostname"))
    {
      (*type) = LW6HLP_TYPE_VOID;
      ret = _("Shows the name of the host where the binary was compiled.");
    }
  else if (lw6hlp_match (keyword, "show-build-date"))
    {
      (*type) = LW6HLP_TYPE_VOID;
      ret = _("Shows the date when the binary was compiled.");
    }
  else if (lw6hlp_match (keyword, "show-build-time"))
    {
      (*type) = LW6HLP_TYPE_VOID;
      ret = _("Shows the time when the binary was compiled.");
    }
  else if (lw6hlp_match (keyword, "show-build-target-cpu"))
    {
      (*type) = LW6HLP_TYPE_VOID;
      ret =
	_
	("Shows the target CPU, as defined by 'target_cpu' in GNU Autoconf.");
    }
  else if (lw6hlp_match (keyword, "show-build-target-os"))
    {
      (*type) = LW6HLP_TYPE_VOID;
      ret =
	_("Shows the target OS, as defined by 'target_os' in GNU Autoconf.");
    }
  else if (lw6hlp_match (keyword, "show-build-ms-windows"))
    {
      (*type) = LW6HLP_TYPE_VOID;
      ret =
	_
	("Returns 1 (true) if target OS is Microsoft Windows 32-bit platform, 0 (false) if not.");
    }
  else if (lw6hlp_match (keyword, "show-build-top-srcdir"))
    {
      (*type) = LW6HLP_TYPE_VOID;
      ret =
	_
	("Shows the top source directory on the machine where the binary was compiled.");
    }
  else if (lw6hlp_match (keyword, "show-build-prefix"))
    {
      (*type) = LW6HLP_TYPE_VOID;
      ret =
	_
	("Shows the 'prefix' value as passed to the GNU Autoconf './configure' script when compiling the program. Default is '/usr/local'.");
    }
  else if (lw6hlp_match (keyword, "show-build-datadir"))
    {
      (*type) = LW6HLP_TYPE_VOID;
      ret =
	_
	("Shows the 'datadir' value as passed to the GNU Autoconf './configure' script when compiling the program. Default is '/usr/local/share'. This is the generic, non Liquid War 6 specific data directory. Liquid War 6 related data is stored elsewhere (usually in a sub-directory), see the 'data-dir' switch for more information. 'datadir' is not 'data-dir'. That's the point.");
    }
  else if (lw6hlp_match (keyword, "show-build-libdir"))
    {
      (*type) = LW6HLP_TYPE_VOID;
      ret =
	_
	("Shows the 'libdir' value as passed to the GNU Autoconf './configure' script when compiling the program. Default is '/usr/local/lib'. This is the generic, non Liquid War 6 specific library directory. Dedicated Liquid War 6 modules are stored elsewhere (usually in a sub-directory), see the 'mod-dir' switch for more information.");
    }
  else if (lw6hlp_match (keyword, "show-build-includedir"))
    {
      (*type) = LW6HLP_TYPE_VOID;
      ret =
	_
	("Shows the 'includedir' value as passed to the GNU Autoconf './configure' script when compiling the program. Default is '/usr/local/include'.");
    }
  else if (lw6hlp_match (keyword, "show-build-localedir"))
    {
      (*type) = LW6HLP_TYPE_VOID;
      ret =
	_
	("Shows the 'localedir' value as passed to the GNU Autoconf './configure' script when compiling the program. Default is '/usr/local/share/locale'.");
    }
  else if (lw6hlp_match (keyword, "show-build-docdir"))
    {
      (*type) = LW6HLP_TYPE_VOID;
      ret =
	_
	("Shows the 'docdir' value as passed to the GNU Autoconf './configure' script when compiling the program. Default is '/usr/local/share/doc/liquidwar6'.");
    }
  else if (lw6hlp_match (keyword, "show-build-enable-console"))
    {
      (*type) = LW6HLP_TYPE_VOID;
      ret =
	_
	("Shows wether the console has been enabled when building the game. This depends on parameters passed to './configure' and also on the presence of ncurses and readline.");
    }
  else if (lw6hlp_match (keyword, "show-build-enable-mod-gl"))
    {
      (*type) = LW6HLP_TYPE_VOID;
      ret =
	_
	("Shows wether the mod-gl graphical backend has been enabled when building the game. This depends on parameters passed to './configure' and also on the presence of SDL and related libraries.");
    }
  else if (lw6hlp_match (keyword, "show-build-enable-mod-csound"))
    {
      (*type) = LW6HLP_TYPE_VOID;
      ret =
	_
	("Shows wether the mod-csound audio backend has been enabled when building the game. This depends on parameters passed to './configure' and also on the presence of the csound library.");
    }
  else if (lw6hlp_match (keyword, "show-build-enable-mod-ogg"))
    {
      (*type) = LW6HLP_TYPE_VOID;
      ret =
	_
	("Shows wether the mod-ogg audio backend has been enabled when building the game. This depends on parameters passed to './configure' and also on the presence of SDL and related libraries.");
    }
  else if (lw6hlp_match (keyword, "show-build-enable-mod-http"))
    {
      (*type) = LW6HLP_TYPE_VOID;
      ret =
	_
	("Shows wether the mod-http network backend has been enabled when building the game. This depends on parameters passed to './configure' and also on the presence of libCurl.");
    }
  else if (lw6hlp_match (keyword, "show-build-enable-allinone"))
    {
      (*type) = LW6HLP_TYPE_VOID;
      ret =
	_
	("Shows wether the 'allinone' option has been chosen when building the game. This depends on parameters passed to './configure'.");
    }
  else if (lw6hlp_match (keyword, "show-build-enable-fullstatic"))
    {
      (*type) = LW6HLP_TYPE_VOID;
      ret =
	_
	("Shows wether the 'fullstatic' option has been chosen when building the game. This depends on parameters passed to './configure'.");
    }
  else if (lw6hlp_match (keyword, "show-build-enable-gprof"))
    {
      (*type) = LW6HLP_TYPE_VOID;
      ret =
	_
	("Shows wether the game was build with suitable informations for gprof. This depends on parameters passed to './configure'.");
    }
  else if (lw6hlp_match (keyword, "show-build-enable-valgrind"))
    {
      (*type) = LW6HLP_TYPE_VOID;
      ret =
	_
	("Shows wether the game was build with valgrind later use in mind. This depends on parameters passed to './configure'.");
    }
  /*
   * Show default paths
   */
  else if (lw6hlp_match (keyword, "show-default-user-dir"))
    {
      (*type) = LW6HLP_TYPE_VOID;
      ret =
	_
	("Shows the default user directory path. This is where run-time data, config files, log files, are stored. Default is '$HOME/.liquidwar6/'.");
    }
  else if (lw6hlp_match (keyword, "show-default-config-file"))
    {
      (*type) = LW6HLP_TYPE_VOID;
      ret =
	_
	("Shows the default config file path. Default is '$HOME/.liquidwar6/config.xml'.");
    }
  else if (lw6hlp_match (keyword, "show-default-log-file"))
    {
      (*type) = LW6HLP_TYPE_VOID;
      ret =
	_
	("Shows the default log file path. Default is '$HOME/.liquidwar6/log.csv'.");
    }
  else if (lw6hlp_match (keyword, "show-default-prefix"))
    {
      (*type) = LW6HLP_TYPE_VOID;
      ret =
	_
	("Shows the default prefix used. This should logically be the value passed to the GNU Autoconf ./configure script when building the game. Most other path are deduced from this one. Default is '/usr/local'.");
    }
  else if (lw6hlp_match (keyword, "show-default-mod-dir"))
    {
      (*type) = LW6HLP_TYPE_VOID;
      ret =
	_
	("Shows the default module directory path. This is where all dynamically loaded modules are stored. Default is '/usr/local/lib/liquidwar6-<version>'.");
    }
  else if (lw6hlp_match (keyword, "show-default-data-dir"))
    {
      (*type) = LW6HLP_TYPE_VOID;
      ret =
	_
	("Shows the default data directory path. This is where the games searches for most of its data,the most important exception being maps, which are stored elsewhere. Default is '/usr/local/share/liquidwar6-<version>/data'.");
    }
  else if (lw6hlp_match (keyword, "show-default-map-dir"))
    {
      (*type) = LW6HLP_TYPE_VOID;
      ret =
	_
	("Shows the default map directory. This is where builtin maps are stored. Default is '/usr/local/share/liquidwar6-<version>/map'.");
    }
  else if (lw6hlp_match (keyword, "show-default-map-path"))
    {
      (*type) = LW6HLP_TYPE_VOID;
      ret =
	_
	("Shows the default map search path. This is where the game searches for maps. It's the combination of command-line arguments and builtin paths. Might return more directories than the one specified in a single 'map-path=dir1:dir2' argument.");
    }
  else if (lw6hlp_match (keyword, "show-default-script-file"))
    {
      (*type) = LW6HLP_TYPE_VOID;
      ret =
	_
	("Shows the default main script file path. This file is very important, since the program is more or less a hudge scheme interpreter, and this file is the file loaded by Guile. In short, it is the main program. Default is '/usr/local/share/liquidwar6-<version>/script/liquidwar6.scm'.");
    }
  /*
   * Show paths
   */
  else if (lw6hlp_match (keyword, "show-cwd"))
    {
      (*type) = LW6HLP_TYPE_VOID;
      ret =
	_
	("Shows the current working directory, the value that the pwd command would return.");
    }
  else if (lw6hlp_match (keyword, "show-run-dir"))
    {
      (*type) = LW6HLP_TYPE_VOID;
      ret =
	_
	("Shows the run directory, usually the path where the binary is. It depends on how and where the program is launched. It is guessed from the argc/argv values at runtime.");
    }
  else if (lw6hlp_match (keyword, "show-user-dir"))
    {
      (*type) = LW6HLP_TYPE_VOID;
      ret =
	_
	("Shows the user directory path. This is where run-time data, config files, log files, are stored. Default is '$HOME/.liquidwar6/'.");
    }
  else if (lw6hlp_match (keyword, "show-config-file"))
    {
      (*type) = LW6HLP_TYPE_VOID;
      ret =
	_
	("Shows the config file path. Default is '$HOME/.liquidwar6/config.xml'.");
    }
  else if (lw6hlp_match (keyword, "show-log-file"))
    {
      (*type) = LW6HLP_TYPE_VOID;
      ret =
	_("Shows the log file path. Default is '$HOME/.liquidwar6/log.csv'.");
    }
  else if (lw6hlp_match (keyword, "show-prefix"))
    {
      (*type) = LW6HLP_TYPE_VOID;
      ret =
	_
	("Shows the prefix used. This should logically be the value passed to the GNU Autoconf ./configure script when building the game. Most other path are deduced from this one. Default is '/usr/local'.");
    }
  else if (lw6hlp_match (keyword, "show-mod-dir"))
    {
      (*type) = LW6HLP_TYPE_VOID;
      ret =
	_
	("Shows the module directory path. This is where all dynamically loaded modules are stored. Default is '/usr/local/lib/liquidwar6-<version>'.");
    }
  else if (lw6hlp_match (keyword, "show-data-dir"))
    {
      (*type) = LW6HLP_TYPE_VOID;
      ret =
	_
	("Shows the data directory path. This is where the games searches for most of its data,the most important exception being maps, which are stored elsewhere. Default is '/usr/local/share/liquidwar6-<version>/data'.");
    }
  else if (lw6hlp_match (keyword, "show-map-dir"))
    {
      (*type) = LW6HLP_TYPE_VOID;
      ret =
	_
	("Shows the map directory. This is where builtin maps are stored. Default is '/usr/local/share/liquidwar6-<version>/map'.");
    }
  else if (lw6hlp_match (keyword, "show-map-path"))
    {
      (*type) = LW6HLP_TYPE_VOID;
      ret =
	_
	("Shows the map search path. This is where the game searches for maps. It's the combination of command-line arguments and builtin paths. Might return more directories than the one specified in a single 'map-path=dir1:dir2' argument.");
    }
  else if (lw6hlp_match (keyword, "show-script-file"))
    {
      (*type) = LW6HLP_TYPE_VOID;
      ret =
	_
	("Shows the main script file path. This file is very important, since the program is more or less a hudge scheme interpreter, and this file is the file loaded by Guile. In short, it is the main program. Default is '/usr/local/share/liquidwar6-<version>/script/liquidwar6.scm'.");
    }
  /*
   * Paths
   */
  else if (lw6hlp_match (keyword, "user-dir"))
    {
      (*type) = LW6HLP_TYPE_STR;
      ret =
	_
	("Set the user directory path. This is where run-time data, config files, log files, are stored. If you override this value, other parameters such as where the config and log files reside, will change. Default is '$HOME/.liquidwar6'.");
    }
  else if (lw6hlp_match (keyword, "config-file"))
    {
      (*type) = LW6HLP_TYPE_STR;
      ret =
	_
	("Set the config file path. This enables you to use whatever config file you like, keeping all other informations in the same place. Default is '$HOME/.liquidwar6/config.xml'.");
    }
  else if (lw6hlp_match (keyword, "log-file"))
    {
      (*type) = LW6HLP_TYPE_STR;
      ret =
	_
	("Set the log file path. This enables you to use whatever log file you like, keeping all other informations in the same place. Default is '$HOME/.liquidwar6/log.csv'.");
    }
  else if (lw6hlp_match (keyword, "prefix"))
    {
      (*type) = LW6HLP_TYPE_STR;
      ret =
	_
	("Override the prefix value given to the GNU Autoconf ./configure script when building the game. Not all path will be changed, some of them might remain the same, for instance message translations (localedir). But most game-specific data including maps, graphics, sounds, will be searched according to the new given parameter. Default is '/usr/local'.");
    }
  else if (lw6hlp_match (keyword, "mod-dir"))
    {
      (*type) = LW6HLP_TYPE_STR;
      ret =
	_
	("Set the module directory path. By changing this you will load dynamic shared libraries (game specific modules such as the graphical backend) from an alternative place. Use this at your own risks, for there can always be a binary incompatibility. You've been warned. Default is '/usr/local/lib/liquidwar6-<version>'.");
    }
  else if (lw6hlp_match (keyword, "data-dir"))
    {
      (*type) = LW6HLP_TYPE_STR;
      ret =
	_
	("Set the data directory. By changing ths value you'll be able to use an alternative data directory. Default is '/usr/local/share/liquidwar6-<version>/data'.");
    }
  else if (lw6hlp_match (keyword, "map-dir"))
    {
      (*type) = LW6HLP_TYPE_STR;
      ret =
	_
	("Set the map directory path. By changing this value you'll be able to play with your own maps in your own directory. Note that there are other ways to achieve that, but using this option will work. However, a side effect is that you might not see builtin maps anymore. Default is '/usr/local/share/liquidwar6-<version>/map'.");
    }
  else if (lw6hlp_match (keyword, "map-path"))
    {
      (*type) = LW6HLP_TYPE_STR;
      ret =
	_
	("Set the map search path. By changing this value you'll be able to play with your own maps in your own directory. This is different from 'map-dir', since it includes 'map-dir', plus it adds a number of other search paths. Unlike most other parameters, the values given from the command-line, from the environment variables, or from the config file, are not overwritten, but appended. That is to say if you specify a 'map-path' with the command-line argument 'map-path=path', but also define the 'LW6_MAP_PATH' value and finally edit 'config.xml' to change the 'map-path' entry in it, you'll end up with the game searching for maps in all these directories. Additionnally, 'map-dir' and '<user-dir>/map' will always be in the list. Any given value can itself include several pathes, separated by the path separator. This separator is ':' on GNU/Linux, and ';' on Microsoft Windows. For instance, on a GNU/Linux box, you could use the command-line argument 'map-path=/foo/bar/map:/home/user/map/:/map'.");
    }
  else if (lw6hlp_match (keyword, "script-file"))
    {
      (*type) = LW6HLP_TYPE_STR;
      ret =
	_
	("Set the main script file path. This file is very important, since the program is more or less a hudge scheme interpreter, and this file is the file loaded by Guile. In short, it is the main program. Default is '/usr/local/share/liquidwar6-<version>/script/liquidwar6.scm'.");
    }
  /*
   * Players
   */
  else if (lw6hlp_match (keyword, "player1-name"))
    {
      (*type) = LW6HLP_TYPE_STR;
      ret =
	_
	("Name of the first player, the player used by default. A default value is provided, you can of course, change it at will.");;
    }
  else if (lw6hlp_match (keyword, "player2-name"))
    {
      (*type) = LW6HLP_TYPE_STR;
      ret =
	_
	("Name of the second player. A default value is provided, you'll certainly want to change it.");;
    }
  else if (lw6hlp_match (keyword, "player3-name"))
    {
      (*type) = LW6HLP_TYPE_STR;
      ret =
	_
	("Name of the third player. A default value is provided, you'll certainly want to change it.");;
    }
  else if (lw6hlp_match (keyword, "player4-name"))
    {
      (*type) = LW6HLP_TYPE_STR;
      ret =
	_
	("Name of the fourth player. A default value is provided, you'll certainly want to change it.");;
    }
  /*
   * Graphics
   */
  else if (lw6hlp_match (keyword, "width"))
    {
      (*type) = LW6HLP_TYPE_INT;
      ret =
	_
	("Run the game with the given screen width. Note that the graphics backend might ignore this hint.Use with its companion option 'height'.");;
    }
  else if (lw6hlp_match (keyword, "height"))
    {
      (*type) = LW6HLP_TYPE_INT;
      ret =
	_
	("Run the game with the given screen height.Note that the graphics backend might ignore this hint.Use with its companion option 'width'.");
    }
  else if (lw6hlp_match (keyword, "fullscreen"))
    {
      (*type) = LW6HLP_TYPE_BOOL;
      ret =
	_
	("Force the game to fun fullscreen. Note that the graphics backend might ignore this hint.");
    }
  else if (lw6hlp_match (keyword, "display-fps"))
    {
      (*type) = LW6HLP_TYPE_BOOL;
      ret =
	_
	("Set this to 'true' to display the number of frames per second. When this gets too low... play a smaller map, buy a new computer or contribute and hack Liquid War 6 so that it runs faster!");
    }
  /*
   * Sound
   */
  else if (lw6hlp_match (keyword, "sound-volume"))
    {
      (*type) = LW6HLP_TYPE_FLOAT;
      ret =
	_
	("Set the sound volume.This is a floating point value.0 is mute.Maximum value is 1. ");
    }
  else if (lw6hlp_match (keyword, "music-volume"))
    {
      (*type) = LW6HLP_TYPE_FLOAT;
      ret =
	_
	(" Set the music volume.This is a floating point value.0 is mute.Maximum value is 1. ");
    }
  /*
   * Tuning
   */
  else if (lw6hlp_match (keyword, "log-level"))
    {
      (*type) = LW6HLP_TYPE_INT;
      ret =
	_
	("Defines the log level, that is, how verbose the program will be regarding logs and console output. 0 (ERROR) is the minimum, only errors are reported. 1 (WARNING) means errors + warnings. 2 (NOTICE) displays most important messages. 3 (INFO) is the default, the log file will contain all messages but debug stuff. 4 (DEBUG) logs everything, including debug informations.");
    }
  else if (lw6hlp_match (keyword, "max-frames-per-sec"))
    {
      (*type) = LW6HLP_TYPE_INT;
      ret =
	_
	("Defines how many frames will be displayed per second. Of course this is a maximum value, if your hardware can't keep up with this value, display will just be slow, no matter what value you define here. Note that you might really wish to have something rather low here, to keep network and 'logic' function responsiveness. Passed 60 frames per second, speed is really only for visual comfort, as Liquid War 6 is now so fast-paced that it requires 200 frames/sec to outperform opponents.");
    }
  else if (lw6hlp_match (keyword, "max-logic-per-sec"))
    {
      (*type) = LW6HLP_TYPE_INT;
      ret =
	_
	("Defines how many calls to the internal logic() function there will be during a second. This is really an internal value, the actual speed of the game, that is, how fast fighters will move, is defined elsewhere in the map parameters. See 'moves-per-tick' for instance. Default value should fit in most cases.");
    }
  else if (lw6hlp_match (keyword, "max-io-per-sec"))
    {
      (*type) = LW6HLP_TYPE_INT;
      ret =
	_
	("Defines how many calls to the internal input/output function there will be during a second. Might condition network responsiveness. Default value should fit in most cases.");
    }
  else if (lw6hlp_match (keyword, "max-logic-per-display"))
    {
      (*type) = LW6HLP_TYPE_INT;
      ret =
	_
	("This is a limit value which will avoid, on slow machines, to spend all the CPU cycles to calculate internal things, and display nothing. While it's important to keep up with other network players for instance, it makes no sense to do it for a long period without showing anything. Thus, this value. Basically, it only helps not being locked-out in an 'I can't quit' nightmare when running fullscreen on a slow machine.");
    }
  else if (lw6hlp_match (keyword, "max-io-per-display"))
    {
      (*type) = LW6HLP_TYPE_INT;
      ret =
	_
	("Like 'max-logic-per-display', but input/output related. If too much time is spent on IO stuff, the game will simply drop out and stop processing IO, giving priority to display. Logically, when display is fast, about one IO per display is just enough.");
    }
  else if (lw6hlp_match (keyword, "checkpoint-period"))
    {
      (*type) = LW6HLP_TYPE_INT;
      ret =
	_
	("Defines with what period (in msec) system values such as frames per sec, network traffic, and others, will be updated. Default value should fit in most cases.");
    }
  else if (lw6hlp_match (keyword, "loader-sleep"))
    {
      (*type) = LW6HLP_TYPE_FLOAT;
      ret =
	_
	("Defines how long the loader thread should wait between two polls. Default value should fit in most cases.");
    }
  else if (lw6hlp_match (keyword, "memory-bazooka-size"))
    {
      (*type) = LW6HLP_TYPE_INT;
      ret =
	_
	("The memory bazooka is a brute-force tool, conceived after a full night spent tracking some memory leak. The idea is to keep a track of all allocated pointers, when the data was allocated (timestamp), where in the code (file, line), and even point out what data there is in that place. A memory bazooka report at the end of the game will just show what's left. There should be nothing. This parameter is here to avoid wasting CPU cycles on a feature which is very debug-oriented and does not really make sense for the casual user. Set it to 0 for best performance, something like 100 might just be helpfull, but 1000000 is the right way to seriously debug code.");
    }
  else if (lw6hlp_match (keyword, "memory-bazooka-eraser"))
    {
      (*type) = LW6HLP_TYPE_BOOL;
      ret =
	_
	("The memory eraser is a tool which will systematically fill allocated memory with 'M', and overwrite all allocated bytes with 'F' before freeing memory. It will even handle realloc calls. This is usefull to track bugs. Indeed, with this option enabled, freshly allocated memory will never contain zeroes unless one calls calloc, and if you ever free some memory zone before being done with it, it will be filled with junk and therefore not be usable. The memory bazzooka must be big enough if you want this feature to actually work.");
    }
  /*
   * Game settings
   */
  else if (lw6hlp_match (keyword, "chosen-map"))
    {
      (*type) = LW6HLP_TYPE_STR;
      ret =
	_
	("The last map chosen by the player, locally. This is the map which will be used for a quick-start game, a local game, or a game started as a server.");
    }
  else if (lw6hlp_match (keyword, "use-map-options"))
    {
      (*type) = LW6HLP_TYPE_BOOL;
      ret =
	_
	("If set, then options will be picked up from the map defined options.xml, if it exists. This is the default. Use force-time and force-size to override this and use user-defined values anyway.");
    }
  else if (lw6hlp_match (keyword, "use-map-style"))
    {
      (*type) = LW6HLP_TYPE_BOOL;
      ret =
	_
	("If set, then style will be picked up from the map defined options.xml, if it exists. This is the default. Use force-time and force-background to override this and use user-defined values anyway.");
    }
  else if (lw6hlp_match (keyword, "force-time"))
    {
      (*type) = LW6HLP_TYPE_BOOL;
      ret =
	_
	("If set, entries in options.xml (map specific file) which are time-related won't be picked from the map, but overriden by user-defined values. This allows you to change only the speed/duration of the game without altering other parameters.");
    }
  else if (lw6hlp_match (keyword, "force-size"))
    {
      (*type) = LW6HLP_TYPE_BOOL;
      ret =
	_
	("If set, entries in options.xml (map specific file) which are size-related won't be picked from the map, but overriden by user-defined values. This allows you to change only the size of the map, the number of fighters on it, without altering other parameters.");
    }
  else if (lw6hlp_match (keyword, "force-background"))
    {
      (*type) = LW6HLP_TYPE_BOOL;
      ret =
	_
	("If set, entries in style.xml (map specific file) which are background related won't be picked from the map, but overriden by user-defined values. Allows you to use your own background settings while keeping other parameters the same.");
    }
  else if (lw6hlp_match (keyword, "force-hud"))
    {
      (*type) = LW6HLP_TYPE_STR;
      ret =
	_
	("If set, entries in style.xml (map specific file) which are hud related won't be picked from the map, but overriden by user-defined values. Allows you to use your own hud settings while keeping other parameters the same.");
    }
  else if (lw6hlp_match (keyword, "force-menu"))
    {
      (*type) = LW6HLP_TYPE_BOOL;
      ret =
	_
	("If set, entries in style.xml (map specific file) which are menu related won't be picked from the map, but overriden by user-defined values. Allows you to use your own menu settings while keeping other parameters the same.");
    }
  else if (lw6hlp_match (keyword, "force-view"))
    {
      (*type) = LW6HLP_TYPE_BOOL;
      ret =
	_
	("If set, entries in style.xml (map specific file) which are view related won't be picked from the map, but overriden by user-defined values. Allows you to use your own view settings while keeping other parameters the same. Reminder: in LW6 the view is the map, the area you're playing on.");
    }
  else if (lw6hlp_match (keyword, "force-team-colors"))
    {
      (*type) = LW6HLP_TYPE_BOOL;
      ret =
	_
	("If set, then team colors won't be picked from the map (in style.xml) but user-defined values will be used instead.");
    }
  /*
   * Map options
   */
  else if (lw6hlp_match (keyword, "total-time"))
    {
      (*type) = LW6HLP_TYPE_INT;
      ret =
	_
	("Defines the maximum time of the game, in seconds. Note that in some cases, the game can end much earlier if some player has managed to win before the bell rings. Also, technically, this value will be translated into rounds and moves, and the game engine will wait until enough rounds and moves have been played. So if the computer is too slow and the desired speed is not reached, then the game will last for a longer time.");
    }
  else if (lw6hlp_match (keyword, "respawn-team"))
    {
      (*type) = LW6HLP_TYPE_INT;
      ret =
	_
	("Defines what to do when a team dies. If set to 0, team disappears forever, if set to 1, team reappears automatically with fresh fighters. It's a deathmatch mode, where the winner is not the one who stays alive the longest time, since it makes no real sens in this case, but the one who has died less often than others.");
    }
  else if (lw6hlp_match (keyword, "moves-per-round"))
    {
      (*type) = LW6HLP_TYPE_INT;
      ret =
	_
	("Defines how many times fighters move per round. Increasing this will just make fighters move faster, but won't change anything for the rest, that is keyboard and mouse responsivity, and network traffic will stay the same. Multiplying the number of moves per round by the number of rounds per second will give the number of moves per second, which is, in fact, how fast fighters move on the screen.");
    }
  else if (lw6hlp_match (keyword, "spreads-per-round"))
    {
      (*type) = LW6HLP_TYPE_INT;
      ret =
	_
	("Defines how many times the gradient is spread per round. Gradient spread is a very Liquid War 6 specific feature, just remember that the more often you do it, the more accurately fighters will move. That is, you will be sure they really take the shortest path. Usually this does not have much effect, the default value should fit in most cases, but you might want to decrease it on very simple maps where the gradient is obvious, or increase it on complex maps where you want fighters to be real smart.");
    }
  else if (lw6hlp_match (keyword, "rounds-per-sec"))
    {
      (*type) = LW6HLP_TYPE_INT;
      ret =
	_
	("Defines the overall speed of the game. All other settings being equal, raising this value will cause the game to behave faster. Everything will be faster, except probably the display since your computer will calculate more game positions in a given time and spend more CPU time. It will also increase network traffic. Values between 10 and 50 really make sense.");
    }
  else if (lw6hlp_match (keyword, "fighter-attack"))
    {
      (*type) = LW6HLP_TYPE_INT;
      ret =
	_
	("Defines how hard fighters will attack others, that is, in one attack, how many life-points the attacked fighter will loose. Increasing this will cause your opponents to melt faster when you attack them. With a low value, it will take ages to take on your opponents. Different styles of game. Can radically change the gameplay.");
    }
  else if (lw6hlp_match (keyword, "fighter-defense"))
    {
      (*type) = LW6HLP_TYPE_INT;
      ret =
	_
	("Defines how fast fighters will regenerate after an attack. When this parameter is set low, an attacked fighter, which is very dark and almost dead will take a very long time to regain energy. If the parameter is set high, it can almost instantaneously regain energy.");
    }
  else if (lw6hlp_match (keyword, "fighter-new-health"))
    {
      (*type) = LW6HLP_TYPE_INT;
      ret =
	_
	("Defines how healthy fighters will be when they appear on the map. This can be either at the beginning of the game of when a fighter changes team. Setting this low will allow battefields to switch from one side to another very fast, for freshly gained fighters will be feeble and very likely to return to their original camp.");
    }
  else if (lw6hlp_match (keyword, "side-attack-factor"))
    {
      (*type) = LW6HLP_TYPE_INT;
      ret =
	_
	("Defines how hard fighters will attack sideways. It's an algorithm trick, fighters attack by default the opponent right in front, but if there's no fighter there, they will still try to attack someone else, maybe sideways. But doing this their attack is not as strong. This parameter enables you to tune this. This is a percentage.");
    }
  else if (lw6hlp_match (keyword, "side-defense-factor"))
    {
      (*type) = LW6HLP_TYPE_INT;
      ret =
	_
	("Defines how fast fighters will regenerate, when being side by side instead of being right in front of the other. This is a percentage.");
    }
  else if (lw6hlp_match (keyword, "nb-move-tries"))
    {
      (*type) = LW6HLP_TYPE_INT;
      ret =
	_
	("Defines how many tries a fighter will do before giving-up moving and choosing another behvior (attack or defense). By tries we mean: how many directions it will try. Going North? Going North-West? Setting this to a low value, your fighters will look very stubborn and always try to move in one direction, neglecting the fact that they could dodge. This can lead to queues of fighters and other strange behaviors. On the other hand, setting it too high will cause fighter to always avoid the enemy, and groups of fighters will just pass each other without any fight. Matter of taste.");
    }
  else if (lw6hlp_match (keyword, "nb-attack-tries"))
    {
      (*type) = LW6HLP_TYPE_INT;
      ret =
	_
	("Defines how many tries a fighter will do before giving-up attacking and choosing another behvior (defense). By tries we mean: how many directions it will try. Going North? Going North-West? Setting this to a low value will make fighters somewhat less aggressive. This idea is that they'll prefer to switch to the next option, that is, defense/regeneration, if there's no opponent right in front of them.");
    }
  else if (lw6hlp_match (keyword, "nb-defense-tries"))
    {
      (*type) = LW6HLP_TYPE_INT;
      ret =
	_
	("Defines how many tries a fighter will do before giving-up attacking and choosing another behavior (do nothing). By tries we mean: how many directions it will try. Going North? Going North-West? Setting this to a low value, you'll need a very compact pack of fighters for regeneration to operate, else fighters will hang arround unhealthy.");
    }
  else if (lw6hlp_match (keyword, "single-army-surface"))
    {
      (*type) = LW6HLP_TYPE_INT;
      ret =
	_
	("Defines the proportion of the whole available space, which will be occupied by an army at the beginning of the game. You can either imagine playing with almost empty maps, or play very crowded with almost no space left. This is not a percentage, it's in a per-thousand unit. 1000 means full packed, but since it makes no sense, it's forbidden.");
    }
  else if (lw6hlp_match (keyword, "total-armies-surface"))
    {
      (*type) = LW6HLP_TYPE_INT;
      ret =
	_
	("Defines the proportion of the whole available space, which can be occupied by all the armies present together. Setting this low, whenever a new team arrives on the map, fighters might be stolen to other teams, otherwise the ame would get too crowded. This allows you to play with reasonnably enough fighters with 2 players, while still allowing interesting gameplay with many players. This is not a percentage, it's in a per-thousand unit. 1000 means full packed, but since it makes no sense, it's forbidden.");
    }
  else if (lw6hlp_match (keyword, "max-nb-teams"))
    {
      (*type) = LW6HLP_TYPE_INT;
      ret =
	_
	("Defines the maximum number of teams who can enter the game. Really makes sense in network games. Default value should fit for most cases.");
    }
  else if (lw6hlp_match (keyword, "x-polarity"))
    {
      (*type) = LW6HLP_TYPE_INT;
      ret =
	_
	("Defines how the map will be wrapped on the X (horizontal) axis. If set to 0, nothing is wrapped. If set to 1, the right and left borders are connected, any fighter can disappear on the right border and reappear on the left border, for instance. If set to -1, it will be wrapped but also inversed, that is on a 320x240 map, a fighter disappearing on the left border at position (0,60) will reapper on the right border at position (319,180). You can combine it with 'y-polarity'.");
    }
  else if (lw6hlp_match (keyword, "y-polarity"))
    {
      (*type) = LW6HLP_TYPE_INT;
      ret =
	_
	("Defines how the map will be wrapped on the Y (vertical) axis. If set to 0, nothing is wrapped. If set to 1, the top and bottom borders are connected, any fighter can disappear on the top border and reappear on the bottom border, for instance. If set to -1, it will be wrapped but also inversed, that is on a 320x240 map, a fighter disappearing on the bottom border at position (40,239) will reapper on the top border at position (280,0). You can combine it with 'x-polarity'.");
    }
  else if (lw6hlp_match (keyword, "max-zone-size"))
    {
      (*type) = LW6HLP_TYPE_INT;
      ret =
	_
	("Defines the maximum zone size, which is an internal and rather technical parameter. The idea is that to optimize things, Liquid War 6 divides the battlefield in squares, where it can, and tries to make these squares as big as possible, the idea being that everywhere in this square, fighters follow the same intructions. Just a technical optimization. The problem is that setting it too high will reveal the optimization and its tradeoffs to the player, who will see the fighter behave strangely, following invisible paths. Plus, it's ugly. Depending on your tastes (speed, look'n'feel) you'll prefer something nice or something fast. Note that anyways passed a certain value, this does not optimize anything anymore. In doubt, don't touch it.");
    }
  else if (lw6hlp_match (keyword, "min-map-width"))
    {
      (*type) = LW6HLP_TYPE_INT;
      ret =
	_
	("Allows you to give a minimum map width. When designing a map you might wonder: this is dumb I'm conceiving this map I know its width, why should I limit it? Now think of the player who decided to play with highly-defined maps because he has a super calculator and a hudge screen. He might redefine this himself, and does not necessarly wishes to fire Gimp to rescale the map.");
    }
  else if (lw6hlp_match (keyword, "max-map-width"))
    {
      (*type) = LW6HLP_TYPE_INT;
      ret =
	_
	("Allows you to give a maximum map width. When designing a map you might wonder: this is dumb I'm conceiving this map I know its width, why should I limit it? Now think of the play who plays on a old slowish computer with a tiny screen. He might redefine this himself, and does not necessarly wishes to fire Gimp to rescale the map.");
    }
  else if (lw6hlp_match (keyword, "min-map-height"))
    {
      (*type) = LW6HLP_TYPE_INT;
      ret =
	_
	("Allows you to give a minimum map height. When designing a map you might wonder: this is dumb I'm conceiving this map I know its height, why should I limit it? Now think of the player who decided to play with highly-defined maps because he has a super calculator and a hudge screen. He might redefine this himself, and does not necessarly wishes to fire Gimp to rescale the map.");
    }
  else if (lw6hlp_match (keyword, "max-map-height"))
    {
      (*type) = LW6HLP_TYPE_INT;
      ret =
	_
	("Allows you to give a maximum map height. When designing a map you might wonder: this is dumb I'm conceiving this map I know its height, why should I limit it? Now think of the play who plays on a old slowish computer with a tiny screen. He might redefine this himself, and does not necessarly wishes to fire Gimp to rescale the map.");
    }
  else if (lw6hlp_match (keyword, "min-map-surface"))
    {
      (*type) = LW6HLP_TYPE_INT;
      ret =
	_
	("Allows you to give a minimum map surface. Map surface is simply (width * height). This parameter is just here to save you the hassle of defining both 'min-map-width' and 'min-map-height' in a consistent manner.");
    }
  else if (lw6hlp_match (keyword, "max-map-surface"))
    {
      (*type) = LW6HLP_TYPE_INT;
      ret =
	_
	("Allows you to give a maximum map surface. Map surface is simply (width * height). This parameter is just here to save you the hassle of defining both 'max-map-width' and 'max-map-height' in a consistent manner.");
    }
  else if (lw6hlp_match (keyword, "bot-wait-between-moves"))
    {
      (*type) = LW6HLP_TYPE_INT;
      ret =
	_
	("How many rounds a bot will wait before chosing a different destination. Probably a temporary parameter until clever bot behavior is implemented.");
    }
  else if (lw6hlp_match (keyword, "bot-nb-move-steps"))
    {
      (*type) = LW6HLP_TYPE_INT;
      ret =
	_
	("How many steps a bot move will take. This means, once the bot has chosen a direction, in how many rounds it will go there. Probably a temporary parameter until clever bot behavior is implemented.");
    }
  else if (lw6hlp_match (keyword, "round-delta"))
    {
      (*type) = LW6HLP_TYPE_INT;
      ret =
	_
	("Conditions by how much the cursor potential will be incremented each time gradient is spreaded. Sounds cryptic? It is. The idea is that at each time you move your cursor of 1 pixel, theorically, you'll need in the worst case to move of 1 more pixel to reach any point on the map. Of course this is not true but this is the default asumption, and gradient spread will fix that. Only in Liquid War 6 this is not even the worst case, for you can control your cursor with the mouse and cross walls. Whenever you cross a wall, you might have done a great distance from the fighters' point of view, if the map is a maze. Thus this parameter, which corrects things, experience shows it does give acceptable results to increase the cursor potential by more than one at each turn. Toy arround with this if you find fighters take wrong paths on some given map. If in doubt, don't touch.");
    }
  else if (lw6hlp_match (keyword, "max-round-delta"))
    {
      (*type) = LW6HLP_TYPE_INT;
      ret =
	_
	("This is the companion value of 'round-delta'. Will put an absolute limit to the delta, which (what did you think?) is of course incremented in some cases by the core algorithm. If in doubt, don't touch.");
    }
  else if (lw6hlp_match (keyword, "max-cursor-pot"))
    {
      (*type) = LW6HLP_TYPE_INT;
      ret =
	_
	("Defines the maximum cursor potential. Not really any reason to change it. Any high value should produce the same results. Low values might reveal algorithm bugs and inconsistencies.");
    }
  else if (lw6hlp_match (keyword, "cursor-pot-init"))
    {
      (*type) = LW6HLP_TYPE_INT;
      ret =
	_
	("Defines the cursor potential at startup. Not really any reason to change it. Theorically, there could be maps where the default value doesn't fit, but none has been seen yet.");
    }
  else if (lw6hlp_match (keyword, "max-cursor-pot-offset"))
    {
      (*type) = LW6HLP_TYPE_INT;
      ret =
	_
	("Defines the maximum cursor potential offset. The idea is that in some cases, the potential of a cursor can increase in burst mode, for instance to make this cursor more important than others, so that fighters rally to it, neglecting other cursors (talking about a multi-cursor controlled team). This parameter is here to limit this burst effect and avoid bugs.");
    }
  /*
   * Map style
   */
  else if (lw6hlp_match (keyword, "keep-ratio"))
    {
      (*type) = LW6HLP_TYPE_BOOL;
      ret =
	_
	("Defines wether the map should keep its ratio, or if it should be stretched to fill the shape of your screen.");
    }
  else if (lw6hlp_match (keyword, "zoom"))
    {
      (*type) = LW6HLP_TYPE_FLOAT;
      ret =
	_
	("Defines the map zoom. If lower than 1.0, map will occupy only a fraction of the screen, if greater than 1.0, some areas will be outside the screen, and the player will need to scroll through it.");
    }
  else if (lw6hlp_match (keyword, "fighter-scale"))
    {
      (*type) = LW6HLP_TYPE_FLOAT;
      ret =
	_
	("Defines how wide (in pixels) fighters must be. This parameter is very important and will largely condition the number of fighters on the map. It is used when loading the map. If it is, for instance, set to 1, there will be exactly a fighter per pixel on the screen. That is, if you play 640x480 on an empty map, the maximum fighters you could have is about 300000. The idea is that by changing the resolution, you also define the density of the map. In pratice, this is done in the hope that someone with a slow computer will pick up a low resolution and therefore play small levels. Conversely, someone with a brand new computer with powerfull CPU & GPU will use great resolutions and be happy with many fighters on the map. Still, changing the resolution after loading the map will not affet the number of fighters. Same for network games, the first player, who loads the map, defines its properties according to its own settings.");
    }
  else if (lw6hlp_match (keyword, "use-texture"))
    {
      (*type) = LW6HLP_TYPE_BOOL;
      ret =
	_
	("Defines wether the map texture should be used. Of course if there's no map texture, the texture... won't be used. But if there is one, this parameter will force the game to ignore it and play with solid colors. This probably won't look as nice as the textured map in most cases, but some players might find it more readable and confortable to play when throwing eye candy away.");
    }
  else if (lw6hlp_match (keyword, "background-style"))
    {
      (*type) = LW6HLP_TYPE_STR;
      ret =
	_
	("The background defines, of course, what is displayed at the background, but it also conditions the colors used for other items, such as the menus for instance. Possible values include 'bubbles', 'air', 'fire', 'earth' and 'void'.");
    }
  else if (lw6hlp_match (keyword, "hud-style"))
    {
      (*type) = LW6HLP_TYPE_STR;
      ret =
	_
	("The hud is where informations about the game are displayed. This means, who is winning, are other status-like informations. Possible values include 'floating' and 'tactical'.");
    }
  else if (lw6hlp_match (keyword, "menu-style"))
    {
      (*type) = LW6HLP_TYPE_STR;
      ret =
	_
	("The menu style is simply the name of the engine used to power the menu system. The only possible value, for now, is 'cylinder'.");
    }
  else if (lw6hlp_match (keyword, "view-style"))
    {
      (*type) = LW6HLP_TYPE_STR;
      ret =
	_
	("The view style conditions which renderer is used for the map, the area where fighters are displayed. This is not the graphics backend. Indeed, the graphics backend defines which technical tool one uses (which library) one runs, wether this parameter says what kind of rendering one wants.");
    }
  else if (lw6hlp_match (keyword, "background-density"))
    {
      (*type) = LW6HLP_TYPE_FLOAT;
      ret =
	_
	("Density of the background animation, that is, for instance, if the background animation is about displaying bubbles, using a high value will display many bubbles. A value of 1.0 corresponds to the default setting.");
    }
  else if (lw6hlp_match (keyword, "background-speed"))
    {
      (*type) = LW6HLP_TYPE_FLOAT;
      ret =
	_
	("Speed of the background animation, that is, for instance, if the background animation is about displaying bubbles, using a high value will cause bubbles to move very fast. A value of 1.0 corresponds to the default setting.");
    }
  else if (lw6hlp_match (keyword, "colorize-background"))
    {
      (*type) = LW6HLP_TYPE_BOOL;
      ret =
	_
	("If set, then all background drawings including textures will use the bakground colors. This means, for instance, that if background colors are set automatically by background-color-auto from the map texture, then the background will adopt the same range of colors than the map itself. In short, the background will mimic the map.");
    }
  else if (lw6hlp_match (keyword, "background-color-auto"))
    {
      (*type) = LW6HLP_TYPE_BOOL;
      ret =
	_
	("Defines wether background colors should be set automatically from texture colors. If set to true, then the program will try to pick up colors automatically from the texture, and will override the values of the background-color-base-bg, background-color-base-fg, background-color-alternate-bg and background-color-alternate-fg parameters. How these colors are picked up can't be garanteed, so if the map does not have strong contrast or if there can be any form of ambiguity, it's safe to set this to false and define one's own colors.");
    }
  else if (lw6hlp_match (keyword, "hud-color-auto"))
    {
      (*type) = LW6HLP_TYPE_BOOL;
      ret =
	_
	("Defines wether hud colors will be set automatically from background colors. This is a time saver to keep map designers from requiring to redefined every single color in the game. You only need to set background-color-base-bg, background-color-base-fg, background-color-alternate-bg and background-color-alternate-fg. Then hud_color_frame_bg, hud_color_frame_fg, hud_color_text_bg and hud_color_text_fg will be automatically set.");
    }
  else if (lw6hlp_match (keyword, "menu-color-auto"))
    {
      (*type) = LW6HLP_TYPE_BOOL;
      ret =
	_
	("Defines wether menu colors will be set automatically from background colors. This is a time saver to keep map designers from requiring to redefined every single color in the game. You only need to set background-color-base-bg, background-color-base-fg, background-color-alternate-bg and background-color-alternate-fg. Then menu_color_default_bg, menu_color_default_fg, menu_color_selected_bg, menu_color_selected_fg, menu_color_disabled_bg and menu_color_disabled_fg will be automatically set.");
    }
  else if (lw6hlp_match (keyword, "view-color-auto"))
    {
      (*type) = LW6HLP_TYPE_BOOL;
      ret =
	_
	("Defines wether view colors will be set automatically from background colors. This is a time saver to keep map designers from requiring to redefined every single color in the game. You only need to set background-color-base-bg, background-color-base-fg, background-color-alternate-bg and background-color-alternate-fg. Then view_color_cursor_bg, view_color_cursor_fg, view_color_map_bg and view_color_map_fg will be automatically set.");
    }
  else if (lw6hlp_match (keyword, "system-color-auto"))
    {
      (*type) = LW6HLP_TYPE_BOOL;
      ret =
	_
	("Defines wether system colors will be set automatically from background colors. This is a time saver to keep map designers from requiring to redefined every single color in the game. You only need to set background-color-base-bg, background-color-base-fg, background-color-alternate-bg and background-color-alternate-fg. Then system_color_bg and system_color_fg will be automatically set.");
    }
  else if (lw6hlp_match (keyword, "background-color-base-bg"))
    {
      (*type) = LW6HLP_TYPE_COLOR;
      ret =
	_
	("Defines the main background color. This is, for instance, the color which will be used to clear the screen before drawing thing. Will be automatically guessed from the map texture if background-color-auto is set. Can be #RGB, #RGBA, #RRGGBB or #RRGGBBAA.");
    }
  else if (lw6hlp_match (keyword, "background-color-base-fg"))
    {
      (*type) = LW6HLP_TYPE_COLOR;
      ret =
	_
	("Defines a color which will be used together with background-color-base-bg to compose the background. It can be wise to have a minimum contrast between this color and background-color-base-bg, but it is not mandatory, especially if other colors are manually redefined. Will be automatically guessed from the map texture if background-color-auto is set. Can be #RGB, #RGBA, #RRGGBB or #RRGGBBAA.");
    }
  else if (lw6hlp_match (keyword, "background-color-alternate-bg"))
    {
      (*type) = LW6HLP_TYPE_COLOR;
      ret =
	_
	("Defines a color which will be used together with background-color-alternate-fg to draw things (animations, sprites, text, whatever) in the background. It should be different enough from background-color-alternate-fg so that one can really distinguish these colors. Will be automatically guessed from the map texture if background-color-auto is set. Can be #RGB, #RGBA, #RRGGBB or #RRGGBBAA.");
    }
  else if (lw6hlp_match (keyword, "background-color-alternate-fg"))
    {
      (*type) = LW6HLP_TYPE_COLOR;
      ret =
	_
	("Defines a color which will be used to draw things (animations, sprites, text, whatever) in the background. It should be different enough from background-color-alternate-bg so that one can really distinguish these colors. Think of this as the sprite, the text, the whatever-needs-to-be-seen-uses-this color. Will be automatically guessed from the map texture if background-color-auto is set. Can be #RGB, #RGBA, #RRGGBB or #RRGGBBAA.");
    }
  else if (lw6hlp_match (keyword, "hud-color-frame-bg"))
    {
      (*type) = LW6HLP_TYPE_COLOR;
      ret =
	_
	("Defines the background color for the hud frame. Ignored if hud-color-auto is set. Can be #RGB, #RGBA, #RRGGBB or #RRGGBBAA.");
    }
  else if (lw6hlp_match (keyword, "hud-color-frame-fg"))
    {
      (*type) = LW6HLP_TYPE_COLOR;
      ret =
	_
	("Defines the foreground color for the hud frame. Ignored if hud-color-auto is set. Can be #RGB, #RGBA, #RRGGBB or #RRGGBBAA.");
    }
  else if (lw6hlp_match (keyword, "hud-color-text-bg"))
    {
      (*type) = LW6HLP_TYPE_COLOR;
      ret =
	_
	("Defines the background color for hud text. Ignored if hud-color-auto is set. Can be #RGB, #RGBA, #RRGGBB or #RRGGBBAA.");
    }
  else if (lw6hlp_match (keyword, "hud-color-text-fg"))
    {
      (*type) = LW6HLP_TYPE_COLOR;
      ret =
	_
	("Defines the foreground color for hud text. Ignored if hud-color-auto is set. Can be #RGB, #RGBA, #RRGGBB or #RRGGBBAA.");
    }
  else if (lw6hlp_match (keyword, "menu-color-default-bg"))
    {
      (*type) = LW6HLP_TYPE_COLOR;
      ret =
	_
	("Defines the default background color for menus. Ignored if menu-color-auto is set. Can be #RGB, #RGBA, #RRGGBB or #RRGGBBAA.");
    }
  else if (lw6hlp_match (keyword, "menu-color-default-fg"))
    {
      (*type) = LW6HLP_TYPE_COLOR;
      ret =
	_
	("Defines the default foreground color for menus. In fact, this is the main color for menu text, the color used to draw letters in menus. Ignored if menu-color-auto is set. Can be #RGB, #RGBA, #RRGGBB or #RRGGBBAA.");
    }
  else if (lw6hlp_match (keyword, "menu-color-selected-bg"))
    {
      (*type) = LW6HLP_TYPE_COLOR;
      ret =
	_
	("Defines the background color for a selected menu item. Ignored if menu-color-auto is set. Can be #RGB, #RGBA, #RRGGBB or #RRGGBBAA.");
    }
  else if (lw6hlp_match (keyword, "menu-color-selected-fg"))
    {
      (*type) = LW6HLP_TYPE_COLOR;
      ret =
	_
	("Defines the foreground color for a selected menu item. Ignored if menu-color-auto is set. Can be #RGB, #RGBA, #RRGGBB or #RRGGBBAA.");
    }
  else if (lw6hlp_match (keyword, "menu-color-disabled-bg"))
    {
      (*type) = LW6HLP_TYPE_COLOR;
      ret =
	_
	("Defines the background color for a disabled menu item. Ignored if menu-color-auto is set. Can be #RGB, #RGBA, #RRGGBB or #RRGGBBAA.");
    }
  else if (lw6hlp_match (keyword, "menu-color-disabled-fg"))
    {
      (*type) = LW6HLP_TYPE_COLOR;
      ret =
	_
	("Defines the foreground color for a disabled menu item. Ignored if menu-color-auto is set. Can be #RGB, #RGBA, #RRGGBB or #RRGGBBAA.");
    }
  else if (lw6hlp_match (keyword, "view-color-cursor-bg"))
    {
      (*type) = LW6HLP_TYPE_COLOR;
      ret =
	_
	("Defines the background cursor color. Will typically be used to draw the shape of the cursor. Ignored if view-color-auto is set. Can be #RGB, #RGBA, #RRGGBB or #RRGGBBAA.");
    }
  else if (lw6hlp_match (keyword, "view-color-cursor-fg"))
    {
      (*type) = LW6HLP_TYPE_COLOR;
      ret =
	_
	("Defines the foreground cursor color. Will typically be used to draw text in the cursor. Ignored if view-color-auto is set. Can be #RGB, #RGBA, #RRGGBB or #RRGGBBAA.");
    }
  else if (lw6hlp_match (keyword, "view-color-map-bg"))
    {
      (*type) = LW6HLP_TYPE_COLOR;
      ret =
	_
	("Defines the background map color. If there's no map texture defined or if use-texture is false, this is the color of the places where armies will go. Ignored if view-color-auto is set. Can be #RGB, #RGBA, #RRGGBB or #RRGGBBAA.");
    }
  else if (lw6hlp_match (keyword, "view-color-map-fg"))
    {
      (*type) = LW6HLP_TYPE_COLOR;
      ret =
	_
	("Defines the foreground map color. If there's no map texture defined or if use-texture is false, this is the color of walls, what armies can't go through. Ignored if view-color-auto is set. Can be #RGB, #RGBA, #RRGGBB or #RRGGBBAA.");
    }
  else if (lw6hlp_match (keyword, "system-color-bg"))
    {
      (*type) = LW6HLP_TYPE_COLOR;
      ret =
	_
	("Defines the system background color, used when displaying system info, such as the number of frames per second. Can be #RGB, #RGBA, #RRGGBB or #RRGGBBAA.");
    }
  else if (lw6hlp_match (keyword, "system-color-fg"))
    {
      (*type) = LW6HLP_TYPE_COLOR;
      ret =
	_
	("Defines the system foreground color, used when displaying system info, such as the number of frames per second. This will typically be text color. Can be #RGB, #RGBA, #RRGGBB or #RRGGBBAA.");
    }
  else if (lw6hlp_match (keyword, "team-color-red"))
    {
      (*type) = LW6HLP_TYPE_COLOR;
      ret =
	_
	("Defines the color for the red team. Syntax is HTML-like, #RGB or #RRGGBB.");
    }
  else if (lw6hlp_match (keyword, "team-color-green"))
    {
      (*type) = LW6HLP_TYPE_COLOR;
      ret =
	_
	("Defines the color for the green team. Syntax is HTML-like, #RGB or #RRGGBB.");
    }
  else if (lw6hlp_match (keyword, "team-color-blue"))
    {
      (*type) = LW6HLP_TYPE_COLOR;
      ret =
	_
	("Defines the color for the blue team. Syntax is HTML-like, #RGB or #RRGGBB.");
    }
  else if (lw6hlp_match (keyword, "team-color-yellow"))
    {
      (*type) = LW6HLP_TYPE_COLOR;
      ret =
	_
	("Defines the color for the yellow team. Syntax is HTML-like, #RGB or #RRGGBB.");
    }
  else if (lw6hlp_match (keyword, "team-color-cyan"))
    {
      (*type) = LW6HLP_TYPE_COLOR;
      ret =
	_
	("Defines the color for the cyan team. Syntax is HTML-like, #RGB or #RRGGBB.");
    }
  else if (lw6hlp_match (keyword, "team-color-magenta"))
    {
      (*type) = LW6HLP_TYPE_COLOR;
      ret =
	_
	("Defines the color for the magenta team. Syntax is HTML-like, #RGB or #RRGGBB.");
    }
  else if (lw6hlp_match (keyword, "team-color-orange"))
    {
      (*type) = LW6HLP_TYPE_COLOR;
      ret =
	_
	("Defines the color for the orange team. Syntax is HTML-like, #RGB or #RRGGBB.");
    }
  else if (lw6hlp_match (keyword, "team-color-lightblue"))
    {
      (*type) = LW6HLP_TYPE_COLOR;
      ret =
	_
	("Defines the color for the light blue team. Syntax is HTML-like, #RGB or #RRGGBB.");
    }
  else if (lw6hlp_match (keyword, "team-color-purple"))
    {
      (*type) = LW6HLP_TYPE_COLOR;
      ret =
	_
	("Defines the color for the purple team. Syntax is HTML-like, #RGB or #RRGGBB.");
    }
  else if (lw6hlp_match (keyword, "team-color-pink"))
    {
      (*type) = LW6HLP_TYPE_COLOR;
      ret =
	_
	("Defines the color for the pink team. Syntax is HTML-like, #RGB or #RRGGBB.");
    }
  /*
   * Aliases
   */
  else if (lw6hlp_match (keyword, "h"))
    {
      (*type) = LW6HLP_TYPE_VOID;
      ret = _("An alias for '--help'.");
    }
  else if (lw6hlp_match (keyword, "?"))
    {
      (*type) = LW6HLP_TYPE_VOID;
      ret = _("An alias for '--help'.");
    }
  else if (lw6hlp_match (keyword, "v"))
    {
      (*type) = LW6HLP_TYPE_VOID;
      ret = _("An alias for '--version'.");
    }
  else if (lw6hlp_match (keyword, "copyleft"))
    {
      (*type) = LW6HLP_TYPE_VOID;
      ret = _("An alias for '--copyright'.");
    }
  else if (lw6hlp_match (keyword, "copy"))
    {
      (*type) = LW6HLP_TYPE_VOID;
      ret = _("An alias for '--copyright'.");
    }
  else if (lw6hlp_match (keyword, "c"))
    {
      (*type) = LW6HLP_TYPE_VOID;
      ret = _("An alias for '--copyright'.");
    }

  return ret;
}

/**
 * lw6hlp_is_documented
 *
 * @keyword: the keyword we want to check out
 *
 * Checks wether a given keyword is documented or not.
 *
 * Return value: 1 if documented, 0 if not.
 */
int
lw6hlp_is_documented (char *keyword)
{
  int ret = 0;

  ret = (about (NULL, keyword) != NULL);

  return ret;
}

/**
 * lw6hlp_about
 *
 * @type: the type of the data associated to the keyword, will be written
 * @keyword: the keyword we want help about
 *
 * Returns the documentation string associated to a keyword. The keyword
 * might be a command-line option, a Guile function, an XML file entry.
 * Raises a warning if the keyword is undocumented, but never returns
 * NULL, you can use the returned value without checking it. String
 * is localized if a translation is available. It's safe to call this
 * function with type being NULL.
 *
 * Return value: a help string, never NULL, must not be freed.
 *   Additionnally, type will be updated.
 */
char *
lw6hlp_about (LW6HLP_TYPE * type, char *keyword)
{
  char *ret = NULL;

  ret = about (type, keyword);

  if (!ret)
    {
      lw6sys_log (LW6SYS_LOG_INFO, _("keyword '%s' is not documented"),
		  keyword);
      if (!lw6hlp_is_listed (keyword))
	{
	  lw6sys_log (LW6SYS_LOG_INFO, _("unknown keyword '%s'"), keyword);
	}
      ret = _(" Not documented.");
    }

  return ret;
}

/**
 * lw6hlp_get_type
 *
 * @keyword: the keyword we want the type of
 *
 * Returns the type of a keyword. Calls lw6hlp_about internally.
 *
 * Return value: the type, might be LW6HLP_TYPE_VOID.
 */
LW6HLP_TYPE
lw6hlp_get_type (char *keyword)
{
  LW6HLP_TYPE ret = LW6HLP_TYPE_VOID;

  lw6hlp_about (&ret, keyword);

  return ret;
}
