/*
  Liquid War 6 is a unique multiplayer wargame.
  Copyright (C)  2005, 2006, 2007, 2008  Christian Mauduit <ufoot@ufoot.org>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.


  Liquid War 6 homepage : http://www.gnu.org/software/liquidwar6/
  Contact author        : ufoot@ufoot.org
*/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <string.h>

#include "ker.h"
#include "ker-internal.h"

int
_lw6ker_bot_init (lw6ker_bot_t * bot, lw6ker_cursor_t * cursor,
		  int32_t rounds)
{
  int ret = 0;

  _lw6ker_bot_clear (bot);

  bot->active = 1;
  bot->pos = cursor->pos;
  bot->rounds_at_end_of_last_move = rounds;

  ret = 1;

  return ret;
}

void
_lw6ker_bot_clear (lw6ker_bot_t * bot)
{
  memset (bot, 0, sizeof (lw6ker_bot_t));
}

void
_lw6ker_bot_update_checksum (lw6ker_bot_t * bot, u_int32_t * checksum)
{
  lw6sys_checksum_update_int32 (checksum, bot->active);
  lw6sys_checksum_update_xy (checksum, &(bot->pos));
  lw6sys_checksum_update_int32 (checksum, bot->rounds_at_end_of_last_move);
  lw6sys_checksum_update_int32 (checksum, bot->moving);
  lw6sys_checksum_update_int32 (checksum, bot->move_nb_steps);
  lw6sys_checksum_update_int32 (checksum, bot->move_current_step);
  lw6sys_checksum_update_xy (checksum, &(bot->move_pos_from));
  lw6sys_checksum_update_xy (checksum, &(bot->move_pos_to));
}

static void
find_new_pos (lw6sys_xy_t * pos, lw6ker_game_state_t * game_state)
{
  /*
   * Todo: code something a little better than this, for this is
   * purely absolutely nuts. Good for debugging only.
   */
  pos->x =
    lw6sys_checksum_int32 (game_state->moves) %
    (lw6sys_max (1, game_state->map_state.shape.w - 2));
  pos->y =
    lw6sys_checksum_int32 (game_state->rounds) %
    (lw6sys_max (1, game_state->map_state.shape.h - 2));
}

/*
 * This is the main bot function that positions a bot
 * at the right place. Used to be somewhat complicated in LW5,
 * but very basic here.
 */
void
_lw6ker_bot_update_pos (lw6ker_bot_t * bot, lw6ker_game_state_t * game_state)
{
  int32_t weight_from;
  int32_t weight_to;

  if (bot->active)
    {
      if (bot->moving)
	{
	  bot->move_current_step++;
	  if (bot->move_current_step >= bot->move_nb_steps)
	    {
	      bot->pos = bot->move_pos_to;
	      bot->moving = 0;
	      bot->rounds_at_end_of_last_move = game_state->rounds;
	    }
	  else
	    {
	      weight_from = bot->move_nb_steps - bot->move_current_step;
	      weight_to = bot->move_current_step;
	      bot->pos.x =
		(bot->move_pos_from.x * weight_from +
		 bot->move_pos_to.x * weight_to) / bot->move_nb_steps;
	      bot->pos.y =
		(bot->move_pos_from.y * weight_from +
		 bot->move_pos_to.y * weight_to) / bot->move_nb_steps;
	    }
	}
      else
	{
	  if (bot->rounds_at_end_of_last_move +
	      game_state->game_struct->options.bot_wait_between_moves <
	      game_state->rounds)
	    {
	      bot->moving = 1;
	      bot->move_current_step = 0;
	      bot->move_pos_from = bot->pos;
	      find_new_pos (&(bot->move_pos_to), game_state);
	      bot->move_nb_steps =
		game_state->game_struct->options.bot_nb_move_steps;
	      bot->move_current_step = 0;
	    }
	  else
	    {
	      // do nothing, just wait here hoping to crunch opponent
	    }
	}
    }
}
