/*
  Liquid War 6 is a unique multiplayer wargame.
  Copyright (C)  2005, 2006, 2007, 2008  Christian Mauduit <ufoot@ufoot.org>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.


  Liquid War 6 homepage : http://www.gnu.org/software/liquidwar6/
  Contact author        : ufoot@ufoot.org
*/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <string.h>

#include "ker.h"
#include "ker-internal.h"

void
lw6ker_cursor_array_clear (lw6ker_cursor_array_t * cursor_array)
{
  memset (cursor_array, 0, sizeof (lw6ker_cursor_array_t));
}

int
lw6ker_cursor_array_add (lw6ker_cursor_array_t * cursor_array,
			 lw6ker_cursor_t * cursor)
{
  int ret = 0;

  if (cursor_array->nb_cursors < LW6MAP_MAX_CURSORS_PER_TEAM)
    {
      cursor_array->cursors[cursor_array->nb_cursors] = *cursor;
      cursor_array->nb_cursors++;
      ret = 1;
    }
  else
    {
      lw6sys_log (LW6SYS_LOG_WARNING,
		  _("can't add cursor, already %d cursors in cursor_array"),
		  cursor_array->nb_cursors);
    }

  return ret;
}

int
lw6ker_cursor_array_set (lw6ker_cursor_array_t * cursor_array, int32_t i,
			 int32_t x, int32_t y,
			 int32_t pot_offset,
			 lw6ker_map_struct_t * map_struct,
			 int32_t max_cursor_pot_offset)
{
  int ret = 0;

  if (i >= 0 && i < LW6MAP_MAX_CURSORS_PER_TEAM)
    {
      if (i >= cursor_array->nb_cursors)
	{
	  lw6ker_cursor_array_force_nb_cursors (cursor_array, i + 1);
	}
      ret =
	lw6ker_cursor_set (&(cursor_array->cursors[i]), x, y, pot_offset,
			   map_struct, max_cursor_pot_offset);
    }

  return ret;
}

extern int
lw6ker_cursor_array_force_nb_cursors (lw6ker_cursor_array_t * cursor_array,
				      int32_t nb_cursors)
{
  int ret = 0;
  int32_t i;

  if (nb_cursors >= 0 && nb_cursors < LW6MAP_MAX_CURSORS_PER_TEAM)
    {
      if (nb_cursors > cursor_array->nb_cursors)
	{
	  for (i = cursor_array->nb_cursors; i < nb_cursors; ++i)
	    {
	      lw6ker_cursor_clear (&(cursor_array->cursors[i]));
	    }
	}
      cursor_array->nb_cursors = nb_cursors;
      ret = 1;
    }

  return ret;
}

void
_lw6ker_cursor_array_update_checksum (lw6ker_cursor_array_t * cursor_array,
				      u_int32_t * checksum)
{
  int32_t i;

  for (i = 0; i < cursor_array->nb_cursors; ++i)
    {
      _lw6ker_cursor_update_checksum (&(cursor_array->cursors[i]), checksum);
    }
}

void
_lw6ker_cursor_array_activate (lw6ker_cursor_array_t * cursor_array,
			       int32_t nb_cursors, lw6sys_xy_t pos)
{
  int32_t i;

  if (nb_cursors >= 0 && nb_cursors < LW6MAP_MAX_CURSORS_PER_TEAM)
    {
      cursor_array->nb_cursors = nb_cursors;
      for (i = 0; i < cursor_array->nb_cursors; ++i)
	{
	  _lw6ker_cursor_init (&(cursor_array->cursors[i]), pos);
	}
    }
  else
    {
      lw6sys_log (LW6SYS_LOG_WARNING,
		  _
		  ("unable to activate cursor_array, uncorrect cursor number (%d)"),
		  nb_cursors);
    }
}
