/*
  Liquid War 6 is a unique multiplayer wargame.
  Copyright (C)  2005, 2006, 2007, 2008  Christian Mauduit <ufoot@ufoot.org>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.


  Liquid War 6 homepage : http://www.gnu.org/software/liquidwar6/
  Contact author        : ufoot@ufoot.org
*/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "ker.h"
#include "ker-internal.h"

/*
 * This is used to stamp game_structs as they are created.
 * Note that there's no race condition due to the fact that this
 * is global here, in fact even when 2 processes would share
 * this sequence id, it would not matter for they would then
 * try and identify the objects in their on per-process lists,
 * structures, Guile object, whatever they use.
 */
static int seq_id = 0;

lw6ker_game_struct_t *
lw6ker_game_struct_new (lw6map_level_t * level)
{
  lw6ker_game_struct_t *ret = NULL;

  ret =
    (lw6ker_game_struct_t *) LW6SYS_CALLOC (sizeof (lw6ker_game_struct_t));

  if (ret)
    {
      ret->id = ++seq_id;
      ret->level = level;
      lw6map_options_copy (&(ret->options), &(level->param.options));
      _lw6ker_map_struct_init (&(ret->map_struct), level);
    }

  return ret;
}

void
lw6ker_game_struct_free (lw6ker_game_struct_t * game_struct)
{
  _lw6ker_map_struct_clear (&(game_struct->map_struct));
  LW6SYS_FREE (game_struct);
}

int
lw6ker_game_struct_memory_footprint (lw6ker_game_struct_t * game_struct)
{
  int ret = 0;

  // todo

  return ret;
}

char *
lw6ker_game_struct_repr (lw6ker_game_struct_t * game_struct)
{
  char *ret = NULL;

  if (game_struct)
    {
      ret =
	lw6sys_new_sprintf ("%d (%dx%d)", game_struct->id,
			    game_struct->map_struct.shape.w,
			    game_struct->map_struct.shape.h);
    }
  else
    {
      lw6sys_log (LW6SYS_LOG_WARNING, "game_struct",
		  _("can't generate string id for NULL game_struct"));
    }

  return ret;
}

void
_lw6ker_game_struct_update_checksum (lw6ker_game_struct_t *
				     game_struct, u_int32_t * checksum)
{
  _lw6ker_map_struct_update_checksum (&(game_struct->map_struct), checksum);
  lw6map_options_update_checksum (&(game_struct->options), checksum);
}

u_int32_t
lw6ker_game_struct_checksum (lw6ker_game_struct_t * game_struct)
{
  u_int32_t ret = 0;

  _lw6ker_game_struct_update_checksum (game_struct, &ret);

  return ret;
}
