/*
  Liquid War 6 is a unique multiplayer wargame.
  Copyright (C)  2005, 2006, 2007, 2008  Christian Mauduit <ufoot@ufoot.org>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.


  Liquid War 6 homepage : http://www.gnu.org/software/liquidwar6/
  Contact author        : ufoot@ufoot.org
*/

#ifndef LIQUIDWAR6LDR_INTERNAL_H
#define LIQUIDWAR6LDR_INTERNAL_H

#define _LW6LDR_FILE_README "README"
#define _LW6LDR_FILE_README_TXT "README.txt"
#define _LW6LDR_FILE_MAP_PNG "map.png"
#define _LW6LDR_FILE_TEXTURE_PNG "texture.png"
#define _LW6LDR_FILE_TEXTURE_JPEG "texture.jpeg"
#define _LW6LDR_FILE_TEXTURE_JPG "texture.jpg"
#define _LW6LDR_FILE_TEXTURE_ALPHA_JPEG "texture-alpha.jpeg"
#define _LW6LDR_FILE_TEXTURE_ALPHA_JPG "texture-alpha.jpg"

#define _LW6LDR_FILE_OPTIONS_XML "options.xml"
#define _LW6LDR_FILE_STYLE_XML "style.xml"

typedef struct _lw6ldr_image_bw_s
{
  lw6sys_wh_t shape;
  unsigned char **data;
  int step;
}
_lw6ldr_image_bw_t;

typedef struct _lw6ldr_image_rgba_s
{
  lw6sys_wh_t shape;
  unsigned char **data;
}
_lw6ldr_image_rgba_t;


/*
 * In bw.c
 */
extern int _lw6ldr_bw_read (_lw6ldr_image_bw_t * image, char *png_file);
extern void _lw6ldr_bw_clear (_lw6ldr_image_bw_t * image);

/*
 * In color.c
 */
extern int _lw6ldr_guess_colors (lw6map_level_t * level);
extern void _lw6ldr_auto_background (lw6map_level_t * level);

/*
 * In rgba.c
 */
extern int _lw6ldr_rgba_read_png (_lw6ldr_image_rgba_t * image,
				  char *png_file);
extern int _lw6ldr_rgba_read_jpeg (_lw6ldr_image_rgba_t * image,
				   char *jpeg_file);
extern void _lw6ldr_rgba_clear (_lw6ldr_image_rgba_t * image);

#endif
