/*
  Liquid War 6 is a unique multiplayer wargame.
  Copyright (C)  2005, 2006, 2007, 2008  Christian Mauduit <ufoot@ufoot.org>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.
  

  Liquid War 6 homepage : http://www.gnu.org/software/liquidwar6/
  Contact author        : ufoot@ufoot.org
*/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <string.h>

#include "ldr.h"

#define TEST_MAP "strange-new-world/"
#define TEST_ARGC 2
#define TEST_ARGV0 "prog"
#define TEST_ARGV1 "--arg=X"
#define TEST_DIR_RELATIVE_PATH ""
#define TEST_PARAM_KEY1 "total-time"
#define TEST_PARAM_VALUE1 "180"
#define TEST_PARAM_KEY2 "background-style"
#define TEST_PARAM_VALUE2 "fire"
#define TEST_PARAM_KEY3 "zoom"
#define TEST_PARAM_VALUE3 "1.0"
#define TEST_DISPLAY_WIDTH 640
#define TEST_DISPLAY_HEIGHT 480

/*
 * Testing dirs/entries
 */
static int
test_dir ()
{
  int ret = 1;
  LW6SYS_TEST_FUNCTION_BEGIN;
  int argc = TEST_ARGC;
  char *argv[TEST_ARGC] = { TEST_ARGV0, TEST_ARGV1 };

  {
    lw6sys_list_t *entries = NULL;
    char *map_path = NULL;
    lw6ldr_entry_t *entry = NULL;
    int entry_found = 0;

    map_path = lw6cfg_unified_get_map_path (argc, argv);
    if (map_path)
      {
	entries = lw6ldr_get_entries (map_path, TEST_DIR_RELATIVE_PATH);
	if (entries)
	  {
	    while (entries && (entry = lw6sys_lifo_pop (&entries)) != NULL)
	      {
		lw6sys_log (LW6SYS_LOG_NOTICE,
			    _("found map \"%s\" in \"%s\""), entry->title,
			    entry->absolute_path);
		entry_found = 1;
		lw6ldr_free_entry (entry);
	      };
	  }
	else
	  {
	    ret = 0;
	  }
	LW6SYS_FREE (map_path);
      }
    else
      {
	ret = 0;
      }
    if (!entry_found)
      {
	ret = 0;
      }
  }

  LW6SYS_TEST_FUNCTION_END;
  return ret;
}

/*
 * Testing param
 */
static int
test_param ()
{
  int ret = 1;
  LW6SYS_TEST_FUNCTION_BEGIN;

  {
    lw6map_param_t param;
    lw6sys_assoc_t *values = NULL;

    memset (&param, 0, sizeof (lw6map_param_t));
    lw6map_param_defaults (&param);

    values = lw6sys_assoc_new (NULL);
    if (values)
      {
	lw6sys_assoc_set (&values, TEST_PARAM_KEY1, TEST_PARAM_VALUE1);
	lw6sys_assoc_set (&values, TEST_PARAM_KEY2, TEST_PARAM_VALUE2);
	lw6sys_assoc_set (&values, TEST_PARAM_KEY3, TEST_PARAM_VALUE3);

	if (lw6ldr_param_update (&param, values))
	  {
	    ret = 1;
	  }

	lw6sys_assoc_free (values);
      }
    else
      {
	ret = 0;
      }

    lw6map_param_clear (&param);

  }

  LW6SYS_TEST_FUNCTION_END;
  return ret;
}

/*
 * Testing reading
 */
static int
test_read ()
{
  int ret = 1;
  LW6SYS_TEST_FUNCTION_BEGIN;
  int argc = TEST_ARGC;
  char *argv[TEST_ARGC] = { TEST_ARGV0, TEST_ARGV1 };

  {
    lw6map_level_t *level = NULL;
    char *repr = NULL;
    char *map_path = NULL;
    lw6sys_wh_t display_shape = { TEST_DISPLAY_WIDTH, TEST_DISPLAY_HEIGHT };

    map_path = lw6cfg_unified_get_map_path (argc, argv);
    if (map_path)
      {
	level =
	  lw6ldr_read_relative (map_path, TEST_MAP, NULL, NULL,
				&display_shape);
	if (level)
	  {
	    repr = lw6map_repr (level);
	    if (repr)
	      {
		lw6sys_log (LW6SYS_LOG_NOTICE,
			    _("after reading, map repr is \"%s\""), repr);
		LW6SYS_FREE (repr);
	      }
	    else
	      {
		ret = 0;
	      }
	    lw6map_free (level);
	  }
	else
	  {
	    ret = 0;
	  }

	LW6SYS_FREE (map_path);
      }
    else
      {
	ret = 0;
      }
  }

  LW6SYS_TEST_FUNCTION_END;
  return ret;
}

int
lw6ldr_test ()
{
  int ret = 0;

  if (lw6sys_false ())
    {
      /*
       * Just to make sure most functions are stuffed in the binary
       */
      lw6sys_test ();
      lw6hlp_test ();
      lw6cfg_test ();
      lw6map_test ();
    }

  ret = test_dir () && test_param () && test_read ();

  return ret;
}
