/*
  Liquid War 6 is a unique multiplayer wargame.
  Copyright (C)  2005, 2006, 2007, 2008  Christian Mauduit <ufoot@ufoot.org>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.
  

  Liquid War 6 homepage : http://www.gnu.org/software/liquidwar6/
  Contact author        : ufoot@ufoot.org
*/

#ifndef LIQUIDWAR6TSK_INTERNAL_H
#define LIQUIDWAR6TSK_INTERNAL_H

#include "tsk.h"

typedef struct _lw6tsk_loader_stage1_s
{
  char *map_path;
  char *relative_path;
  lw6sys_assoc_t *default_param;
  lw6sys_assoc_t *forced_param;
  lw6sys_wh_t display_shape;
  lw6map_level_t *level;
}
_lw6tsk_loader_stage1_t;

typedef struct _lw6tsk_loader_stage2_s
{
  lw6map_level_t *level;
  lw6ker_game_struct_t *game_struct;
}
_lw6tsk_loader_stage2_t;

typedef struct _lw6tsk_loader_stage3_s
{
  lw6map_level_t *level;
  lw6ker_game_struct_t *game_struct;
  lw6ker_game_state_t *game_state;
}
_lw6tsk_loader_stage3_t;

typedef struct _lw6tsk_loader_data_s
{
  int stop;
  float sleep;
  void *mutex;
  int stage;
  int request_number;
  _lw6tsk_loader_stage1_t stage1;
  _lw6tsk_loader_stage2_t stage2;
  _lw6tsk_loader_stage3_t stage3;
}
_lw6tsk_loader_data_t;

#endif
