/*
  Liquid War 6 is a unique multiplayer wargame.
  Copyright (C)  2005, 2006, 2007, 2008  Christian Mauduit <ufoot@ufoot.org>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.
  

  Liquid War 6 homepage : http://www.gnu.org/software/liquidwar6/
  Contact author        : ufoot@ufoot.org
*/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "../bot.h"
#include "mod-idiot-internal.h"

static int
new_target (_mod_idiot_context_t * idiot_context)
{
  int team_color = LW6MAP_TEAM_COLOR_INVALID;
  int x = -1;
  int y = -1;
  int ret = 0;
  int i = 0;
  int found = 0;
  int fighter_id;
  lw6ker_fighter_t *fighter;

  if (lw6ker_game_state_get_cursor_info
      (idiot_context->param.game_state, idiot_context->param.cursor_id, NULL,
       NULL, &team_color, &x, &y))
    {
      idiot_context->start_pos.x = x;
      idiot_context->start_pos.y = y;

      for (i = 0; i < _MOD_IDIOT_NB_RETRIES && !found; ++i)
	{
	  x =
	    lw6sys_random (idiot_context->param.game_state->map_state.
			   shape.w);
	  y =
	    lw6sys_random (idiot_context->param.game_state->map_state.
			   shape.h);
	  idiot_context->target_pos.x = x;
	  idiot_context->target_pos.y = y;
	  if (idiot_context->param.iq >= _MOD_IDIOT_IQ_LIMIT1
	      && idiot_context->param.iq < _MOD_IDIOT_IQ_LIMIT2)
	    {
	      // here, we don't search anymore, just choose random
	      found = 1;
	    }
	  else
	    {
	      fighter_id =
		lw6ker_map_state_get_fighter_id (&
						 (idiot_context->
						  param.game_state->
						  map_state), 0, x, y);
	      if (fighter_id >= 0)
		{
		  fighter =
		    &(idiot_context->param.game_state->map_state.
		      armies.fighters[fighter_id]);
		  if (fighter != NULL)
		    if (idiot_context->param.iq >= _MOD_IDIOT_IQ_LIMIT2
			&& fighter->team_color != team_color)
		      {
			// default behavior, find an opponent
			lw6sys_log (LW6SYS_LOG_DEBUG,
				    _
				    ("idiot bot acting normally, choosed opponent of color %d at %d,%d"),
				    fighter->team_color, x, y);
			found = 1;
		      }
		  if (idiot_context->param.iq < _MOD_IDIOT_IQ_LIMIT1
		      && fighter->team_color == team_color)
		    {
		      // acting stupid, centering on self
		      lw6sys_log (LW6SYS_LOG_DEBUG,
				  _
				  ("idiot bot acting stupid, choosed self color %d at %d,%d"),
				  fighter->team_color, x, y);
		      found = 1;
		    }
		}
	    }
	}

      lw6sys_log (LW6SYS_LOG_DEBUG,
		  _("idiot bot moved start=%d,%d target=%d,%d"),
		  idiot_context->start_pos.x, idiot_context->start_pos.y,
		  idiot_context->target_pos.x, idiot_context->target_pos.y);

      ret = found;
    }

  return ret;
}

int
_mod_idiot_next_move (_mod_idiot_context_t * idiot_context, int *x, int *y)
{
  int ret = 0;
  int rounds = 0;
  int d_move;
  int d_wait;
  int dt = 0;
  int start_of_move;
  int end_of_move;
  int end_of_wait;

  rounds = lw6ker_game_state_get_rounds (idiot_context->param.game_state);
  lw6sys_log (LW6SYS_LOG_DEBUG, _("idiot bot move rounds=%d"), rounds);

  d_move =
    lw6sys_max (1,
		(float) _MOD_IDIOT_DEFAULT_MOVE_ROUNDS /
		idiot_context->param.speed);
  d_wait =
    lw6sys_max (1,
		(float) _MOD_IDIOT_DEFAULT_WAIT_ROUNDS /
		idiot_context->param.speed);
  if (idiot_context->last_move_round < 0
      || (rounds >= idiot_context->last_move_round + d_move + d_wait))
    {
      new_target (idiot_context);
      if (idiot_context->last_move_round >= 0)
	{
	  idiot_context->last_move_round += d_move + d_wait;
	}
      else
	{
	  idiot_context->last_move_round = 0;
	}
    }

  start_of_move = idiot_context->last_move_round;
  end_of_move = start_of_move + d_move;
  end_of_wait = end_of_move + d_wait;

  if (rounds > start_of_move && rounds < end_of_move)
    {
      dt = lw6sys_max (1, end_of_move - start_of_move);
      (*x) =
	((end_of_move - rounds) * idiot_context->start_pos.x +
	 (rounds - start_of_move) * idiot_context->target_pos.x) / dt;
      (*y) =
	((end_of_move - rounds) * idiot_context->start_pos.y +
	 (rounds - start_of_move) * idiot_context->target_pos.y) / dt;
    }
  else if (rounds >= end_of_move)
    {
      (*x) = idiot_context->target_pos.x;
      (*y) = idiot_context->target_pos.y;
    }
  else
    {
      (*x) = idiot_context->start_pos.x;
      (*y) = idiot_context->start_pos.y;
    }

  ret = 1;

  return ret;
}
