/*
  Liquid War 6 is a unique multiplayer wargame.
  Copyright (C)  2005, 2006, 2007, 2008  Christian Mauduit <ufoot@ufoot.org>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.


  Liquid War 6 homepage : http://www.gnu.org/software/liquidwar6/
  Contact author        : ufoot@ufoot.org
*/

#ifndef LIQUIDWAR6GFX_H
#define LIQUIDWAR6GFX_H

#include "../sys/sys.h"
#include "../dyn/dyn.h"
#include "../map/map.h"
#include "../ker/ker.h"
#include "../hlp/hlp.h"
#include "../cfg/cfg.h"
#include "../ldr/ldr.h"
#include "../gui/gui.h"

typedef struct lw6gfx_backend_s
{
  lw6dyn_dl_handle_t *dl_handle;
  void *gfx_context;
  int argc;
  char **argv;
  u_int32_t id;

  void (*display_background) (void *gfx_context, lw6gui_look_t * look);
  void (*display_hud) (void *gfx_context, lw6gui_look_t * look,
		       lw6ker_game_state_t * game_state);
  int (*poll_key) (void *gfx_context, lw6gui_keypress_t * keypress);
  int (*is_key_esc) (void *gfx_context, int keysym);
  int (*is_key_enter) (void *gfx_context, int keysym);
  int (*is_key_up) (void *gfx_context, int keysym);
  int (*is_key_down) (void *gfx_context, int keysym);
  int (*is_key_left) (void *gfx_context, int keysym);
  int (*is_key_right) (void *gfx_context, int keysym);
  int (*poll_quit) (void *gfx_context);
  void (*send_quit) (void *gfx_context);
  void (*get_default_keys_state) (void *gfx_context, int *up, int *down,
				  int *left, int *right, int *esc,
				  int *enter);
  int (*get_key_state) (void *gfx_context, int keysym);
  int (*poll_mouse_move) (void *gfx_context, int *x, int *y);
  int (*poll_mouse_button_left) (void *gfx_context);
  int (*poll_mouse_button_right) (void *gfx_context);
  int (*poll_mouse_wheel_up) (void *gfx_context);
  int (*poll_mouse_wheel_down) (void *gfx_context);
  void (*get_mouse_state) (void *gfx_context, int *x, int *y,
			   int *button_left, int *button_right);
  int (*warp_mouse) (void *gfx_context, int x, int y);
  void (*show_mouse) (void *gfx_context, int state);
  int (*poll_joystick_up) (void *gfx_context, int i);
  int (*poll_joystick_down) (void *gfx_context, int i);
  int (*poll_joystick_left) (void *gfx_context, int i);
  int (*poll_joystick_right) (void *gfx_context, int i);
  int (*poll_joystick_button) (void *gfx_context, int i, int b);
  void (*get_joystick_state) (void *gfx_context, int *x, int *y,
			      int *button_a, int *button_b, int i, int b1,
			      int b2);
  void (*display_log) (void *gfx_context, lw6gui_look_t * look,
		       char **log_list);
  void (*display_fps) (void *gfx_context, lw6gui_look_t * look, int fps);
  void (*display_map_preview) (void *gfx_context, lw6gui_look_t * look,
			       lw6map_level_t * level);
  void (*display_map_zones) (void *gfx_context, lw6gui_look_t * look,
			     lw6ker_game_struct_t * game_struct);
  void (*display_map_gradient) (void *gfx_context, lw6gui_look_t * look,
				lw6ker_game_state_t * game_state,
				int team_id);
  void (*display_game) (void *gfx_context, lw6gui_look_t * look,
			lw6ker_game_state_t * game_state);
  void (*display_cursors) (void *gfx_context, lw6gui_look_t * look,
			   lw6ker_game_state_t * game_state);
  void (*display_menu) (void *gfx_context, lw6gui_look_t * look,
			lw6gui_menu_t * menu, float progress);
  void (*pick_menuitem) (void *gfx_context, lw6gui_look_t * look,
			 int *position, int *scroll, lw6gui_menu_t * menu,
			 int screen_x, int screen_y);
  int (*warp_mouse_on_menuitem) (void *gfx_context, lw6gui_look_t * look,
				 lw6gui_menu_t * menu, int position);
  void (*center_menu) (void *gfx_context, lw6gui_look_t * look,
		       lw6gui_menu_t * menu, int position);
  void (*prepare_buffer) (void *gfx_context, lw6gui_look_t * look);
  void (*swap_buffers) (void *gfx_context);
  void *(*init) (int argc, char *argv[], int width, int height,
		 int fullscreen, void (*resize_callback) (int width,
							  int height,
							  int fullscreen),
		 int ticks, int key_repeat_delay, int key_repeat_interval);
  int (*set_key_repeat) (void *gfx_context, int key_repeat_delay,
			 int key_repeat_interval);
  void (*get_low_resolution) (void *gfx_context, int *width, int *height);
  void (*get_standard_resolution) (void *gfx_context, int *width,
				   int *height);
  void (*get_high_resolution) (void *gfx_context, int *width, int *height);
  int (*set_video_mode) (void *gfx_context, int width, int height,
			 int fullscreen, void (*resize_callback) (int width,
								  int height,
								  int
								  fullscreen));
  int (*get_video_mode) (void *gfx_context, int *width, int *height,
			 int *fullscreen);
  void (*quit) (void *gfx_context);
  void (*delay) (void *gfx_context, int ms);
  int (*get_ticks) (void *gfx_context);
}
lw6gfx_backend_t;

/*
 * In api.c
 */
extern void lw6gfx_display_background (lw6gfx_backend_t * backend,
				       lw6gui_look_t * look);
extern void lw6gfx_prepare_hud (lw6gfx_backend_t * backend,
				lw6gui_look_t * look);
extern void lw6gfx_display_hud (lw6gfx_backend_t * backend,
				lw6gui_look_t * look,
				lw6ker_game_state_t * game_state);
extern int lw6gfx_poll_key (lw6gfx_backend_t * backend,
			    lw6gui_keypress_t * keypress);
extern int lw6gfx_is_key_esc (lw6gfx_backend_t * backend, int keysym);
extern int lw6gfx_is_key_enter (lw6gfx_backend_t * backend, int keysym);
extern int lw6gfx_is_key_up (lw6gfx_backend_t * backend, int keysym);
extern int lw6gfx_is_key_down (lw6gfx_backend_t * backend, int keysym);
extern int lw6gfx_is_key_left (lw6gfx_backend_t * backend, int keysym);
extern int lw6gfx_is_key_right (lw6gfx_backend_t * backend, int keysym);
extern int lw6gfx_poll_quit (lw6gfx_backend_t * backend);
extern void lw6gfx_send_quit (lw6gfx_backend_t * backend);
extern void lw6gfx_get_default_keys_state (lw6gfx_backend_t * backend,
					   int *up, int *down, int *left,
					   int *right, int *esc, int *enter);
extern int lw6gfx_get_key_state (lw6gfx_backend_t * backend, int keysym);
extern int lw6gfx_poll_mouse_move (lw6gfx_backend_t * backend, int *x,
				   int *y);
extern int lw6gfx_poll_mouse_button_left (lw6gfx_backend_t * backend);
extern int lw6gfx_poll_mouse_button_right (lw6gfx_backend_t * backend);
extern int lw6gfx_poll_mouse_wheel_up (lw6gfx_backend_t * backend);
extern int lw6gfx_poll_mouse_wheel_down (lw6gfx_backend_t * backend);
extern void lw6gfx_get_mouse_state (lw6gfx_backend_t * backend, int *x,
				    int *y, int *button_left,
				    int *button_right);
extern int lw6gfx_warp_mouse (lw6gfx_backend_t * backend, int x, int y);
extern void lw6gfx_show_mouse (lw6gfx_backend_t * backend, int state);
extern int lw6gfx_poll_joystick_up (lw6gfx_backend_t * backend, int i);
extern int lw6gfx_poll_joystick_down (lw6gfx_backend_t * backend, int i);
extern int lw6gfx_poll_joystick_left (lw6gfx_backend_t * backend, int i);
extern int lw6gfx_poll_joystick_right (lw6gfx_backend_t * backend, int i);
extern int lw6gfx_poll_joystick_button (lw6gfx_backend_t * backend, int i,
					int b);
extern void lw6gfx_get_joystick_state (lw6gfx_backend_t * backend, int *x,
				       int *y, int *button_a, int *button_b,
				       int i, int b1, int b2);
extern void lw6gfx_display_log (lw6gfx_backend_t * backend,
				lw6gui_look_t * look, char **log_list);
extern void lw6gfx_display_fps (lw6gfx_backend_t * backend,
				lw6gui_look_t * look, int fps);
extern void lw6gfx_display_map_preview (lw6gfx_backend_t * backend,
					lw6gui_look_t * look,
					lw6map_level_t * level);
extern void lw6gfx_display_map_zones (lw6gfx_backend_t * backend,
				      lw6gui_look_t * look,
				      lw6ker_game_struct_t * game_struct);
extern void lw6gfx_display_map_gradient (lw6gfx_backend_t * backend,
					 lw6gui_look_t * look,
					 lw6ker_game_state_t * game_state,
					 int team_id);
extern void lw6gfx_display_game (lw6gfx_backend_t * backend,
				 lw6gui_look_t * look,
				 lw6ker_game_state_t * game_state);
extern void lw6gfx_display_cursors (lw6gfx_backend_t * backend,
				    lw6gui_look_t * look,
				    lw6ker_game_state_t * game_state);
extern void lw6gfx_display_menu (lw6gfx_backend_t * backend,
				 lw6gui_look_t * look, lw6gui_menu_t * menu,
				 float progress);
extern void lw6gfx_pick_menuitem (lw6gfx_backend_t * backend,
				  lw6gui_look_t * look, int *position,
				  int *scroll, lw6gui_menu_t * menu,
				  int screen_x, int screen_y);
extern int lw6gfx_warp_mouse_on_menuitem (lw6gfx_backend_t * backend,
					  lw6gui_look_t * look,
					  lw6gui_menu_t * menu, int position);
extern void lw6gfx_center_menu (lw6gfx_backend_t * backend,
				lw6gui_look_t * look, lw6gui_menu_t * menu,
				int position);
extern void lw6gfx_prepare_buffer (lw6gfx_backend_t * backend,
				   lw6gui_look_t * look);
extern void lw6gfx_swap_buffers (lw6gfx_backend_t * backend);
extern int lw6gfx_init (lw6gfx_backend_t * backend, int width,
			int height, int fullscreen,
			void (*resize_callback) (int width,
						 int height, int fullscreen),
			int ticks, int key_repeat_delay,
			int key_repeat_interval);
extern int lw6gfx_set_key_repeat (lw6gfx_backend_t * backend,
				  int key_repeat_delay,
				  int key_repeat_interval);
extern void lw6gfx_get_low_resolution (lw6gfx_backend_t * backend, int *width,
				       int *height);
extern void lw6gfx_get_standard_resolution (lw6gfx_backend_t * backend,
					    int *width, int *height);
extern void lw6gfx_get_high_resolution (lw6gfx_backend_t * backend,
					int *width, int *height);
extern int lw6gfx_set_video_mode (lw6gfx_backend_t * backend, int width,
				  int height, int fullscreen,
				  void (*resize_callback) (int width,
							   int height,
							   int fullscreen));
extern int lw6gfx_get_video_mode (lw6gfx_backend_t * backend, int *width,
				  int *height, int *fullscreen);
extern void lw6gfx_quit (lw6gfx_backend_t * backend);
extern void lw6gfx_delay (lw6gfx_backend_t * backend, int ms);
extern int lw6gfx_get_ticks (lw6gfx_backend_t * backend);

/*
 * In register.c
 */
extern lw6sys_assoc_t *lw6gfx_get_backends (int argc, char *argv[]);
extern lw6gfx_backend_t *lw6gfx_create_backend (int argc, char *argv[],
						char *name);
extern void lw6gfx_destroy_backend (lw6gfx_backend_t * backend);

/*
 * In test.c
 */
extern int lw6gfx_test ();

#endif
