/*
  Liquid War 6 is a unique multiplayer wargame.
  Copyright (C)  2005, 2006, 2007, 2008  Christian Mauduit <ufoot@ufoot.org>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.
  

  Liquid War 6 homepage : http://www.gnu.org/software/liquidwar6/
  Contact author        : ufoot@ufoot.org
*/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <math.h>

#include "../../mod-gl.h"
#include "gl-cylinder-internal.h"

float
_mod_gl_menu_cylinder_get_cylinder_y (mod_gl_utils_context_t * utils_context,
				      _mod_gl_menu_cylinder_context_t *
				      cylinder_context, int i, int n)
{
  float y;

  y = -cylinder_context->const_data.between1 * (i - (n - 1) / 2.0f) / n;

  return y;
}

/*
 * Display a horizontal  cylinder.
 */
void
_mod_gl_menu_cylinder_draw_cylinder (mod_gl_utils_context_t * utils_context,
				     _mod_gl_menu_cylinder_context_t *
				     cylinder_context, GLenum mode, int i,
				     int n, float ratio)
{
  GLUquadricObj *cyl;

  cyl = gluNewQuadric ();
  if (cyl != NULL)
    {
      float radius;
      float cyl_height;
      int slices;
      float y;
      float dy;

      if (mode == GL_RENDER)
	{
	  gluQuadricTexture (cyl, GL_TRUE);
	}

      radius = cylinder_context->const_data.radius1 / n;
      cyl_height =
	cylinder_context->const_data.cyl_height *
	((float) utils_context->screen.width) /
	((float) utils_context->screen.height);
      y =
	_mod_gl_menu_cylinder_get_cylinder_y (utils_context, cylinder_context,
					      i, n);
      dy =
	(cylinder_context->const_data.oscil_range1 / n) * sin (2.0f * M_PI *
							       (((((float)
								   mod_gl_utils_get_ticks
								   (utils_context)))
								 /
								 ((float)
								  cylinder_context->const_data.oscil_period))
								+
								(((float) i) /
								 ((float)
								  n))));
      slices = cylinder_context->const_data.slices1 / n;
      if (slices < cylinder_context->const_data.slices_min)
	{
	  slices = cylinder_context->const_data.slices_min;
	}

      glMatrixMode (GL_MODELVIEW);
      glPushMatrix ();
      glLoadIdentity ();
      glTranslatef (-cyl_height / 2.0f, 0.0f, -1.0f);
      glRotatef (90.0f, 0.0f, 1.0f, 0.0f);
      glTranslatef (0.0f, y + dy, 0.0f);

      gluCylinder (cyl, radius, radius, cyl_height, slices,
		   cylinder_context->const_data.stacks);

      glMatrixMode (GL_MODELVIEW);
      glPopMatrix ();

      gluDeleteQuadric (cyl);
    }
  else
    {
      lw6sys_log (LW6SYS_LOG_WARNING, _("unable to create quadric"));
    }
}

void
_mod_gl_menu_cylinder_draw_sphere (mod_gl_utils_context_t * utils_context,
				   _mod_gl_menu_cylinder_context_t *
				   cylinder_context, GLenum mode, int i,
				   int n, int sphere_i, int nb_spheres)
{
  GLUquadricObj *cyl;

  cyl = gluNewQuadric ();
  if (cyl != NULL)
    {
      float radius;
      int slices;
      int stacks;
      float y;
      float x;

      if (mode == GL_RENDER)
	{
	  gluQuadricTexture (cyl, GL_TRUE);
	}

      radius = cylinder_context->const_data.sphere_radius1 / n;
      y = -cylinder_context->const_data.between1 * (i - (n - 1) / 2.0f) / n;
      x =
	(cylinder_context->const_data.sphere_between1 *
	 (sphere_i + 0.5f - nb_spheres / 2.0f)) / n;
      slices = cylinder_context->const_data.sphere_slices1 / n;
      if (slices < cylinder_context->const_data.sphere_slices_min)
	{
	  slices = cylinder_context->const_data.sphere_slices_min;
	}
      stacks = slices;
      glMatrixMode (GL_MODELVIEW);
      glPushMatrix ();
      glLoadIdentity ();
      glTranslatef (x, y, -1.0f);

      gluSphere (cyl, radius, slices, stacks);

      glMatrixMode (GL_MODELVIEW);
      glPopMatrix ();

      gluDeleteQuadric (cyl);
    }
  else
    {
      lw6sys_log (LW6SYS_LOG_WARNING, _("unable to create quadric"));
    }
}
