/*
  Liquid War 6 is a unique multiplayer wargame.
  Copyright (C)  2005, 2006, 2007, 2008  Christian Mauduit <ufoot@ufoot.org>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.


  Liquid War 6 homepage : http://www.gnu.org/software/liquidwar6/
  Contact author        : ufoot@ufoot.org
*/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "../../gfx.h"
#include "gl-utils.h"
#include "gl-utils-internal.h"

int
mod_gl_utils_surface_array_init (mod_gl_utils_context_t *
				 utils_context,
				 mod_gl_utils_surface_array_t * surface_array,
				 int w, int h, int tile_size)
{
  int ret = 0;
  int n_x, n_y;
  SDL_Surface *surface;

  if (mod_gl_utils_rect_array_init
      (utils_context, &(surface_array->layout), w, h, tile_size))
    {
      surface_array->surfaces =
	(SDL_Surface **) LW6SYS_CALLOC (surface_array->layout.n_w *
					surface_array->layout.n_h *
					sizeof (SDL_Surface *));

      if (surface_array->surfaces)
	{
	  ret = 1;
	  for (n_y = 0; n_y < surface_array->layout.n_h; ++n_y)
	    {
	      for (n_x = 0; n_x < surface_array->layout.n_w; ++n_x)
		{
		  surface =
		    mod_gl_utils_create_surface (utils_context,
						 surface_array->layout.w[n_x],
						 surface_array->
						 layout.h[n_y]);
		  if (surface)
		    {
		      mod_gl_utils_set_surface_array_surface (surface_array,
							      n_x, n_y,
							      surface);
		    }
		  else
		    {
		      ret = 0;
		      lw6sys_log (LW6SYS_LOG_WARNING,
				  _
				  ("surface %d,%d of surface array couldn't be created, array is broken"),
				  n_x, n_y);
		    }
		}
	    }
	}
    }
  else
    {
      mod_gl_utils_rect_array_clear (utils_context, &(surface_array->layout));
      if (surface_array->surfaces)
	{
	  LW6SYS_FREE (surface_array->surfaces);
	  surface_array->surfaces = NULL;
	}
    }

  return ret;
}

int
mod_gl_utils_surface_array_init_from_surface (mod_gl_utils_context_t *
					      utils_context,
					      mod_gl_utils_surface_array_t *
					      surface_array,
					      SDL_Surface * surface,
					      int tile_size)
{
  int ret = 0;
  int n_x, n_y;
  SDL_Surface *sub_surface;
  SDL_Rect area;
  SDL_Rect sub_area;

  if (mod_gl_utils_surface_array_init
      (utils_context, surface_array, surface->w, surface->h, tile_size))
    {
      ret = 1;
      for (n_y = 0; n_y < surface_array->layout.n_h; ++n_y)
	{
	  for (n_x = 0; n_x < surface_array->layout.n_w; ++n_x)
	    {
	      area.x = surface_array->layout.x0[n_x];
	      area.y = surface_array->layout.y0[n_y];
	      area.w = surface_array->layout.w[n_x];
	      area.h = surface_array->layout.h[n_y];

	      sub_area.x = 0;
	      sub_area.y = 0;
	      sub_area.w = surface_array->layout.w[n_x];
	      sub_area.h = surface_array->layout.h[n_y];

	      sub_surface =
		mod_gl_utils_get_surface_array_surface (surface_array, n_x,
							n_y);
	      if (sub_surface)
		{
		  SDL_SetAlpha (surface, 0, SDL_ALPHA_OPAQUE);
		  SDL_SetAlpha (sub_surface, 0, SDL_ALPHA_OPAQUE);
		  mod_gl_utils_clear_surface (sub_surface);
		  SDL_BlitSurface (surface, &area, sub_surface, &sub_area);
		}
	      else
		{
		  ret = 0;
		}
	    }
	}
    }

  return ret;
}

int
mod_gl_utils_surface_array_init_from_map (mod_gl_utils_context_t *
					  utils_context,
					  mod_gl_utils_surface_array_t *
					  surface_array,
					  lw6map_level_t * level,
					  int tile_size)
{
  int ret = 0;
  SDL_Surface *surface;

  surface = mod_gl_utils_map2surface (utils_context, level);
  if (surface)
    {
      ret = mod_gl_utils_surface_array_init_from_surface (utils_context,
							  surface_array,
							  surface, tile_size);
      mod_gl_utils_delete_surface (utils_context, surface);
    }

  return ret;
}

void
mod_gl_utils_surface_array_clear (mod_gl_utils_context_t * utils_context,
				  mod_gl_utils_surface_array_t *
				  surface_array)
{
  int i;
  if (surface_array->surfaces != NULL)
    {
      for (i = 0; i < surface_array->layout.n_w * surface_array->layout.n_h;
	   ++i)
	{
	  mod_gl_utils_delete_surface (utils_context,
				       surface_array->surfaces[i]);
	}
      LW6SYS_FREE (surface_array->surfaces);
      surface_array->surfaces = NULL;
    }
  mod_gl_utils_rect_array_clear (utils_context, &(surface_array->layout));
}
