/*
  Liquid War 6 is a unique multiplayer wargame.
  Copyright (C)  2005, 2006, 2007, 2008  Christian Mauduit <ufoot@ufoot.org>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.
  

  Liquid War 6 homepage : http://www.gnu.org/software/liquidwar6/
  Contact author        : ufoot@ufoot.org
*/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <string.h>

#include "gui.h"

#define DEFAULT_DYNAMIC_ZOOM 1.0f

/*
 * This is used to stamp maps as they are created.
 * Note that there's no race condition due to the fact that this
 * is global here, in fact even when 2 processes would share
 * this sequence id, it would not matter for they would then
 * try and identify the objects in their on per-process lists,
 * structures, Guile object, whatever they use.
 */
static u_int32_t seq_id = 0;

/*
 * Creates a new default look.
 */
lw6gui_look_t *
lw6gui_look_new (lw6map_style_t * map_style)
{
  lw6gui_look_t *look = NULL;

  look = (lw6gui_look_t *) LW6SYS_CALLOC (sizeof (lw6gui_look_t));

  if (look)
    {
      look->id = 0;
      while (!look->id)
	{
	  look->id = ++seq_id;
	}

      look->dynamic_zoom = DEFAULT_DYNAMIC_ZOOM;
      if (map_style)
	{
	  lw6map_style_copy (&look->style, map_style);
	}
      else
	{
	  lw6map_style_defaults (&look->style);
	}
    }

  return look;
}

/*
 * Frees a look and all its members.
 */
void
lw6gui_look_free (lw6gui_look_t * look)
{
  if (look)
    {
      lw6map_style_clear (&look->style);
      LW6SYS_FREE (look);
    }
  else
    {
      lw6sys_log (LW6SYS_LOG_WARNING, _("trying to free NULL look"));
    }
}


int
lw6gui_look_memory_footprint (lw6gui_look_t * look)
{
  //todo
  return sizeof (lw6gui_look_t);
}

char *
lw6gui_look_repr (lw6gui_look_t * look)
{
  char *ret = NULL;

  if (look)
    {
      ret = lw6sys_new_sprintf ("id=%u", look->id);
    }
  else
    {
      lw6sys_log (LW6SYS_LOG_WARNING, "look",
		  _("can't generate string id for NULL look"));
    }

  return ret;
}

int
lw6gui_look_set (lw6gui_look_t * look, char *key, char *value)
{
  int ret = 0;

  if (strcmp (key, "focus-id"))
    {
      look->focus_id = lw6sys_atoi (value);
      if (look->focus_id >= 0 || look->focus_id < LW6MAP_MAX_NB_CURSORS)
	{
	  ret = 1;
	}
      else
	{
	  lw6sys_log (LW6SYS_LOG_WARNING, _("incorrect focus_id %d"),
		      look->focus_id);
	  look->focus_id = 0;
	}
    }
  else if (strcmp (key, "dynamic-zoom"))
    {
      look->dynamic_zoom = lw6sys_atof (value);
      if (look->dynamic_zoom > 0.0f)
	{
	  ret = 1;
	}
      else
	{
	  lw6sys_log (LW6SYS_LOG_WARNING, _("incorrect dynamic_zoom %f"),
		      look->dynamic_zoom);
	  look->dynamic_zoom = DEFAULT_DYNAMIC_ZOOM;
	}
    }
  else
    {
      ret = lw6map_style_set (&(look->style), key, value);
    }

  return ret;
}

char *
lw6gui_look_get (lw6gui_look_t * look, char *key)
{
  char *ret = NULL;

  if (strcmp (key, "focus-id"))
    {
      ret = lw6sys_itoa (look->focus_id);
    }
  else if (strcmp (key, "dynamic-zoom"))
    {
      ret = lw6sys_ftoa (look->dynamic_zoom);
    }
  else
    {
      ret = lw6map_style_get (&look->style, key);
    }

  return ret;
}
