/*
  Liquid War 6 is a unique multiplayer wargame.
  Copyright (C)  2005, 2006, 2007, 2008  Christian Mauduit <ufoot@ufoot.org>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.
  

  Liquid War 6 homepage : http://www.gnu.org/software/liquidwar6/
  Contact author        : ufoot@ufoot.org
*/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "hlp.h"

static void
print_keyword_callback (void *func_data, void *data)
{
  FILE *f;
  char *entry = NULL;

  f = (FILE *) func_data;
  entry = (char *) data;
  if (entry)
    {
      fprintf (f, "%s\n", entry);
    }
  else
    {
      lw6sys_log (LW6SYS_LOG_WARNING, _("trying to print NULL help keyword"));
    }
}

static void
print_content_callback (void *func_data, void *data)
{
  FILE *f;
  char *entry = NULL;
  char *desc = NULL;
  char *about;
  lw6hlp_type_t type;

  f = (FILE *) func_data;
  entry = (char *) data;
  if (entry)
    {
      about = lw6hlp_about (&type, entry);
      if (lw6hlp_match (entry, LW6DEF_ABOUT))
	{
	  /*
	   * OK this is ugly, but so much less complicated than handling
	   * a "does this have a parameter?" flag, especially when this
	   * is the only exception. On the other side that's typically
	   * the option that requires a *precise* help entry, and
	   * moreover this is displayed by '--help', so, I hacked it.
	   * Note that ./doc/selfdoc.pl does the same.
	   */
	  fprintf (f, "--about=<keyword>\n");
	}
      else
	{
	  fprintf (f, "--%s\n", entry);
	}
      desc =
	lw6sys_str_reformat (about, LW6SYS_REFORMAT_INDENT_PREFIX,
			     LW6SYS_REFORMAT_INDENT_NB_COLUMNS);
      if (desc)
	{
	  fprintf (f, "%s", desc);
	  LW6SYS_FREE (desc);
	}
      fprintf (f, "\n");
    }
  else
    {
      lw6sys_log (LW6SYS_LOG_WARNING, _("trying to print NULL help keyword"));
    }
}

/**
 * lw6hlp_print_keyword
 *
 * list: a pointer to a list of keywords
 * f: the file to print the content to
 *
 * Prints all the keywords from the list. One keyword per line.
 *
 * Return value: none.
 */
void
lw6hlp_print_keyword (lw6sys_list_t ** list, FILE * f)
{
  lw6sys_sort (list, lw6sys_sort_str_callback);
  lw6sys_list_map (*list, print_keyword_callback, (void *) f);
}

/**
 * lw6hlp_print_content
 *
 * list: a pointer to a list of keywords
 * f: the file to print the content to
 *
 * Prints all the keywords from the list, with the associated
 * keyword help, to the given file. Output is formatted to fit
 * on the standard terminal/console.
 *
 * Return value: none.
 */
void
lw6hlp_print_content (lw6sys_list_t ** list, FILE * f)
{
  lw6sys_sort (list, lw6sys_sort_str_callback);
  lw6sys_list_map (*list, print_content_callback, (void *) f);
}
