/*
  Liquid War 6 is a unique multiplayer wargame.
  Copyright (C)  2005, 2006, 2007, 2008  Christian Mauduit <ufoot@ufoot.org>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.


  Liquid War 6 homepage : http://www.gnu.org/software/liquidwar6/
  Contact author        : ufoot@ufoot.org
*/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "hlp.h"

#define TEST_KEYWORD LW6DEF_PREFIX

/*
 * Testing about
 */
static int
test_about ()
{
  int ret = 1;
  LW6SYS_TEST_FUNCTION_BEGIN;

  {
    char *help_string = NULL;

    if (!lw6hlp_is_documented (TEST_KEYWORD))
      {
	ret = 0;
      }

    help_string = lw6hlp_about (NULL, TEST_KEYWORD);
    lw6sys_log (LW6SYS_LOG_NOTICE, _("help for \"%s\" is \"%s\""),
		TEST_KEYWORD, help_string);
  }

  LW6SYS_TEST_FUNCTION_END;
  return ret;
}

/*
 * Testing print
 */
static int
test_print ()
{
  int ret = 1;
  LW6SYS_TEST_FUNCTION_BEGIN;

  {
    lw6sys_list_t *list;

    list = lw6hlp_list_quick ();
    if (list)
      {
	lw6hlp_print_keyword (&list, stdout);
	lw6sys_list_free (list);
      }
  }

  LW6SYS_TEST_FUNCTION_END;
  return ret;
}

int
lw6hlp_test ()
{
  int ret = 0;

  if (lw6sys_false ())
    {
      /*
       * Just to make sure most functions are stuffed in the binary
       */
      lw6sys_test ();
    }

  ret = test_about () && test_print ();

  return ret;
}
