/*
  Liquid War 6 is a unique multiplayer wargame.
  Copyright (C)  2005, 2006, 2007, 2008  Christian Mauduit <ufoot@ufoot.org>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.


  Liquid War 6 homepage : http://www.gnu.org/software/liquidwar6/
  Contact author        : ufoot@ufoot.org
*/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <string.h>
#include <math.h>

#include "ker.h"
#include "ker-internal.h"

int
_lw6ker_layer_init (lw6ker_layer_t * layer,
		    lw6ker_map_struct_t * map_struct,
		    lw6ker_armies_t * armies, lw6map_rules_t * options)
{
  int ret = 0;
  int32_t i;

  layer->map_struct = map_struct;
  layer->armies = armies;

  layer->nb_slots = map_struct->shape.w * map_struct->shape.h;
  layer->slots =
    (lw6ker_slot_state_t *) LW6SYS_CALLOC (layer->nb_slots *
					   sizeof (lw6ker_slot_state_t));
  if (layer->slots)
    {
      ret = 1;

      for (i = 0; i < layer->nb_slots; ++i)
	{
	  layer->slots[i].fighter_id = -1;
	}
    }
  else
    {
      lw6sys_log (LW6SYS_LOG_WARNING,
		  _("unable to allocate SLOT_STATE array"));
    }

  return ret;
}

void
_lw6ker_layer_clear (lw6ker_layer_t * layer)
{
  if (layer->slots)
    {
      LW6SYS_FREE (layer->slots);
    }
  layer->slots = NULL;
  layer->nb_slots = 0;

  layer->armies = NULL;
  layer->map_struct = NULL;
}

int
_lw6ker_layer_sync (lw6ker_layer_t * dst, lw6ker_layer_t * src)
{
  int ret = 0;

  if (dst && src
      && _lw6ker_map_struct_lazy_compare (dst->map_struct, src->map_struct))
    {
      dst->nb_slots = src->nb_slots;
      memcpy (dst->slots, src->slots,
	      src->map_struct->nb_slots * sizeof (lw6ker_slot_state_t));
      /*
       * Note: we don't copy or even affect "armies" here, we rely on
       * the first initialization of the pointer, and the contents are
       * memcopied from armies_copy.
       */
      ret = 1;
    }
  else
    {
      lw6sys_log (LW6SYS_LOG_WARNING,
		  _
		  ("layer_copy only works if dst and src point to the same map_struct"));
    }

  return ret;
}

void
_lw6ker_layer_update_checksum (lw6ker_layer_t * layer, u_int32_t * checksum)
{
  int i;
  // map_struct & armies checksumed elsewhere
  lw6sys_checksum_update_int32 (checksum, layer->nb_slots);
  for (i = 0; i < layer->nb_slots; ++i)
    {
      _lw6ker_slot_state_update_checksum (&(layer->slots[i]), checksum);
    }
}
