/*
  Liquid War 6 is a unique multiplayer wargame.
  Copyright (C)  2005, 2006, 2007, 2008  Christian Mauduit <ufoot@ufoot.org>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.


  Liquid War 6 homepage : http://www.gnu.org/software/liquidwar6/
  Contact author        : ufoot@ufoot.org
*/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <string.h>

#include "map.h"

/**
 * lw6map_dup:
 *
 * @source: the map to copy
 *
 * Performs a deep copy of the map, all elements are newly allocated
 * and source can safely be destroyed after it's been duplicated.
 *
 * Return value: a newly allocated map, may be NULL.
 */
lw6map_level_t *
lw6map_dup (lw6map_level_t * source)
{
  lw6map_level_t *ret = NULL;
  int size = 0;
  int id;

  ret = lw6map_new ();
  if (ret)
    {
      id = ret->id;
      memcpy (ret, source, sizeof (lw6map_level_t));
      ret->id = id;

      memset (&(ret->param), 0, sizeof (lw6map_param_t));
      lw6map_param_copy (&(ret->param), &(source->param));

      if (source->metadata.title)
	{
	  ret->metadata.title = lw6sys_str_copy (source->metadata.title);
	}
      if (source->metadata.readme)
	{
	  ret->metadata.readme = lw6sys_str_copy (source->metadata.readme);
	}
      if (source->depth.data)
	{
	  size =
	    source->depth.shape.w * source->depth.shape.h *
	    sizeof (unsigned char);
	  ret->depth.data = LW6SYS_MALLOC (size);
	  if (ret->depth.data)
	    {
	      memcpy (ret->depth.data, source->depth.data, size);
	    }
	  else
	    {
	      lw6sys_log (LW6SYS_LOG_WARNING,
			  _("unable to duplicate depth data"));
	    }
	}
      if (source->texture.data)
	{
	  size =
	    source->texture.shape.w * source->texture.shape.h *
	    sizeof (lw6sys_color_8_t);
	  ret->texture.data = LW6SYS_MALLOC (size);
	  if (ret->texture.data)
	    {
	      memcpy (ret->texture.data, source->texture.data, size);
	    }
	  else
	    {
	      lw6sys_log (LW6SYS_LOG_WARNING,
			  _("unable to duplicate texture data"));
	    }
	}
    }

  return ret;
}
