/*
  Liquid War 6 is a unique multiplayer wargame.
  Copyright (C)  2005, 2006, 2007, 2008  Christian Mauduit <ufoot@ufoot.org>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.


  Liquid War 6 homepage : http://www.gnu.org/software/liquidwar6/
  Contact author        : ufoot@ufoot.org
*/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <string.h>

#include "map.h"

void
lw6map_style_defaults (lw6map_style_t * style)
{
  lw6map_style_clear (style);

  style->keep_ratio = LW6MAP_STYLE_DEFAULT_KEEP_RATIO;
  style->zoom = LW6MAP_STYLE_DEFAULT_ZOOM;
  style->background_style =
    lw6sys_str_copy (LW6MAP_STYLE_DEFAULT_BACKGROUND_STYLE);
  style->hud_style = lw6sys_str_copy (LW6MAP_STYLE_DEFAULT_HUD_STYLE);
  style->menu_style = lw6sys_str_copy (LW6MAP_STYLE_DEFAULT_MENU_STYLE);
  style->view_style = lw6sys_str_copy (LW6MAP_STYLE_DEFAULT_VIEW_STYLE);
  style->animation_density = LW6MAP_STYLE_DEFAULT_ANIMATION_DENSITY;
  style->animation_speed = LW6MAP_STYLE_DEFAULT_ANIMATION_SPEED;
  style->cursor_size = LW6MAP_STYLE_DEFAULT_CURSOR_SIZE;
  style->colorize = LW6MAP_STYLE_DEFAULT_COLORIZE;
  style->color_base.bg =
    lw6sys_color_a_to_8 (LW6MAP_STYLE_DEFAULT_COLOR_BASE_BG);
  style->color_base.fg =
    lw6sys_color_a_to_8 (LW6MAP_STYLE_DEFAULT_COLOR_BASE_FG);
  style->color_alternate.bg =
    lw6sys_color_a_to_8 (LW6MAP_STYLE_DEFAULT_COLOR_ALTERNATE_BG);
  style->color_alternate.fg =
    lw6sys_color_a_to_8 (LW6MAP_STYLE_DEFAULT_COLOR_ALTERNATE_FG);
  style->background_color_root.bg =
    lw6sys_color_a_to_8 (LW6MAP_STYLE_DEFAULT_BACKGROUND_COLOR_ROOT_BG);
  style->background_color_root.fg =
    lw6sys_color_a_to_8 (LW6MAP_STYLE_DEFAULT_BACKGROUND_COLOR_ROOT_FG);
  style->background_color_stuff.bg =
    lw6sys_color_a_to_8 (LW6MAP_STYLE_DEFAULT_BACKGROUND_COLOR_STUFF_BG);
  style->background_color_stuff.fg =
    lw6sys_color_a_to_8 (LW6MAP_STYLE_DEFAULT_BACKGROUND_COLOR_STUFF_FG);
  style->hud_color_frame.bg =
    lw6sys_color_a_to_8 (LW6MAP_STYLE_DEFAULT_HUD_COLOR_FRAME_BG);
  style->hud_color_frame.fg =
    lw6sys_color_a_to_8 (LW6MAP_STYLE_DEFAULT_HUD_COLOR_FRAME_FG);
  style->hud_color_text.bg =
    lw6sys_color_a_to_8 (LW6MAP_STYLE_DEFAULT_HUD_COLOR_TEXT_BG);
  style->hud_color_text.fg =
    lw6sys_color_a_to_8 (LW6MAP_STYLE_DEFAULT_HUD_COLOR_TEXT_FG);
  style->menu_color_default.bg =
    lw6sys_color_a_to_8 (LW6MAP_STYLE_DEFAULT_MENU_COLOR_DEFAULT_BG);
  style->menu_color_default.fg =
    lw6sys_color_a_to_8 (LW6MAP_STYLE_DEFAULT_MENU_COLOR_DEFAULT_FG);
  style->menu_color_selected.bg =
    lw6sys_color_a_to_8 (LW6MAP_STYLE_DEFAULT_MENU_COLOR_SELECTED_BG);
  style->menu_color_selected.fg =
    lw6sys_color_a_to_8 (LW6MAP_STYLE_DEFAULT_MENU_COLOR_SELECTED_FG);
  style->menu_color_disabled.bg =
    lw6sys_color_a_to_8 (LW6MAP_STYLE_DEFAULT_MENU_COLOR_DISABLED_BG);
  style->menu_color_disabled.fg =
    lw6sys_color_a_to_8 (LW6MAP_STYLE_DEFAULT_MENU_COLOR_DISABLED_FG);
  style->view_color_cursor.bg =
    lw6sys_color_a_to_8 (LW6MAP_STYLE_DEFAULT_VIEW_COLOR_CURSOR_BG);
  style->view_color_cursor.fg =
    lw6sys_color_a_to_8 (LW6MAP_STYLE_DEFAULT_VIEW_COLOR_CURSOR_FG);
  style->view_color_map.bg =
    lw6sys_color_a_to_8 (LW6MAP_STYLE_DEFAULT_VIEW_COLOR_MAP_BG);
  style->view_color_map.fg =
    lw6sys_color_a_to_8 (LW6MAP_STYLE_DEFAULT_VIEW_COLOR_MAP_FG);
  style->system_color.bg =
    lw6sys_color_a_to_8 (LW6MAP_STYLE_DEFAULT_SYSTEM_COLOR_BG);
  style->system_color.fg =
    lw6sys_color_a_to_8 (LW6MAP_STYLE_DEFAULT_SYSTEM_COLOR_FG);
  style->team_colors[LW6MAP_TEAM_COLOR_RED] =
    lw6sys_color_a_to_8 (LW6MAP_STYLE_DEFAULT_TEAM_COLOR_RED);
  style->team_colors[LW6MAP_TEAM_COLOR_GREEN] =
    lw6sys_color_a_to_8 (LW6MAP_STYLE_DEFAULT_TEAM_COLOR_GREEN);
  style->team_colors[LW6MAP_TEAM_COLOR_BLUE] =
    lw6sys_color_a_to_8 (LW6MAP_STYLE_DEFAULT_TEAM_COLOR_BLUE);
  style->team_colors[LW6MAP_TEAM_COLOR_YELLOW] =
    lw6sys_color_a_to_8 (LW6MAP_STYLE_DEFAULT_TEAM_COLOR_YELLOW);
  style->team_colors[LW6MAP_TEAM_COLOR_CYAN] =
    lw6sys_color_a_to_8 (LW6MAP_STYLE_DEFAULT_TEAM_COLOR_CYAN);
  style->team_colors[LW6MAP_TEAM_COLOR_MAGENTA] =
    lw6sys_color_a_to_8 (LW6MAP_STYLE_DEFAULT_TEAM_COLOR_MAGENTA);
  style->team_colors[LW6MAP_TEAM_COLOR_ORANGE] =
    lw6sys_color_a_to_8 (LW6MAP_STYLE_DEFAULT_TEAM_COLOR_ORANGE);
  style->team_colors[LW6MAP_TEAM_COLOR_LIGHTBLUE] =
    lw6sys_color_a_to_8 (LW6MAP_STYLE_DEFAULT_TEAM_COLOR_LIGHTBLUE);
  style->team_colors[LW6MAP_TEAM_COLOR_PURPLE] =
    lw6sys_color_a_to_8 (LW6MAP_STYLE_DEFAULT_TEAM_COLOR_PURPLE);
  style->team_colors[LW6MAP_TEAM_COLOR_PINK] =
    lw6sys_color_a_to_8 (LW6MAP_STYLE_DEFAULT_TEAM_COLOR_PINK);
}

/*
 * Note that this function won't work on an unitialized
 * structure, structure must be zeroed by some CALLOC
 * or something, else automatic freeing of pointers
 * will fail.
 */
void
lw6map_style_clear (lw6map_style_t * style)
{
  if (style)
    {
      if (style->background_style)
	{
	  LW6SYS_FREE (style->background_style);
	}

      if (style->hud_style)
	{
	  LW6SYS_FREE (style->hud_style);
	}

      if (style->menu_style)
	{
	  LW6SYS_FREE (style->menu_style);
	}

      if (style->view_style)
	{
	  LW6SYS_FREE (style->view_style);
	}

      memset (style, 0, sizeof (lw6map_style_t));
    }
}

/*
 * Like with clear, *dst must be either initialized or
 * totally zeroed, else function will fail (core dump)
 */
void
lw6map_style_copy (lw6map_style_t * dst, lw6map_style_t * src)
{
  lw6map_style_clear (dst);
  memcpy (dst, src, sizeof (lw6map_style_t));

  if (src->background_style)
    {
      dst->background_style = lw6sys_str_copy (src->background_style);
    }
  if (src->hud_style)
    {
      dst->hud_style = lw6sys_str_copy (src->hud_style);
    }
  if (src->menu_style)
    {
      dst->menu_style = lw6sys_str_copy (src->menu_style);
    }
  if (src->view_style)
    {
      dst->view_style = lw6sys_str_copy (src->view_style);
    }
}

int
lw6map_style_set (lw6map_style_t * style, char *key, char *value)
{
  int ret = 1;
  char *formatted_key = NULL;

  formatted_key = lw6sys_keyword_as_key (key);
  if (formatted_key)
    {
      if (!strcmp (LW6DEF_KEEP_RATIO, formatted_key))
	{
	  style->keep_ratio = lw6sys_atob (value);
	}
      else if (!strcmp (LW6DEF_ZOOM, formatted_key))
	{
	  style->zoom = lw6sys_atof (value);
	}
      else if (!strcmp (LW6DEF_BACKGROUND_STYLE, formatted_key))
	{
	  if (style->background_style)
	    {
	      LW6SYS_FREE (style->background_style);
	    }
	  style->background_style = lw6sys_str_copy (value);
	}
      else if (!strcmp (LW6DEF_HUD_STYLE, formatted_key))
	{
	  if (style->hud_style)
	    {
	      LW6SYS_FREE (style->hud_style);
	    }
	  style->hud_style = lw6sys_str_copy (value);
	}
      else if (!strcmp (LW6DEF_MENU_STYLE, formatted_key))
	{
	  if (style->menu_style)
	    {
	      LW6SYS_FREE (style->menu_style);
	    }
	  style->menu_style = lw6sys_str_copy (value);
	}
      else if (!strcmp (LW6DEF_VIEW_STYLE, formatted_key))
	{
	  if (style->view_style)
	    {
	      LW6SYS_FREE (style->view_style);
	    }
	  style->view_style = lw6sys_str_copy (value);
	}
      else if (!strcmp (LW6DEF_ANIMATION_DENSITY, formatted_key))
	{
	  style->animation_density = lw6sys_atof (value);
	}
      else if (!strcmp (LW6DEF_ANIMATION_SPEED, formatted_key))
	{
	  style->animation_speed = lw6sys_atof (value);
	}
      else if (!strcmp (LW6DEF_CURSOR_SIZE, formatted_key))
	{
	  style->cursor_size = lw6sys_atof (value);
	}
      else if (!strcmp (LW6DEF_COLORIZE, formatted_key))
	{
	  style->colorize = lw6sys_atob (value);
	}
      else if (!strcmp (LW6DEF_COLOR_BASE_BG, formatted_key))
	{
	  style->color_base.bg = lw6sys_color_a_to_8 (value);
	}
      else if (!strcmp (LW6DEF_COLOR_BASE_FG, formatted_key))
	{
	  style->color_base.fg = lw6sys_color_a_to_8 (value);
	}
      else if (!strcmp (LW6DEF_COLOR_ALTERNATE_BG, formatted_key))
	{
	  style->color_alternate.bg = lw6sys_color_a_to_8 (value);
	}
      else if (!strcmp (LW6DEF_COLOR_ALTERNATE_FG, formatted_key))
	{
	  style->color_alternate.fg = lw6sys_color_a_to_8 (value);
	}
      else if (!strcmp (LW6DEF_BACKGROUND_COLOR_ROOT_BG, formatted_key))
	{
	  style->background_color_root.bg = lw6sys_color_a_to_8 (value);
	}
      else if (!strcmp (LW6DEF_BACKGROUND_COLOR_ROOT_FG, formatted_key))
	{
	  style->background_color_root.fg = lw6sys_color_a_to_8 (value);
	}
      else if (!strcmp (LW6DEF_BACKGROUND_COLOR_STUFF_BG, formatted_key))
	{
	  style->background_color_stuff.bg = lw6sys_color_a_to_8 (value);
	}
      else if (!strcmp (LW6DEF_BACKGROUND_COLOR_STUFF_FG, formatted_key))
	{
	  style->background_color_stuff.fg = lw6sys_color_a_to_8 (value);
	}
      else if (!strcmp (LW6DEF_HUD_COLOR_FRAME_BG, formatted_key))
	{
	  style->hud_color_frame.bg = lw6sys_color_a_to_8 (value);
	}
      else if (!strcmp (LW6DEF_HUD_COLOR_FRAME_FG, formatted_key))
	{
	  style->hud_color_frame.fg = lw6sys_color_a_to_8 (value);
	}
      else if (!strcmp (LW6DEF_HUD_COLOR_TEXT_BG, formatted_key))
	{
	  style->hud_color_text.bg = lw6sys_color_a_to_8 (value);
	}
      else if (!strcmp (LW6DEF_HUD_COLOR_TEXT_FG, formatted_key))
	{
	  style->hud_color_text.fg = lw6sys_color_a_to_8 (value);
	}
      else if (!strcmp (LW6DEF_MENU_COLOR_DEFAULT_BG, formatted_key))
	{
	  style->menu_color_default.bg = lw6sys_color_a_to_8 (value);
	}
      else if (!strcmp (LW6DEF_MENU_COLOR_DEFAULT_FG, formatted_key))
	{
	  style->menu_color_default.fg = lw6sys_color_a_to_8 (value);
	}
      else if (!strcmp (LW6DEF_MENU_COLOR_SELECTED_BG, formatted_key))
	{
	  style->menu_color_selected.bg = lw6sys_color_a_to_8 (value);
	}
      else if (!strcmp (LW6DEF_MENU_COLOR_SELECTED_FG, formatted_key))
	{
	  style->menu_color_selected.fg = lw6sys_color_a_to_8 (value);
	}
      else if (!strcmp (LW6DEF_MENU_COLOR_DISABLED_BG, formatted_key))
	{
	  style->menu_color_disabled.bg = lw6sys_color_a_to_8 (value);
	}
      else if (!strcmp (LW6DEF_MENU_COLOR_DISABLED_FG, formatted_key))
	{
	  style->menu_color_disabled.fg = lw6sys_color_a_to_8 (value);
	}
      else if (!strcmp (LW6DEF_VIEW_COLOR_CURSOR_BG, formatted_key))
	{
	  style->view_color_cursor.bg = lw6sys_color_a_to_8 (value);
	}
      else if (!strcmp (LW6DEF_VIEW_COLOR_CURSOR_FG, formatted_key))
	{
	  style->view_color_cursor.fg = lw6sys_color_a_to_8 (value);
	}
      else if (!strcmp (LW6DEF_VIEW_COLOR_MAP_BG, formatted_key))
	{
	  style->view_color_map.bg = lw6sys_color_a_to_8 (value);
	}
      else if (!strcmp (LW6DEF_VIEW_COLOR_MAP_FG, formatted_key))
	{
	  style->view_color_map.fg = lw6sys_color_a_to_8 (value);
	}
      else if (!strcmp (LW6DEF_SYSTEM_COLOR_BG, formatted_key))
	{
	  style->system_color.bg = lw6sys_color_a_to_8 (value);
	}
      else if (!strcmp (LW6DEF_SYSTEM_COLOR_FG, formatted_key))
	{
	  style->system_color.fg = lw6sys_color_a_to_8 (value);
	}
      else if (!strcmp (LW6DEF_TEAM_COLOR_RED, formatted_key))
	{
	  style->team_colors[LW6MAP_TEAM_COLOR_RED] =
	    lw6sys_color_a_to_8 (value);
	}
      else if (!strcmp (LW6DEF_TEAM_COLOR_GREEN, formatted_key))
	{
	  style->team_colors[LW6MAP_TEAM_COLOR_GREEN] =
	    lw6sys_color_a_to_8 (value);
	}
      else if (!strcmp (LW6DEF_TEAM_COLOR_BLUE, formatted_key))
	{
	  style->team_colors[LW6MAP_TEAM_COLOR_BLUE] =
	    lw6sys_color_a_to_8 (value);
	}
      else if (!strcmp (LW6DEF_TEAM_COLOR_YELLOW, formatted_key))
	{
	  style->team_colors[LW6MAP_TEAM_COLOR_YELLOW] =
	    lw6sys_color_a_to_8 (value);
	}
      else if (!strcmp (LW6DEF_TEAM_COLOR_CYAN, formatted_key))
	{
	  style->team_colors[LW6MAP_TEAM_COLOR_CYAN] =
	    lw6sys_color_a_to_8 (value);
	}
      else if (!strcmp (LW6DEF_TEAM_COLOR_MAGENTA, formatted_key))
	{
	  style->team_colors[LW6MAP_TEAM_COLOR_MAGENTA] =
	    lw6sys_color_a_to_8 (value);
	}
      else if (!strcmp (LW6DEF_TEAM_COLOR_ORANGE, formatted_key))
	{
	  style->team_colors[LW6MAP_TEAM_COLOR_ORANGE] =
	    lw6sys_color_a_to_8 (value);
	}
      else if (!strcmp (LW6DEF_TEAM_COLOR_LIGHTBLUE, formatted_key))
	{
	  style->team_colors[LW6MAP_TEAM_COLOR_LIGHTBLUE] =
	    lw6sys_color_a_to_8 (value);
	}
      else if (!strcmp (LW6DEF_TEAM_COLOR_PURPLE, formatted_key))
	{
	  style->team_colors[LW6MAP_TEAM_COLOR_PURPLE] =
	    lw6sys_color_a_to_8 (value);
	}
      else if (!strcmp (LW6DEF_TEAM_COLOR_PINK, formatted_key))
	{
	  style->team_colors[LW6MAP_TEAM_COLOR_PINK] =
	    lw6sys_color_a_to_8 (value);
	}
      else
	{
	  ret = 0;		// no entry matches
	}
      LW6SYS_FREE (formatted_key);
    }
  else
    {
      ret = 0;
    }

  return ret;
}

char *
lw6map_style_get (lw6map_style_t * style, char *key)
{
  char *ret = NULL;
  char *formatted_key = NULL;

  formatted_key = lw6sys_keyword_as_key (key);
  if (formatted_key)
    {
      if (!strcmp (LW6DEF_KEEP_RATIO, formatted_key))
	{
	  ret = lw6sys_btoa (style->keep_ratio);
	}
      else if (!strcmp (LW6DEF_ZOOM, formatted_key))
	{
	  ret = lw6sys_ftoa (style->zoom);
	}
      else if (!strcmp (LW6DEF_BACKGROUND_STYLE, formatted_key))
	{
	  ret = lw6sys_str_copy (style->background_style);
	}
      else if (!strcmp (LW6DEF_HUD_STYLE, formatted_key))
	{
	  ret = lw6sys_str_copy (style->hud_style);
	}
      else if (!strcmp (LW6DEF_MENU_STYLE, formatted_key))
	{
	  ret = lw6sys_str_copy (style->menu_style);
	}
      else if (!strcmp (LW6DEF_VIEW_STYLE, formatted_key))
	{
	  ret = lw6sys_str_copy (style->view_style);
	}
      else if (!strcmp (LW6DEF_ANIMATION_DENSITY, formatted_key))
	{
	  ret = lw6sys_ftoa (style->animation_density);
	}
      else if (!strcmp (LW6DEF_ANIMATION_SPEED, formatted_key))
	{
	  ret = lw6sys_ftoa (style->animation_speed);
	}
      else if (!strcmp (LW6DEF_CURSOR_SIZE, formatted_key))
	{
	  ret = lw6sys_ftoa (style->cursor_size);
	}
      else if (!strcmp (LW6DEF_COLORIZE, formatted_key))
	{
	  ret = lw6sys_btoa (style->colorize);
	}
      else if (!strcmp (LW6DEF_COLOR_BASE_BG, formatted_key))
	{
	  ret = lw6sys_color_8_to_a (style->color_base.bg);
	}
      else if (!strcmp (LW6DEF_COLOR_BASE_FG, formatted_key))
	{
	  ret = lw6sys_color_8_to_a (style->color_base.fg);
	}
      else if (!strcmp (LW6DEF_COLOR_ALTERNATE_BG, formatted_key))
	{
	  ret = lw6sys_color_8_to_a (style->color_alternate.bg);
	}
      else if (!strcmp (LW6DEF_COLOR_ALTERNATE_FG, formatted_key))
	{
	  ret = lw6sys_color_8_to_a (style->color_alternate.fg);
	}
      else if (!strcmp (LW6DEF_BACKGROUND_COLOR_ROOT_BG, formatted_key))
	{
	  ret = lw6sys_color_8_to_a (style->background_color_root.bg);
	}
      else if (!strcmp (LW6DEF_BACKGROUND_COLOR_ROOT_FG, formatted_key))
	{
	  ret = lw6sys_color_8_to_a (style->background_color_root.fg);
	}
      else if (!strcmp (LW6DEF_BACKGROUND_COLOR_STUFF_BG, formatted_key))
	{
	  ret = lw6sys_color_8_to_a (style->background_color_stuff.bg);
	}
      else if (!strcmp (LW6DEF_BACKGROUND_COLOR_STUFF_FG, formatted_key))
	{
	  ret = lw6sys_color_8_to_a (style->background_color_stuff.fg);
	}
      else if (!strcmp (LW6DEF_HUD_COLOR_FRAME_BG, formatted_key))
	{
	  ret = lw6sys_color_8_to_a (style->hud_color_frame.bg);
	}
      else if (!strcmp (LW6DEF_HUD_COLOR_FRAME_FG, formatted_key))
	{
	  ret = lw6sys_color_8_to_a (style->hud_color_frame.fg);
	}
      else if (!strcmp (LW6DEF_HUD_COLOR_TEXT_BG, formatted_key))
	{
	  ret = lw6sys_color_8_to_a (style->color_base.bg);
	}
      else if (!strcmp (LW6DEF_HUD_COLOR_TEXT_FG, formatted_key))
	{
	  ret = lw6sys_color_8_to_a (style->color_base.fg);
	}
      else if (!strcmp (LW6DEF_MENU_COLOR_DEFAULT_BG, formatted_key))
	{
	  ret = lw6sys_color_8_to_a (style->menu_color_default.bg);
	}
      else if (!strcmp (LW6DEF_MENU_COLOR_DEFAULT_FG, formatted_key))
	{
	  ret = lw6sys_color_8_to_a (style->menu_color_default.fg);
	}
      else if (!strcmp (LW6DEF_MENU_COLOR_SELECTED_BG, formatted_key))
	{
	  ret = lw6sys_color_8_to_a (style->menu_color_selected.bg);
	}
      else if (!strcmp (LW6DEF_MENU_COLOR_SELECTED_FG, formatted_key))
	{
	  ret = lw6sys_color_8_to_a (style->menu_color_selected.fg);
	}
      else if (!strcmp (LW6DEF_MENU_COLOR_DISABLED_BG, formatted_key))
	{
	  ret = lw6sys_color_8_to_a (style->menu_color_disabled.bg);
	}
      else if (!strcmp (LW6DEF_MENU_COLOR_DISABLED_FG, formatted_key))
	{
	  ret = lw6sys_color_8_to_a (style->menu_color_disabled.fg);
	}
      else if (!strcmp (LW6DEF_VIEW_COLOR_CURSOR_BG, formatted_key))
	{
	  ret = lw6sys_color_8_to_a (style->view_color_cursor.bg);
	}
      else if (!strcmp (LW6DEF_VIEW_COLOR_CURSOR_FG, formatted_key))
	{
	  ret = lw6sys_color_8_to_a (style->view_color_cursor.fg);
	}
      else if (!strcmp (LW6DEF_VIEW_COLOR_MAP_BG, formatted_key))
	{
	  ret = lw6sys_color_8_to_a (style->view_color_map.bg);
	}
      else if (!strcmp (LW6DEF_VIEW_COLOR_MAP_FG, formatted_key))
	{
	  ret = lw6sys_color_8_to_a (style->view_color_map.fg);
	}
      else if (!strcmp (LW6DEF_SYSTEM_COLOR_BG, formatted_key))
	{
	  ret = lw6sys_color_8_to_a (style->system_color.bg);
	}
      else if (!strcmp (LW6DEF_SYSTEM_COLOR_FG, formatted_key))
	{
	  ret = lw6sys_color_8_to_a (style->system_color.fg);
	}
      else if (!strcmp (LW6DEF_TEAM_COLOR_RED, formatted_key))
	{
	  ret =
	    lw6sys_color_8_to_a (style->team_colors[LW6MAP_TEAM_COLOR_RED]);
	}
      else if (!strcmp (LW6DEF_TEAM_COLOR_GREEN, formatted_key))
	{
	  ret =
	    lw6sys_color_8_to_a (style->team_colors[LW6MAP_TEAM_COLOR_GREEN]);
	}
      else if (!strcmp (LW6DEF_TEAM_COLOR_BLUE, formatted_key))
	{
	  ret =
	    lw6sys_color_8_to_a (style->team_colors[LW6MAP_TEAM_COLOR_BLUE]);
	}
      else if (!strcmp (LW6DEF_TEAM_COLOR_YELLOW, formatted_key))
	{
	  ret =
	    lw6sys_color_8_to_a (style->team_colors
				 [LW6MAP_TEAM_COLOR_YELLOW]);
	}
      else if (!strcmp (LW6DEF_TEAM_COLOR_CYAN, formatted_key))
	{
	  ret =
	    lw6sys_color_8_to_a (style->team_colors[LW6MAP_TEAM_COLOR_CYAN]);
	}
      else if (!strcmp (LW6DEF_TEAM_COLOR_MAGENTA, formatted_key))
	{
	  ret =
	    lw6sys_color_8_to_a (style->team_colors
				 [LW6MAP_TEAM_COLOR_MAGENTA]);
	}
      else if (!strcmp (LW6DEF_TEAM_COLOR_ORANGE, formatted_key))
	{
	  ret =
	    lw6sys_color_8_to_a (style->team_colors
				 [LW6MAP_TEAM_COLOR_ORANGE]);
	}
      else if (!strcmp (LW6DEF_TEAM_COLOR_LIGHTBLUE, formatted_key))
	{
	  ret =
	    lw6sys_color_8_to_a (style->team_colors
				 [LW6MAP_TEAM_COLOR_LIGHTBLUE]);
	}
      else if (!strcmp (LW6DEF_TEAM_COLOR_PURPLE, formatted_key))
	{
	  ret =
	    lw6sys_color_8_to_a (style->team_colors
				 [LW6MAP_TEAM_COLOR_PURPLE]);
	}
      else if (!strcmp (LW6DEF_TEAM_COLOR_PINK, formatted_key))
	{
	  ret =
	    lw6sys_color_8_to_a (style->team_colors[LW6MAP_TEAM_COLOR_PINK]);
	}
      LW6SYS_FREE (formatted_key);
    }

  return ret;
}

char *
lw6map_style_get_default (char *key)
{
  lw6map_style_t *style;
  char *ret = NULL;

  style = (lw6map_style_t *) LW6SYS_CALLOC (sizeof (lw6map_style_t));
  if (style)
    {
      lw6map_style_defaults (style);
      ret = lw6map_style_get (style, key);
      lw6map_style_clear (style);
      LW6SYS_FREE (style);
    }

  if (!ret)
    {
      lw6sys_log (LW6SYS_LOG_WARNING,
		  _("unable to get default value for style parameter \"%s\""),
		  key);
    }

  return ret;
}
