/*
  Liquid War 6 is a unique multiplayer wargame.
  Copyright (C)  2005, 2006, 2007, 2008  Christian Mauduit <ufoot@ufoot.org>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.


  Liquid War 6 homepage : http://www.gnu.org/software/liquidwar6/
  Contact author        : ufoot@ufoot.org
*/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "srv.h"

#define TEST_ARGC 1
#define TEST_ARGV0 "prog"

#define TEST_NB_BACKENDS 3

static int
test_init (lw6srv_backend_t ** backend, lw6srv_listener_t * listener)
{
  int ret = 1;
  LW6SYS_TEST_FUNCTION_BEGIN;

  {
    int i;

    for (i = 0; i < TEST_NB_BACKENDS; ++i)
      {
	ret = ret && lw6srv_init (backend[i], listener);
      }
  }

  LW6SYS_TEST_FUNCTION_END;
  return ret;
}

static int
test_quit (lw6srv_backend_t ** backend)
{
  int ret = 1;
  LW6SYS_TEST_FUNCTION_BEGIN;

  {
    int i;

    for (i = 0; i < TEST_NB_BACKENDS; ++i)
      {
	lw6srv_quit (backend[i]);
      }
  }

  LW6SYS_TEST_FUNCTION_END;
  return ret;
}

int
lw6srv_test ()
{
  int ret = 0;
  lw6srv_backend_t *backend[TEST_NB_BACKENDS];
  lw6srv_listener_t *listener = NULL;
  int argc = TEST_ARGC;
  char *argv[TEST_ARGC] = { TEST_ARGV0 };

  if (lw6sys_false ())
    {
      /*
       * Just to make sure most functions are stuffed in the binary
       */
      lw6sys_test ();
      lw6cfg_test ();
      lw6net_test ();
    }

  backend[0] = lw6srv_create_backend (argc, argv, "tcpd");
  backend[1] = lw6srv_create_backend (argc, argv, "udpd");
  backend[2] = lw6srv_create_backend (argc, argv, "httpd");

  {
    ret = 0;
    if (backend[0] && backend[1] && backend[2])
      {
	listener =
	  lw6srv_start (LW6NET_ADDRESS_LOOPBACK, LW6NET_DEFAULT_PORT);
	if (listener)
	  {
	    ret = test_init (backend, listener) && test_quit (backend);
	    lw6srv_stop (listener);
	  }
	lw6srv_destroy_backend (backend[0]);
	lw6srv_destroy_backend (backend[1]);
	lw6srv_destroy_backend (backend[2]);
      }
  }

  return ret;
}
