/*
  Liquid War 6 is a unique multiplayer wargame.
  Copyright (C)  2005, 2006, 2007, 2008, 2009  Christian Mauduit <ufoot@ufoot.org>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.
  

  Liquid War 6 homepage : http://www.gnu.org/software/liquidwar6/
  Contact author        : ufoot@ufoot.org
*/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <math.h>

#include "../../mod-gl.h"
#include "gl-cylinder-internal.h"

/*
 * OpenGL wizardry, to prepare view parameters.
 */
static void
prepare_view (mod_gl_utils_context_t * utils_context,
	      _mod_gl_menu_cylinder_context_t * cylinder_context)
{
  glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
  glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);
  glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_CLAMP);
  glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_CLAMP);
}

static void
draw_cylinder (mod_gl_utils_context_t * utils_context,
	       _mod_gl_menu_cylinder_context_t * cylinder_context)
{
  GLUquadricObj *cyl;

  cyl = gluNewQuadric ();
  if (cyl != NULL)
    {
      float radius;
      float cyl_height;
      int slices;
      int stacks;
      float y;

      gluQuadricTexture (cyl, GL_TRUE);

      radius = cylinder_context->const_data.progress_radius;
      cyl_height =
	cylinder_context->const_data.progress_cyl_height *
	((float) utils_context->screen.width) /
	((float) utils_context->screen.height);
      y = cylinder_context->const_data.progress_offset;
      slices = cylinder_context->const_data.slices_min;
      stacks = cylinder_context->const_data.stacks;

      glMatrixMode (GL_MODELVIEW);
      glPushMatrix ();
      glLoadIdentity ();
      glTranslatef (-cyl_height / 2.0f, 0.0f, -1.0f);
      glRotatef (90.0f, 0.0f, 1.0f, 0.0f);
      glTranslatef (0.0f, y, 0.0f);
      gluCylinder (cyl, radius, radius, cyl_height, slices, stacks);

      glMatrixMode (GL_MODELVIEW);
      glPopMatrix ();

      gluDeleteQuadric (cyl);
    }
  else
    {
      lw6sys_log (LW6SYS_LOG_WARNING, _("unable to create quadric"));
    }
}

static void
draw_cylinder_with_color (mod_gl_utils_context_t * utils_context,
			  _mod_gl_menu_cylinder_context_t *
			  cylinder_context, lw6gui_look_t * look,
			  float progress)
{
  lw6sys_color_8_t done;
  lw6sys_color_8_t todo;
  SDL_Color sdl_done;
  SDL_Color sdl_todo;
  u_int32_t i_done;
  u_int32_t i_todo;
  SDL_Surface *surface = NULL;
  GLuint texture;
  int limit;

  done = look->style.menu_color_default.fg;
  todo = look->style.menu_color_default.bg;
  sdl_done = mod_gl_utils_color_8_to_sdl (done);
  sdl_todo = mod_gl_utils_color_8_to_sdl (todo);
  i_done = lw6sys_color_8_to_i (done);
  i_todo = lw6sys_color_8_to_i (todo);

  surface =
    mod_gl_utils_create_surface (utils_context, MOD_GL_UTILS_MENU_TEXTURE_W,
				 MOD_GL_UTILS_MENU_TEXTURE_H);
  if (surface)
    {
      mod_gl_utils_clear_surface_with_color (surface, sdl_todo);
      limit = progress * (MOD_GL_UTILS_MENU_TEXTURE_W - 1);
      limit = lw6sys_min (limit, MOD_GL_UTILS_MENU_TEXTURE_W - 1);
      limit = lw6sys_max (limit, 0);
      mod_gl_utils_draw_rectfill (surface, 0, 0, limit,
				  MOD_GL_UTILS_MENU_TEXTURE_H - 1, i_done);
      mod_gl_utils_draw_rectfill (surface, limit, 0,
				  MOD_GL_UTILS_MENU_TEXTURE_W - 1,
				  MOD_GL_UTILS_MENU_TEXTURE_H - 1, i_todo);
      texture = mod_gl_utils_surface2texture (utils_context, surface);
      if (texture)
	{
	  glEnable (GL_TEXTURE_2D);
	  glColor3f (1.0f, 1.0f, 1.0f);
	  glBindTexture (GL_TEXTURE_2D, texture);

	  glMatrixMode (GL_TEXTURE);
	  glPushMatrix ();
	  glLoadIdentity ();
	  glScalef (1.0f, -1.0f, 1.0f);
	  glTranslatef (0.0f,
			-0.25f + cylinder_context->const_data.rotate_offset,
			0.0f);
	  glRotatef (-90.0f, 0.0f, 0.0f, 1.0f);

	  draw_cylinder (utils_context, cylinder_context);
	  glMatrixMode (GL_TEXTURE);
	  glPopMatrix ();
	  mod_gl_utils_schedule_delete_texture (utils_context, texture);
	}

      mod_gl_utils_delete_surface (utils_context, surface);
    }
}

void
_mod_gl_menu_cylinder_draw_progress (mod_gl_utils_context_t * utils_context,
				     _mod_gl_menu_cylinder_context_t *
				     cylinder_context, lw6gui_look_t * look,
				     float progress)
{
  mod_gl_utils_set_render_mode_3d_menu (utils_context);
  prepare_view (utils_context, cylinder_context);
  draw_cylinder_with_color (utils_context, cylinder_context, look, progress);
}
