/*
  Liquid War 6 is a unique multiplayer wargame.
  Copyright (C)  2005, 2006, 2007, 2008, 2009  Christian Mauduit <ufoot@ufoot.org>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.
  

  Liquid War 6 homepage : http://www.gnu.org/software/liquidwar6/
  Contact author        : ufoot@ufoot.org
*/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "../../gfx.h"
#include "gl-utils.h"
#include "gl-utils-internal.h"

#define DEFAULT_LOW_WIDTH 320
#define DEFAULT_LOW_HEIGHT 200
#define DEFAULT_BEST_WIDTH 800
#define DEFAULT_BEST_HEIGHT 600
#define DEFAULT_HIGH_WIDTH 1600
#define DEFAULT_HIGH_HEIGHT 1200
#define DEFAULT_BPP 24

void
mod_gl_utils_get_low_resolution (mod_gl_utils_context_t *
				 utils_context, int *width, int *height)
{
  SDL_Rect **modes = NULL;
  int i = 0;

  (*width) = DEFAULT_LOW_WIDTH;
  (*height) = DEFAULT_LOW_HEIGHT;

  modes = SDL_ListModes (NULL, SDL_OPENGL | SDL_FULLSCREEN);
  if (modes)
    {
      for (i = 0; modes[i]; ++i)
	{
	  (*width) = modes[i]->w;
	  (*height) = modes[i]->h;
	}
    }
}

void
mod_gl_utils_get_standard_resolution (mod_gl_utils_context_t *
				      utils_context, int *width, int *height)
{
  mod_gl_utils_find_closest_resolution (utils_context, width, height,
					DEFAULT_BEST_WIDTH,
					DEFAULT_BEST_HEIGHT);
}

void
mod_gl_utils_get_high_resolution (mod_gl_utils_context_t *
				  utils_context, int *width, int *height)
{
  SDL_Rect **modes = NULL;

  (*width) = DEFAULT_HIGH_WIDTH;
  (*height) = DEFAULT_HIGH_HEIGHT;

  modes = SDL_ListModes (NULL, SDL_OPENGL | SDL_FULLSCREEN);
  if (modes && modes[0])
    {
      (*width) = modes[0]->w;
      (*height) = modes[0]->h;
    }
}

void
mod_gl_utils_find_closest_resolution (mod_gl_utils_context_t *
				      utils_context, int *closest_width,
				      int *closest_height, int wished_width,
				      int wished_height)
{
  SDL_Rect **modes = NULL;
  int i = 0;
  lw6sys_list_t *mode_list;
  lw6sys_whd_t *whd;
  lw6sys_whd_t closest;
  lw6sys_whd_t wished;

  (*closest_width) = wished_width;
  (*closest_height) = wished_height;

  modes = SDL_ListModes (NULL, SDL_OPENGL | SDL_FULLSCREEN);
  if (modes)
    {
      mode_list = lw6sys_list_new (lw6sys_free_callback);
      if (mode_list)
	{
	  for (i = 0; modes[i]; ++i)
	    {
	      whd = (lw6sys_whd_t *) LW6SYS_MALLOC (sizeof (lw6sys_whd_t));
	      if (whd)
		{
		  whd->w = modes[i]->w;
		  whd->h = modes[i]->h;
		  whd->d = DEFAULT_BPP;
		  lw6sys_lifo_push (&mode_list, whd);
		}
	    }
	  wished.w = wished_width;
	  wished.h = wished_height;
	  wished.d = DEFAULT_BPP;

	  lw6gui_resolution_find_closest (&closest, &wished, mode_list);

	  (*closest_width) = closest.w;
	  (*closest_height) = closest.h;

	  lw6sys_list_free (mode_list);
	}
    }
}
