/*
  Liquid War 6 is a unique multiplayer wargame.
  Copyright (C)  2005, 2006, 2007, 2008, 2009  Christian Mauduit <ufoot@ufoot.org>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.
  

  Liquid War 6 homepage : http://www.gnu.org/software/liquidwar6/
  Contact author        : ufoot@ufoot.org
*/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "gl-utils.h"
#include "gl-utils-internal.h"

void
mod_gl_utils_viewport_calc_view_area (mod_gl_utils_context_t *
				      utils_context, int *view_x,
				      int *view_y, int *view_w, int *view_h)
{
  (*view_x) =
    utils_context->screen.width * utils_context->const_data.viewport_x;
  (*view_y) =
    utils_context->screen.height * utils_context->const_data.viewport_y;
  (*view_w) =
    utils_context->screen.width * utils_context->const_data.viewport_w;
  (*view_h) =
    utils_context->screen.height * utils_context->const_data.viewport_h;
  lw6sys_log (LW6SYS_LOG_DEBUG, _("viewport %d,%d %dx%d"), *view_x, *view_y,
	      *view_w, *view_h);
}

void
mod_gl_utils_viewport_calc_map_area (mod_gl_utils_context_t * utils_context,
				     float *map_x1, float *map_y1,
				     float *map_x2, float *map_y2,
				     int main_cursor_x, int main_cursor_y,
				     int shape_w, int shape_h,
				     lw6gui_look_t * look)
{
  int view_x, view_y, view_w, view_h;
  float map_w, map_h;
  float map_ratio;
  float view_ratio;
  float zoom;

  shape_w = lw6sys_max (shape_w, 1);
  shape_h = lw6sys_max (shape_h, 1);

  mod_gl_utils_viewport_calc_view_area (utils_context, &view_x, &view_y,
					&view_w, &view_h);

  map_ratio = ((float) shape_w) / ((float) shape_h);
  view_ratio = ((float) view_w) / ((float) view_h);

  if (look->style.keep_ratio)
    {
      if (map_ratio > view_ratio)
	{
	  map_w = view_w;
	  map_h = view_h * view_ratio / map_ratio;
	}
      else
	{
	  map_w = view_w * map_ratio / view_ratio;
	  map_h = view_h;
	}
    }
  else
    {
      map_w = view_w;
      map_h = view_h;
    }

  zoom = look->dynamic_zoom * look->style.zoom;
  map_w *= zoom;
  map_h *= zoom;

  (*map_x1) = view_x;
  (*map_y1) = view_y;

  if (map_w < view_w)
    {
      (*map_x1) = view_x + (view_w - map_w) / 2.0f;
    }
  else if (map_w > view_w)
    {
      (*map_x1) =
	view_x + (view_w - map_w) / 2.0f - (main_cursor_x -
					    shape_w / 2) * (map_w / shape_w);
      if ((*map_x1) + map_w < view_x + view_w)
	{
	  lw6sys_log (LW6SYS_LOG_DEBUG, _("x correct 1 %0.0f"), *map_x1);
	  (*map_x1) = view_x + view_w - map_w;
	}
      if ((*map_x1) > view_x)
	{
	  lw6sys_log (LW6SYS_LOG_DEBUG, _("x correct 2 %0.0f"), *map_x1);
	  (*map_x1) = view_x;
	}
    }

  if (map_h < view_h)
    {
      (*map_y1) = view_y + (view_h - map_h) / 2.0f;
    }
  else if (map_h > view_h)
    {
      (*map_y1) =
	view_y + (view_h - map_h) / 2.0f - (main_cursor_y -
					    shape_h / 2) * (map_h / shape_h);
      if ((*map_y1) + map_h < view_y + view_h)
	{
	  lw6sys_log (LW6SYS_LOG_DEBUG, _("y correct 1 %0.0f"), *map_y1);
	  (*map_y1) = view_y + view_h - map_h;
	}
      if ((*map_y1) > view_y)
	{
	  lw6sys_log (LW6SYS_LOG_DEBUG, _("y correct 2 %0.0f"), *map_y1);
	  (*map_y1) = view_y;
	}
    }

  (*map_x2) = (*map_x1) + map_w;
  (*map_y2) = (*map_y1) + map_h;
  lw6sys_log (LW6SYS_LOG_DEBUG, _("map_area %0.0f,%0.0f %0.0f,%0.0f"),
	      *map_x1, *map_y1, *map_x2, *map_y2);
}

void
mod_gl_utils_viewport_calc_map_pos (mod_gl_utils_context_t * utils_context,
				    float *map_x, float *map_y,
				    int pos_x, int pos_y, int main_cursor_x,
				    int main_cursor_y, int shape_w,
				    int shape_h, lw6gui_look_t * look)
{
  float map_x1 = 0.0f, map_x2 = 0.0f, map_y1 = 0.0f, map_y2 = 0.0f;

  mod_gl_utils_viewport_calc_map_area (utils_context, &map_x1, &map_y1,
				       &map_x2, &map_y2, main_cursor_x,
				       main_cursor_y, shape_w, shape_h, look);

  *map_x = map_x1 + (pos_x * (map_x2 - map_x1)) / shape_w;
  *map_y = map_y1 + (pos_y * (map_y2 - map_y1)) / shape_h;
}
