/*
  Liquid War 6 is a unique multiplayer wargame.
  Copyright (C)  2005, 2006, 2007, 2008, 2009  Christian Mauduit <ufoot@ufoot.org>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.
  

  Liquid War 6 homepage : http://www.gnu.org/software/liquidwar6/
  Contact author        : ufoot@ufoot.org
*/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <string.h>
#include <GL/glu.h>

#include "../../../gfx.h"
#include "gl-flat.h"
#include "gl-flat-internal.h"

int
_mod_gl_view_flat_game_context_init (mod_gl_utils_context_t *
				     utils_context,
				     _mod_gl_view_flat_context_t *
				     flat_context,
				     _mod_gl_view_flat_game_context_t *
				     game_context,
				     lw6gui_look_t * look,
				     lw6map_level_t * level,
				     lw6ker_game_state_t * game_state)
{
  int ret = 0;

  ret =
    _mod_gl_view_flat_game_context_init_map (utils_context, flat_context,
					     &(game_context->map), level)
    && _mod_gl_view_flat_game_context_init_armies (utils_context,
						   flat_context,
						   &(game_context->armies),
						   look, game_state);

  return ret;
}

int
_mod_gl_view_flat_game_context_init_map (mod_gl_utils_context_t *
					 utils_context,
					 _mod_gl_view_flat_context_t *
					 flat_context,
					 _mod_gl_view_flat_game_context_map_t
					 * game_context_map,
					 lw6map_level_t * level)
{
  int ret = 0;

  ret = 1;

  mod_gl_utils_surface_array_t surface_array;

  memset (&surface_array, 0, sizeof (mod_gl_utils_surface_array_t));

  ret = ret && mod_gl_utils_surface_array_init_from_map (utils_context,
							 &surface_array,
							 level,
							 flat_context->
							 const_data.
							 tile_size_map);
  if (ret)
    {
      ret = mod_gl_utils_texture_array_init (utils_context,
					     &
					     (game_context_map->
					      map_texture_array),
					     level->texture.w,
					     level->texture.h,
					     flat_context->const_data.
					     tile_size_map);
      if (ret)
	{
	  mod_gl_utils_texture_array_update (utils_context,
					     &
					     (game_context_map->
					      map_texture_array),
					     &surface_array);
	}
      mod_gl_utils_surface_array_clear (utils_context, &surface_array);
    }

  game_context_map->level = level;
  game_context_map->level_id = level->id;

  if (!ret)
    {

      lw6sys_log (LW6SYS_LOG_WARNING,
		  _("unable to init game_context (map) for flat backend"));
    }

  return ret;
}

int
_mod_gl_view_flat_game_context_init_armies (mod_gl_utils_context_t *
					    utils_context,
					    _mod_gl_view_flat_context_t *
					    flat_context,
					    _mod_gl_view_flat_game_context_armies_t
					    * game_context_armies,
					    lw6gui_look_t * look,
					    lw6ker_game_state_t * game_state)
{
  int ret = 0;
  ret = 1;

  ret = ret
    && mod_gl_utils_surface_array_init (utils_context,
					&
					(game_context_armies->
					 armies_surface_array),
					game_state->map_state.shape.w,
					game_state->map_state.shape.h,
					flat_context->const_data.
					tile_size_armies);

  ret = ret
    && mod_gl_utils_texture_array_init (utils_context,
					&
					(game_context_armies->
					 armies_texture_array),
					game_state->map_state.shape.w,
					game_state->map_state.shape.h,
					flat_context->const_data.
					tile_size_armies);

  game_context_armies->game_state = game_state;
  game_context_armies->game_state_id = game_state->id;

  if (!ret)
    {
      lw6sys_log (LW6SYS_LOG_WARNING,
		  _("unable to init game_context (armies) for flat backend"));
    }

  return ret;
}

void
_mod_gl_view_flat_game_context_clear (mod_gl_utils_context_t *
				      utils_context,
				      _mod_gl_view_flat_context_t *
				      flat_context,
				      _mod_gl_view_flat_game_context_t *
				      game_context)
{
  _mod_gl_view_flat_game_context_clear_map (utils_context, flat_context,
					    &(game_context->map));
  _mod_gl_view_flat_game_context_clear_armies (utils_context, flat_context,
					       &(game_context->armies));
}

void
_mod_gl_view_flat_game_context_clear_map (mod_gl_utils_context_t *
					  utils_context,
					  _mod_gl_view_flat_context_t *
					  flat_context,
					  _mod_gl_view_flat_game_context_map_t
					  * game_context_map)
{
  mod_gl_utils_texture_array_clear (utils_context,
				    &(game_context_map->map_texture_array));
  memset (game_context_map, 0, sizeof (_mod_gl_view_flat_game_context_map_t));
}

void
_mod_gl_view_flat_game_context_clear_armies (mod_gl_utils_context_t *
					     utils_context,
					     _mod_gl_view_flat_context_t *
					     flat_context,
					     _mod_gl_view_flat_game_context_armies_t
					     * game_context_armies)
{
  mod_gl_utils_surface_array_clear (utils_context,
				    &
				    (game_context_armies->
				     armies_surface_array));
  mod_gl_utils_texture_array_clear (utils_context,
				    &(game_context_armies->
				      armies_texture_array));

  memset (game_context_armies, 0,
	  sizeof (_mod_gl_view_flat_game_context_armies_t));
}

int
_mod_gl_view_flat_game_context_update (mod_gl_utils_context_t *
				       utils_context,
				       _mod_gl_view_flat_context_t *
				       flat_context,
				       _mod_gl_view_flat_game_context_t *
				       game_context,
				       lw6gui_look_t * look,
				       lw6map_level_t * level,
				       lw6ker_game_state_t * game_state)
{
  int ret = 0;

  ret =
    _mod_gl_view_flat_game_context_update_map (utils_context, flat_context,
					       &(game_context->map), level)
    && _mod_gl_view_flat_game_context_update_armies (utils_context,
						     flat_context,
						     &(game_context->armies),
						     look, game_state);

  return ret;
}

int
_mod_gl_view_flat_game_context_update_map (mod_gl_utils_context_t *
					   utils_context,
					   _mod_gl_view_flat_context_t *
					   flat_context,
					   _mod_gl_view_flat_game_context_map_t
					   * game_context_map,
					   lw6map_level_t * level)
{
  int ret = 0;

  if (game_context_map->level_id == level->id
      && game_context_map->level == level)
    {
      ret = 1;			// nothing to do, up to date
    }
  else
    {
      _mod_gl_view_flat_game_context_clear_map (utils_context,
						flat_context,
						game_context_map);
      ret =
	_mod_gl_view_flat_game_context_init_map (utils_context, flat_context,
						 game_context_map, level);
    }

  return ret;
}

int
_mod_gl_view_flat_game_context_update_armies (mod_gl_utils_context_t *
					      utils_context,
					      _mod_gl_view_flat_context_t *
					      flat_context,
					      _mod_gl_view_flat_game_context_armies_t
					      * game_context_armies,
					      lw6gui_look_t * look,
					      lw6ker_game_state_t *
					      game_state)
{
  int ret = 0;

  if (game_context_armies->game_state_id == game_state->id &&
      game_context_armies->game_state == game_state)
    {
      ret = 1;			// nothing to do, up to date
    }
  else
    {
      _mod_gl_view_flat_game_context_clear_armies (utils_context,
						   flat_context,
						   game_context_armies);
      ret =
	_mod_gl_view_flat_game_context_init_armies (utils_context,
						    flat_context,
						    game_context_armies,
						    look, game_state);
    }

  return ret;
}
