/*
  Liquid War 6 is a unique multiplayer wargame.
  Copyright (C)  2005, 2006, 2007, 2008, 2009  Christian Mauduit <ufoot@ufoot.org>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.


  Liquid War 6 homepage : http://www.gnu.org/software/liquidwar6/
  Contact author        : ufoot@ufoot.org
*/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "gui.h"

#define TEST_MENUITEM_LABEL1 "My Label"
#define TEST_MENUITEM_LABEL2 "My Label 2"
#define TEST_MENUITEM_LABEL3 "The third label"
#define TEST_MENUITEM_LABEL4 "From outer space"
#define TEST_MENUITEM_VALUE1 42
#define TEST_MENUITEM_VALUE2 421
#define TEST_MENUITEM_VALUE3 -1
#define TEST_MENUITEM_VALUE4 65535
#define TEST_MENUITEM_NOW 1234
#define TEST_MENU_TITLE1 "My Title"
#define TEST_MENU_TITLE2 "My Title 2"
#define TEST_MAX_DISPLAYED_ITEMS 2
#define TEST_RESOLUTION_WISHED_WIDTH 640
#define TEST_RESOLUTION_WISHED_HEIGHT 480
#define TEST_RESOLUTION_WISHED_BPP 24
#define TEST_RESOLUTION_AVAILABLE_1_WIDTH 400
#define TEST_RESOLUTION_AVAILABLE_1_HEIGHT 300
#define TEST_RESOLUTION_AVAILABLE_2_WIDTH 700
#define TEST_RESOLUTION_AVAILABLE_2_HEIGHT 525
#define TEST_RESOLUTION_AVAILABLE_3_WIDTH 1600
#define TEST_RESOLUTION_AVAILABLE_3_HEIGHT 1200

/*
 * Testing menuitemm
 */
static int
test_menuitem ()
{
  int ret = 1;
  LW6SYS_TEST_FUNCTION_BEGIN;

  {
    lw6gui_menuitem_t *menuitem = NULL;
    char *repr;

    menuitem =
      lw6gui_menuitem_new (TEST_MENUITEM_LABEL1, TEST_MENUITEM_VALUE1, 1, 0,
			   0);
    if (menuitem)
      {
	lw6gui_menuitem_set_label (menuitem, TEST_MENUITEM_LABEL2,
				   TEST_MENUITEM_NOW);
	lw6gui_menuitem_set_value (menuitem, TEST_MENUITEM_VALUE2,
				   TEST_MENUITEM_NOW);
	lw6gui_menuitem_select (menuitem, TEST_MENUITEM_NOW);
	lw6gui_menuitem_unselect (menuitem, TEST_MENUITEM_NOW);
	repr = lw6gui_menuitem_repr (menuitem);
	if (repr)
	  {
	    lw6sys_log (LW6SYS_LOG_NOTICE, _("menuitem repr is %s"), repr);
	    LW6SYS_FREE (repr);
	  }
	else
	  {
	    ret = 0;
	  }
	lw6gui_menuitem_free (menuitem);
      }
    else
      {
	ret = 0;
      }
  }

  LW6SYS_TEST_FUNCTION_END;
  return ret;
}

/*
 * Testing menu
 */
static int
test_menu ()
{
  int ret = 1;
  LW6SYS_TEST_FUNCTION_BEGIN;

  {
    lw6gui_menu_t *menu = NULL;
    char *repr;

    menu = lw6gui_menu_new (TEST_MENU_TITLE1);
    if (menu)
      {
	lw6gui_menu_set_title (menu, TEST_MENU_TITLE2);
	repr = lw6gui_menu_repr (menu);
	if (repr)
	  {
	    lw6sys_log (LW6SYS_LOG_NOTICE, _("menu repr is %s"), repr);
	    LW6SYS_FREE (repr);
	  }
	else
	  {
	    ret = 0;
	  }
	lw6gui_menu_free (menu);
      }
    else
      {
	ret = 0;
      }
  }

  {
    lw6gui_menu_t *menu = NULL;
    lw6gui_menuitem_t *menuitem1 = NULL;
    lw6gui_menuitem_t *menuitem2 = NULL;
    lw6gui_menuitem_t *menuitem3 = NULL;
    char *repr;
    int menuitem_id;

    menu = lw6gui_menu_new (TEST_MENU_TITLE1);
    if (menu)
      {
	lw6gui_menu_set_title (menu, TEST_MENU_TITLE2);

	menuitem1 =
	  lw6gui_menuitem_new (TEST_MENUITEM_LABEL1, TEST_MENUITEM_VALUE1, 1,
			       0, 0);
	if (menuitem1)
	  {
	    menuitem2 =
	      lw6gui_menuitem_new (TEST_MENUITEM_LABEL2, TEST_MENUITEM_VALUE2,
				   1, 0, 0);
	    if (menuitem2)
	      {
		menuitem3 =
		  lw6gui_menuitem_new (TEST_MENUITEM_LABEL3,
				       TEST_MENUITEM_VALUE3, 1, 0, 0);
		if (menuitem3)
		  {
		    lw6gui_menu_append (menu, menuitem1, 0);
		    lw6gui_menu_insert (menu, menuitem2, 0, 0);
		    lw6gui_menu_insert (menu, menuitem3, 1, 0);
		    lw6gui_menu_select (menu, 2, 0);
		    lw6gui_menu_remove (menu, 0, 0);
		    lw6gui_menu_select (menu, 0, 0);
		    menuitem_id =
		      lw6gui_menu_append_for_id_use (menu,
						     TEST_MENUITEM_LABEL4,
						     TEST_MENUITEM_VALUE4, 1,
						     0, 0, 0);
		    if (menuitem_id)
		      {
			lw6gui_menu_sync_using_id (menu, menuitem_id,
						   TEST_MENUITEM_LABEL1,
						   TEST_MENUITEM_VALUE1, 1, 0,
						   0, 0);
			lw6gui_menu_remove_using_id (menu, menuitem_id, 0);
		      }
		    lw6gui_menu_update_display_range (menu,
						      TEST_MAX_DISPLAYED_ITEMS);
		    lw6gui_menu_center (menu, 1, TEST_MAX_DISPLAYED_ITEMS);
		    repr = lw6gui_menu_repr (menu);
		    if (repr)
		      {
			lw6sys_log (LW6SYS_LOG_NOTICE, _("menu repr is %s"),
				    repr);
			LW6SYS_FREE (repr);
		      }
		    else
		      {
			ret = 0;
		      }
		  }
		else
		  {
		    ret = 0;
		  }
	      }
	    else
	      {
		ret = 0;
	      }
	  }
	else
	  {
	    ret = 0;
	  }
	lw6gui_menu_free (menu);
      }
    else
      {
	ret = 0;
      }
  }

  LW6SYS_TEST_FUNCTION_END;
  return ret;
}

/*
 * Testing menu
 */
static int
test_resolution ()
{
  int ret = 1;
  LW6SYS_TEST_FUNCTION_BEGIN;

  {
    lw6sys_list_t *available = NULL;
    lw6sys_whd_t wished =
      { TEST_RESOLUTION_WISHED_WIDTH, TEST_RESOLUTION_WISHED_HEIGHT,
      TEST_RESOLUTION_WISHED_BPP
    };
    lw6sys_whd_t closest;
    lw6sys_whd_t available_1 = { TEST_RESOLUTION_AVAILABLE_1_WIDTH,
      TEST_RESOLUTION_AVAILABLE_1_HEIGHT, TEST_RESOLUTION_WISHED_BPP
    };
    lw6sys_whd_t available_2 = { TEST_RESOLUTION_AVAILABLE_2_WIDTH,
      TEST_RESOLUTION_AVAILABLE_2_HEIGHT, TEST_RESOLUTION_WISHED_BPP
    };
    lw6sys_whd_t available_3 = { TEST_RESOLUTION_AVAILABLE_3_WIDTH,
      TEST_RESOLUTION_AVAILABLE_3_HEIGHT, TEST_RESOLUTION_WISHED_BPP
    };

    available = lw6sys_list_new (NULL);

    if (available)
      {
	lw6sys_lifo_push (&available, &available_1);
	lw6sys_lifo_push (&available, &available_2);
	lw6sys_lifo_push (&available, &available_3);

	lw6gui_resolution_find_closest (&closest, &wished, available);
	lw6sys_log (LW6SYS_LOG_NOTICE,
		    _("closest resolution to %dx%d is %dx%d"), wished.w,
		    wished.h, closest.w, closest.h);

	lw6sys_list_free (available);
      }
    else
      {
	ret = 0;
      }
  }

  LW6SYS_TEST_FUNCTION_END;
  return ret;
}

/**
 * lw6gui_test
 *
 * Run tests in the gui module.
 * 
 * Return value: 1 if successfull, 0 if failed.
 */
int
lw6gui_test ()
{
  int ret = 0;

  if (lw6sys_false ())
    {
      /*
       * Just to make sure most functions are stuffed in the binary
       */
      lw6sys_test ();
      lw6hlp_test ();
      lw6cfg_test ();
      lw6map_test ();
      lw6ldr_test ();
    }

  ret = test_menuitem () && test_menu () && test_resolution ();

  return ret;
}
