/*
  Liquid War 6 is a unique multiplayer wargame.
  Copyright (C)  2005, 2006, 2007, 2008, 2009  Christian Mauduit <ufoot@ufoot.org>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.
  

  Liquid War 6 homepage : http://www.gnu.org/software/liquidwar6/
  Contact author        : ufoot@ufoot.org
*/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <string.h>

#include "hlp.h"
#include "hlp-internal.h"

static char *
about (lw6hlp_type_t * type, char *keyword)
{
  char *ret = NULL;
  _lw6hlp_reference_entry_t *entry = NULL;

  entry = _lw6hlp_reference_get_entry (keyword);
  if (entry)
    {
      if (type)
	{
	  *type = entry->type;
	}
      ret = entry->about;
    }

  return ret;
}

/**
 * lw6hlp_is_documented
 *
 * @keyword: the keyword we want to check out
 *
 * Checks wether a given keyword is documented or not.
 *
 * Return value: 1 if documented, 0 if not.
 */
int
lw6hlp_is_documented (char *keyword)
{
  int ret = 0;

  ret = (about (NULL, keyword) != NULL);

  return ret;
}

/**
 * lw6hlp_about
 *
 * @type: the type of the data associated to the keyword, will be written
 * @keyword: the keyword we want help about
 *
 * Returns the documentation string associated to a keyword. The keyword
 * might be a command-line option, a Guile function, an XML file entry.
 * Raises a warning if the keyword is undocumented, but never returns
 * NULL, you can use the returned value without checking it. String
 * is localized if a translation is available. It's safe to call this
 * function with type being NULL.
 *
 * Return value: a help string, never NULL, must not be freed.
 *   Additionnally, type will be updated.
 */
char *
lw6hlp_about (lw6hlp_type_t * type, char *keyword)
{
  char *ret = NULL;

  ret = about (type, keyword);

  if (!ret)
    {
      lw6sys_log (LW6SYS_LOG_INFO, _("keyword '%s' is not documented"),
		  keyword);
      if (type)
	{
	  *type = LW6HLP_TYPE_VOID;
	}
      ret = _(" Not documented.");
    }

  return ret;
}

/**
 * lw6hlp_get_type
 *
 * @keyword: the keyword we want the type of
 *
 * Returns the type of a keyword. Calls lw6hlp_about internally.
 *
 * Return value: the type, might be LW6HLP_TYPE_VOID.
 */
lw6hlp_type_t
lw6hlp_get_type (char *keyword)
{
  lw6hlp_type_t ret = LW6HLP_TYPE_VOID;

  lw6hlp_about (&ret, keyword);

  return ret;
}
