/*
  Liquid War 6 is a unique multiplayer wargame.
  Copyright (C)  2005, 2006, 2007, 2008, 2009  Christian Mauduit <ufoot@ufoot.org>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.


  Liquid War 6 homepage : http://www.gnu.org/software/liquidwar6/
  Contact author        : ufoot@ufoot.org
*/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "map.h"

static int
rectangle (lw6map_layer_t * layer, int width, int height)
{
  int ret = 0;
  int x, y;

  layer->shape.w = width;
  layer->shape.h = height;
  layer->shape.d = 1;		// allways 1
  layer->data =
    (unsigned char *) LW6SYS_CALLOC (layer->shape.w * layer->shape.h *
				     sizeof (unsigned char));

  if (layer->data)
    {
      for (y = 0; y < layer->shape.h; ++y)
	{
	  for (x = 0; x < layer->shape.w; ++x)
	    {
	      lw6map_layer_set (layer, x, y, 0);
	    }
	}

      for (y = 1; y < layer->shape.h - 1; ++y)
	{
	  for (x = 1; x < layer->shape.w - 1; ++x)
	    {
	      lw6map_layer_set (layer, x, y, 1);
	    }
	}
      ret = 1;
    }

  return ret;
}

void
lw6map_layer_defaults (lw6map_layer_t * layer, int w, int h)
{
  lw6map_layer_clear (layer);

  if (!rectangle (layer, w, h))
    {
      lw6sys_log (LW6SYS_LOG_WARNING,
		  _("unable to construct default map layer"));
      layer->shape.w = 0;
      layer->shape.h = 0;
      layer->shape.d = 0;
    }
}

void
lw6map_layer_clear (lw6map_layer_t * layer)
{
  if (layer->data)
    {
      LW6SYS_FREE (layer->data);
    }

  memset (layer, 0, sizeof (lw6map_layer_t));
}
