/*
  Liquid War 6 is a unique multiplayer wargame.
  Copyright (C)  2005, 2006, 2007, 2008, 2009  Christian Mauduit <ufoot@ufoot.org>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.


  Liquid War 6 homepage : http://www.gnu.org/software/liquidwar6/
  Contact author        : ufoot@ufoot.org
*/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "../../mod-gl.h"
#include "gl-floating-internal.h"

int
_mod_gl_hud_floating_context_init (mod_gl_utils_context_t *
				   utils_context,
				   _mod_gl_hud_floating_context_t
				   * floating_context)
{
  int ret = 0;

  ret = 1;

  return ret;
}

static int
_update_clock (mod_gl_utils_context_t *
	       utils_context,
	       _mod_gl_hud_floating_context_t * floating_context)
{
  int ret = 0;

  int time_left;
  int hours;
  int minutes;
  int seconds;
  char *text = NULL;
  SDL_Surface *surface_bg = NULL;
  SDL_Surface *surface_fg = NULL;
  SDL_Color color_bg;
  SDL_Color color_fg;

  time_left = lw6ker_game_state_get_time_left (floating_context->game_state);
  hours = time_left / 3600;
  minutes = (time_left / 60) % 60;
  seconds = time_left % 60;
  text = lw6sys_new_sprintf (_("%0d:%02d:%02d"), hours, minutes, seconds);
  if (text)
    {
      if ((!floating_context->clock.text) ||
	  (!floating_context->clock.texture_bg) ||
	  (!floating_context->clock.texture_fg) ||
	  (floating_context->clock.text
	   && strcmp (text, floating_context->clock.text))
	  ||
	  !lw6map_color_is_same (&
				 (floating_context->look->
				  style.hud_color_text),
				 &(floating_context->clock.color_text)))
	{
	  _mod_gl_hud_floating_context_clear_hud_clock (utils_context,
							floating_context);
	  floating_context->clock.color_text =
	    floating_context->look->style.hud_color_text;
	  floating_context->clock.text = text;

	  color_bg =
	    mod_gl_utils_color_8_to_sdl (floating_context->look->
					 style.hud_color_text.bg);
	  color_fg =
	    mod_gl_utils_color_8_to_sdl (floating_context->look->
					 style.hud_color_text.fg);

	  surface_bg =
	    mod_gl_utils_blended_text_surface (utils_context,
					       utils_context->font_data.menu,
					       color_bg, text);
	  if (surface_bg)
	    {
	      floating_context->clock.texture_bg =
		mod_gl_utils_surface2texture (utils_context, surface_bg, 0);
	      floating_context->clock.texture_w = surface_bg->w;
	      floating_context->clock.texture_h = surface_bg->h;
	      mod_gl_utils_delete_surface (utils_context, surface_bg);
	    }
	  surface_fg =
	    mod_gl_utils_blended_text_surface (utils_context,
					       utils_context->font_data.menu,
					       color_fg, text);
	  if (surface_fg)
	    {
	      floating_context->clock.texture_fg =
		mod_gl_utils_surface2texture (utils_context, surface_fg, 0);
	      floating_context->clock.texture_w = surface_fg->w;
	      floating_context->clock.texture_h = surface_fg->h;
	      mod_gl_utils_delete_surface (utils_context, surface_fg);
	    }
	}
      else
	{
	  LW6SYS_FREE (text);
	}
    }

  return ret;
}

static int
_update_gauge_text (mod_gl_utils_context_t *
		    utils_context,
		    _mod_gl_hud_floating_context_t * floating_context, int i)
{
  int ret = 1;
  _mod_gl_hud_floating_gauge_text_t *gauge_text =
    &(floating_context->gauges.gauge_texts[i]);
  char *text = NULL;
  int team_color;
  int percent;
  int frags;
  SDL_Surface *surface_bg;
  SDL_Surface *surface_fg;
  SDL_Color color_bg;
  SDL_Color color_fg;
  lw6map_color_couple_t color_text;
  int blink;

  /*
   * Colorization is done elsewhere so here we don't care about frame texture
   * and alive/dead textures, only text.
   */
  percent = floating_context->score_array.scores[i].fighters_percent;
  frags = floating_context->score_array.scores[i].frags;
  team_color = floating_context->score_array.scores[i].team_color;

  color_text.bg = floating_context->look->style.hud_color_text.bg;

  if (team_color >= 0)
    {
      color_text.fg =
	lw6sys_color_f_to_8 (&
			     (utils_context->team_color_map.team_colors_f
			      [team_color]));
    }
  else
    {
      color_text.fg = floating_context->look->style.hud_color_text.fg;
    }

  blink =
    lw6sys_math_blink (mod_gl_utils_timer_uptime (utils_context),
		       floating_context->const_data.gauge_blink_period);
  if (blink && floating_context->game_state
      && floating_context->game_state->game_struct->rules.respawn_team)
    {
      text = lw6sys_new_sprintf (_("%d"), frags);
    }
  else
    {
      text = lw6sys_new_sprintf (_("%d%%"), percent);
    }
  if (text)
    {
      if ((!gauge_text->text) ||
	  (!gauge_text->texture_text_bg) ||
	  (!gauge_text->texture_text_fg) ||
	  (gauge_text->text && strcmp (text, gauge_text->text))
	  || !lw6map_color_is_same (&color_text, &(gauge_text->color_text)))
	{
	  /*
	   * We don't reset everything, only text concerned items
	   */
	  if (gauge_text->text)
	    {
	      LW6SYS_FREE (gauge_text->text);
	      gauge_text->text = NULL;
	    }
	  if (gauge_text->texture_text_bg)
	    {
	      mod_gl_utils_delete_texture (utils_context,
					   gauge_text->texture_text_bg);
	      gauge_text->texture_text_bg = 0;
	    }
	  if (gauge_text->texture_text_fg)
	    {
	      mod_gl_utils_delete_texture (utils_context,
					   gauge_text->texture_text_fg);
	      gauge_text->texture_text_fg = 0;
	    }
	  gauge_text->text = text;
	  gauge_text->texture_text_w = 0;
	  gauge_text->texture_text_h = 0;
	  gauge_text->color_text = color_text;

	  color_bg = mod_gl_utils_color_8_to_sdl (color_text.bg);
	  color_fg = mod_gl_utils_color_8_to_sdl (color_text.fg);

	  surface_bg =
	    mod_gl_utils_blended_text_surface (utils_context,
					       utils_context->font_data.hud,
					       color_bg, text);
	  if (surface_bg)
	    {
	      gauge_text->texture_text_bg =
		mod_gl_utils_surface2texture (utils_context, surface_bg, 0);
	      gauge_text->texture_text_w = surface_bg->w;
	      gauge_text->texture_text_h = surface_bg->h;
	      mod_gl_utils_delete_surface (utils_context, surface_bg);
	    }
	  surface_fg =
	    mod_gl_utils_blended_text_surface (utils_context,
					       utils_context->font_data.hud,
					       color_fg, text);
	  if (surface_fg)
	    {
	      gauge_text->texture_text_fg =
		mod_gl_utils_surface2texture (utils_context, surface_fg, 0);
	      gauge_text->texture_text_w = surface_fg->w;
	      gauge_text->texture_text_h = surface_fg->h;
	      mod_gl_utils_delete_surface (utils_context, surface_fg);
	    }
	}
      else
	{
	  LW6SYS_FREE (text);
	}
    }

  return ret;
}

static int
_update_gauges (mod_gl_utils_context_t *
		utils_context,
		_mod_gl_hud_floating_context_t * floating_context)
{
  int ret = 1;
  int i;

  ret = ret
    && _mod_gl_hud_floating_colorize_gauges_if_needed (utils_context,
						       floating_context,
						       floating_context->
						       look);
  if (!floating_context->gauges.disk)
    {
      floating_context->gauges.disk = gluNewQuadric ();
      if (floating_context->gauges.disk)
	{
	  gluQuadricOrientation (floating_context->gauges.disk, GLU_OUTSIDE);
	  gluQuadricDrawStyle (floating_context->gauges.disk, GLU_FILL);
	  gluQuadricNormals (floating_context->gauges.disk, GLU_FLAT);
	}
      else
	{
	  ret = 0;
	}
    }

  for (i = 0; i < floating_context->score_array.nb_scores; ++i)
    {
      _update_gauge_text (utils_context, floating_context, i);
    }

  return ret;
}

int
_mod_gl_hud_floating_context_update_hud (mod_gl_utils_context_t *
					 utils_context,
					 _mod_gl_hud_floating_context_t
					 * floating_context,
					 lw6gui_look_t * look,
					 lw6ker_game_state_t * game_state,
					 lw6gui_main_cursor_t * main_cursor)
{
  int ret = 0;


  floating_context->look = look;
  floating_context->game_state = game_state;
  floating_context->main_cursor = main_cursor;
  lw6ker_score_array_update (&floating_context->score_array,
			     floating_context->game_state);

  ret = _update_clock (utils_context, floating_context) && ret;
  ret = _update_gauges (utils_context, floating_context) && ret;

  return ret;
}

int
_mod_gl_hud_floating_context_update_score (mod_gl_utils_context_t *
					   utils_context,
					   _mod_gl_hud_floating_context_t
					   * floating_context,
					   lw6gui_look_t * look,
					   lw6ker_game_state_t * game_state,
					   lw6gui_main_cursor_t * main_cursor)
{
  int ret = 0;


  floating_context->look = look;
  floating_context->game_state = game_state;
  floating_context->main_cursor = main_cursor;
  lw6ker_score_array_update (&floating_context->score_array,
			     floating_context->game_state);

  ret = 1;

  return ret;
}

int
_mod_gl_hud_floating_context_clear_hud_clock (mod_gl_utils_context_t *
					      utils_context,
					      _mod_gl_hud_floating_context_t
					      * floating_context)
{
  int ret = 0;

  if (floating_context->clock.text)
    {
      LW6SYS_FREE (floating_context->clock.text);
    }
  if (floating_context->clock.texture_bg)
    {
      mod_gl_utils_delete_texture (utils_context,
				   floating_context->clock.texture_bg);
    }
  if (floating_context->clock.texture_fg)
    {
      mod_gl_utils_delete_texture (utils_context,
				   floating_context->clock.texture_fg);
    }
  memset (&(floating_context->clock), 0,
	  sizeof (_mod_gl_hud_floating_clock_t));

  ret = 1;

  return ret;
}

int
_mod_gl_hud_floating_context_clear_hud_gauge_meter (mod_gl_utils_context_t *
						    utils_context,
						    _mod_gl_hud_floating_context_t
						    * floating_context,
						    int team_color)
{
  int ret = 0;
  _mod_gl_hud_floating_gauge_meter_t *gauge_meter =
    &(floating_context->gauges.gauge_meters[team_color]);

  if (gauge_meter->texture_alive)
    {
      mod_gl_utils_delete_texture (utils_context, gauge_meter->texture_alive);
      gauge_meter->texture_alive = 0;
    }
  if (gauge_meter->texture_dead)
    {
      mod_gl_utils_delete_texture (utils_context, gauge_meter->texture_dead);
      gauge_meter->texture_dead = 0;
    }

  ret = 1;

  return ret;
}

int
_mod_gl_hud_floating_context_clear_hud_gauge_text (mod_gl_utils_context_t *
						   utils_context,
						   _mod_gl_hud_floating_context_t
						   * floating_context, int i)
{
  int ret = 0;
  _mod_gl_hud_floating_gauge_text_t *gauge_text =
    &(floating_context->gauges.gauge_texts[i]);

  if (gauge_text->text)
    {
      LW6SYS_FREE (gauge_text->text);
      gauge_text->text = NULL;
    }
  if (gauge_text->texture_text_bg)
    {
      mod_gl_utils_delete_texture (utils_context,
				   gauge_text->texture_text_bg);
      gauge_text->texture_text_bg = 0;
    }
  if (gauge_text->texture_text_fg)
    {
      mod_gl_utils_delete_texture (utils_context,
				   gauge_text->texture_text_fg);
      gauge_text->texture_text_fg = 0;
    }

  ret = 1;

  return ret;
}

int
_mod_gl_hud_floating_context_clear_hud_gauges (mod_gl_utils_context_t *
					       utils_context,
					       _mod_gl_hud_floating_context_t
					       * floating_context)
{
  int ret = 0;
  int i;

  if (floating_context->gauges.texture_frame)
    {
      mod_gl_utils_delete_texture (utils_context,
				   floating_context->gauges.texture_frame);
      floating_context->gauges.texture_frame = 0;
    }
  for (i = 0; i < LW6MAP_NB_TEAM_COLORS; ++i)
    {
      _mod_gl_hud_floating_context_clear_hud_gauge_meter (utils_context,
							  floating_context,
							  i);
    }
  for (i = 0; i < LW6MAP_NB_TEAM_COLORS; ++i)
    {
      _mod_gl_hud_floating_context_clear_hud_gauge_text (utils_context,
							 floating_context, i);
    }
  if (floating_context->gauges.disk)
    {
      gluDeleteQuadric (floating_context->gauges.disk);
      floating_context->gauges.disk = NULL;
    }

  ret = 1;

  return ret;
}

int
_mod_gl_hud_floating_context_clear_hud (mod_gl_utils_context_t *
					utils_context,
					_mod_gl_hud_floating_context_t
					* floating_context)
{
  int ret = 0;

  ret =
    _mod_gl_hud_floating_context_clear_hud_clock (utils_context,
						  floating_context)
    && _mod_gl_hud_floating_context_clear_hud_gauges (utils_context,
						      floating_context);

  return ret;
}

int
_mod_gl_hud_floating_context_clear_score (mod_gl_utils_context_t *
					  utils_context,
					  _mod_gl_hud_floating_context_t
					  * floating_context)
{
  int ret = 0;

  ret = 1;

  return ret;
}

int
_mod_gl_hud_floating_context_clear (mod_gl_utils_context_t *
				    utils_context,
				    _mod_gl_hud_floating_context_t
				    * floating_context)
{
  int ret = 0;

  _mod_gl_hud_floating_context_clear_hud (utils_context, floating_context);
  _mod_gl_hud_floating_context_clear_score (utils_context, floating_context);

  ret = 1;

  return ret;
}
