/*
  Liquid War 6 is a unique multiplayer wargame.
  Copyright (C)  2005, 2006, 2007, 2008, 2009  Christian Mauduit <ufoot@ufoot.org>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.


  Liquid War 6 homepage : http://www.gnu.org/software/liquidwar6/
  Contact author        : ufoot@ufoot.org
*/

#ifndef LIQUIDWAR6GFX_MOD_GL_HUD_TACTICAL_INTERNAL_H
#define LIQUIDWAR6GFX_MOD_GL_HUD_TACTICAL_INTERNAL_H

#include "gl-tactical.h"

typedef struct _mod_gl_hud_tactical_image_data_s
{
  SDL_Surface *frame;
}
_mod_gl_hud_tactical_image_data_t;

typedef struct _mod_gl_hud_tactical_texture_data_s
{
  GLuint frame;
}
_mod_gl_hud_tactical_texture_data_t;

typedef struct _mod_gl_hud_tactical_const_data_s
{
  float viewport_x;
  float viewport_y;
  float viewport_w;
  float viewport_h;
}
_mod_gl_hud_tactical_const_data_t;

typedef struct _mod_gl_hud_tactical_context_s
{
  _mod_gl_hud_tactical_image_data_t image_data;
  _mod_gl_hud_tactical_texture_data_t texture_data;
  _mod_gl_hud_tactical_const_data_t const_data;
}
_mod_gl_hud_tactical_context_t;

/*
 * In display.c
 */
extern void _mod_gl_hud_tactical_display_hud (mod_gl_utils_context_t *
					      utils_context,
					      _mod_gl_hud_tactical_context_t
					      * tactical_context,
					      lw6gui_look_t * look,
					      lw6ker_game_state_t *
					      game_state,
					      lw6gui_main_cursor_t *
					      main_cursor);
extern void _mod_gl_hud_tactical_display_score (mod_gl_utils_context_t *
						utils_context,
						_mod_gl_hud_tactical_context_t
						* tactical_context,
						lw6gui_look_t * look,
						lw6ker_game_state_t *
						game_state,
						lw6gui_main_cursor_t *
						main_cursor);

/*
 * In data.c
 */
extern int _mod_gl_hud_tactical_load_data (mod_gl_utils_context_t *
					   utils_context,
					   _mod_gl_hud_tactical_context_t
					   * tactical_context);
extern void _mod_gl_hud_tactical_unload_data (mod_gl_utils_context_t *
					      utils_context,
					      _mod_gl_hud_tactical_context_t
					      * tactical_context);

/*
 * In setup.c
 */
extern _mod_gl_hud_tactical_context_t
  * _mod_gl_hud_tactical_init (mod_gl_utils_context_t * utils_context);
extern void _mod_gl_hud_tactical_quit (mod_gl_utils_context_t *
				       utils_context,
				       _mod_gl_hud_tactical_context_t *
				       tactical_context);

#endif
