/*
  Liquid War 6 is a unique multiplayer wargame.
  Copyright (C)  2005, 2006, 2007, 2008, 2009  Christian Mauduit <ufoot@ufoot.org>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.
  

  Liquid War 6 homepage : http://www.gnu.org/software/liquidwar6/
  Contact author        : ufoot@ufoot.org
*/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "../../../gfx.h"
#include "gl-flat.h"
#include "gl-flat-internal.h"

static void
_set_map_rules (mod_gl_utils_context_t * utils_context,
		_mod_gl_view_flat_context_t * flat_context)
{
  glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
  glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER,
		   GL_LINEAR_MIPMAP_LINEAR);
  glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_CLAMP_TO_EDGE);
  glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_CLAMP_TO_EDGE);
}

static void
_set_fighters_rules (mod_gl_utils_context_t * utils_context,
		     _mod_gl_view_flat_context_t * flat_context)
{
  // glTexParameteri useless herem set in mod_gl_utils_texture_update
  /*
     glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
     glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);
     glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_CLAMP_TO_EDGE);
     glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_CLAMP_TO_EDGE);
   */
}

static void
_set_cursor_rules (mod_gl_utils_context_t * utils_context,
		   _mod_gl_view_flat_context_t * flat_context)
{
  glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
  glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);
  glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_CLAMP_TO_EDGE);
  glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_CLAMP_TO_EDGE);
}

static void
_display_texture_array (mod_gl_utils_context_t * utils_context,
			_mod_gl_view_flat_context_t * flat_context,
			int texture_array_w,
			int texture_array_h,
			int shape_w,
			int shape_h,
			mod_gl_utils_texture_array_t * texture_array,
			int center_x, int center_y, lw6gui_look_t * look)
{
  float x1, y1, x2, y2, w, h, coef_x, coef_y;
  float texture_x1, texture_x2, texture_y1, texture_y2;
  float texture_w, texture_h, layout_w, layout_h;
  int n_x, n_y;
  int view_x, view_y, view_w, view_h;
  float min_x, min_y, max_x, max_y;

  x1 = flat_context->viewport.map_main.x1;
  y1 = flat_context->viewport.map_main.y1;
  x2 = flat_context->viewport.map_main.x2;
  y2 = flat_context->viewport.map_main.y2;

  w = x2 - x1;
  h = y2 - y1;
  coef_x = w / texture_array_w;
  coef_y = h / texture_array_h;

  view_x = flat_context->viewport.drawable.x1;
  view_y = flat_context->viewport.drawable.y1;
  view_w = flat_context->viewport.drawable.w;
  view_h = flat_context->viewport.drawable.h;

  min_x = view_x;
  min_y = view_y;
  max_x = view_x + view_w;
  max_y = view_y + view_h;

  if (texture_array->layout.n_w > 0)
    {
      for (n_x = 0; n_x < texture_array->layout.n_w; ++n_x)
	{
	  texture_array->layout.screen_x[n_x] =
	    x1 + (texture_array->layout.x0[n_x] + 1) * coef_x;
	}
      texture_array->layout.screen_x[texture_array->layout.n_w] =
	texture_array->layout.screen_x[texture_array->layout.n_w - 1] +
	(texture_array->layout.w[texture_array->layout.n_w - 1] - 2) * coef_x;
    }

  if (texture_array->layout.n_h > 0)
    {
      for (n_y = 0; n_y < texture_array->layout.n_h; ++n_y)
	{
	  texture_array->layout.screen_y[n_y] =
	    y1 + (texture_array->layout.y0[n_y] + 1) * coef_y;
	}
      texture_array->layout.screen_y[texture_array->layout.n_h] =
	texture_array->layout.screen_y[texture_array->layout.n_h - 1] +
	(texture_array->layout.h[texture_array->layout.n_h - 1] - 2) * coef_y;
    }

  for (n_y = 0; n_y < texture_array->layout.n_h; ++n_y)
    {
      for (n_x = 0; n_x < texture_array->layout.n_w; ++n_x)
	{
	  if (texture_array->layout.screen_x[n_x] > max_x ||
	      texture_array->layout.screen_y[n_y] > max_y ||
	      texture_array->layout.screen_x[n_x + 1] < min_x
	      || texture_array->layout.screen_y[n_y + 1] < min_y)
	    {
	      // skip texture, it's outside our screen...
	    }
	  else
	    {
	      layout_w = texture_array->layout.w[n_x];
	      layout_h = texture_array->layout.h[n_y];
	      texture_w = mod_gl_utils_power_of_two_ge (layout_w);
	      texture_h = mod_gl_utils_power_of_two_ge (layout_h);
	      texture_x1 = 1.0f / texture_w;
	      texture_y1 = 1.0f / texture_h;
	      texture_x2 = (layout_w - 1.0f) / texture_w;
	      texture_y2 = (layout_h - 1.0f) / texture_h;
	      mod_gl_utils_display_texture_with_filter (utils_context,
							mod_gl_utils_get_texture_array_texture
							(texture_array, n_x,
							 n_y),
							texture_array->layout.
							screen_x[n_x],
							texture_array->layout.
							screen_y[n_y],
							texture_array->layout.
							screen_x[n_x + 1],
							texture_array->layout.
							screen_y[n_y + 1],
							texture_x1,
							texture_y1,
							texture_x2,
							texture_y2,
							look->style.pixelize);
	    }
	}
    }
}

static void
_display_map_preview (mod_gl_utils_context_t * utils_context,
		      _mod_gl_view_flat_context_t * flat_context,
		      lw6gui_look_t * look, lw6map_level_t * level,
		      int center_x, int center_y)
{
  _set_map_rules (utils_context, flat_context);
  _display_texture_array (utils_context, flat_context,
			  flat_context->game_context.map.level->texture.w,
			  flat_context->game_context.map.level->texture.h,
			  flat_context->game_context.map.level->body.shape.w,
			  flat_context->game_context.map.level->body.shape.h,
			  &(flat_context->game_context.map.map_texture_array),
			  center_x, center_y, look);
}

void
_mod_gl_view_flat_display_preview (mod_gl_utils_context_t * utils_context,
				   _mod_gl_view_flat_context_t *
				   flat_context, lw6gui_look_t * look,
				   lw6map_level_t * level)
{
  if (utils_context && flat_context && level && level->texture.data)
    {
      _mod_gl_view_flat_game_context_update_map (utils_context,
						 flat_context,
						 &(flat_context->
						   game_context.map), look,
						 level);

      if (level->texture.has_alpha)
	{
	  mod_gl_utils_set_render_mode_2d_blend (utils_context);
	}
      else
	{
	  mod_gl_utils_set_render_mode_2d (utils_context);
	}

      glColor3f (1.0, 1.0, 1.0);
      glEnable (GL_TEXTURE_2D);	// for texture

      _mod_gl_view_flat_viewport_update_preview (utils_context,
						 flat_context, look, level);
      _display_map_preview (utils_context, flat_context, look, level,
			    level->body.shape.w / 2, level->body.shape.h / 2);
    }
}

void
mod_gl_view_flat_display_preview (mod_gl_utils_context_t * utils_context,
				  void *flat_context, lw6gui_look_t * look,
				  lw6map_level_t * level)
{
  _mod_gl_view_flat_display_preview (utils_context,
				     (_mod_gl_view_flat_context_t *)
				     flat_context, look, level);
}

/*
 * Game_state is not passed as args but retrived
 * from flat_context struct, not to give the illusion that
 * any game_state could be displayed. One *needs* to call
 * game_context_init first.
 */
static void
_display_armies (mod_gl_utils_context_t * utils_context,
		 _mod_gl_view_flat_context_t *
		 flat_context, int center_x, int center_y,
		 lw6gui_look_t * look)
{
  mod_gl_utils_update_game_texture_array (utils_context,
					  &(flat_context->game_context.
					    armies.armies_surface_array),
					  &(flat_context->game_context.armies.
					    armies_texture_array),
					  flat_context->game_context.
					  armies.game_state, look);
  _set_fighters_rules (utils_context, flat_context);
  _display_texture_array (utils_context, flat_context,
			  flat_context->game_context.armies.game_state->
			  map_state.shape.w,
			  flat_context->game_context.armies.game_state->
			  map_state.shape.h,
			  flat_context->game_context.armies.game_state->
			  map_state.shape.w,
			  flat_context->game_context.armies.game_state->
			  map_state.shape.h,
			  &(flat_context->game_context.armies.
			    armies_texture_array), center_x, center_y, look);
}

/*
 * Game_state is not passed as args but retrived
 * from flat_context struct, not to give the illusion that
 * any game_state could be displayed. One *needs* to call
 * game_context_init first.
 */
static void
_display_map (mod_gl_utils_context_t * utils_context,
	      _mod_gl_view_flat_context_t *
	      flat_context, lw6gui_look_t * look,
	      lw6ker_game_state_t * game_state,
	      lw6gui_main_cursor_t * main_cursor)
{
  int center_x = 0;
  int center_y = 0;

  lw6sys_log (LW6SYS_LOG_DEBUG, _("display map"));
  _display_map_preview (utils_context, flat_context, look,
			game_state->game_struct->level, center_x, center_y);
}

void
_mod_gl_view_flat_display_map (mod_gl_utils_context_t * utils_context,
			       _mod_gl_view_flat_context_t *
			       flat_context,
			       lw6gui_look_t * look,
			       lw6ker_game_state_t * game_state,
			       lw6gui_main_cursor_t * main_cursor)
{
  if (utils_context && flat_context && game_state)
    {
      lw6map_level_t *level;

      level = game_state->game_struct->level;

      _mod_gl_view_flat_game_context_update (utils_context,
					     flat_context,
					     &flat_context->game_context,
					     look, level, game_state);

      if (level->texture.has_alpha)
	{
	  mod_gl_utils_set_render_mode_2d_blend (utils_context);
	}
      else
	{
	  mod_gl_utils_set_render_mode_2d (utils_context);
	}

      glColor3f (1.0, 1.0, 1.0);
      glEnable (GL_TEXTURE_2D);	// for texture

      _mod_gl_view_flat_viewport_update (utils_context,
					 flat_context, look, game_state,
					 main_cursor);

      _display_map (utils_context, flat_context, look, game_state,
		    main_cursor);
    }
}

void
mod_gl_view_flat_display_map (mod_gl_utils_context_t * utils_context,
			      void *flat_context,
			      lw6gui_look_t * look,
			      lw6ker_game_state_t * game_state,
			      lw6gui_main_cursor_t * main_cursor)
{
  _mod_gl_view_flat_display_map (utils_context,
				 (_mod_gl_view_flat_context_t *)
				 flat_context, look, game_state, main_cursor);
}

/*
 * Game_state is not passed as args but retrived
 * from flat_context struct, not to give the illusion that
 * any game_state could be displayed. One *needs* to call
 * game_context_init first.
 */
static void
_display_fighters (mod_gl_utils_context_t * utils_context,
		   _mod_gl_view_flat_context_t *
		   flat_context, lw6gui_look_t * look,
		   lw6ker_game_state_t * game_state,
		   lw6gui_main_cursor_t * main_cursor)
{
  int center_x = 0;
  int center_y = 0;

  lw6sys_log (LW6SYS_LOG_DEBUG, _("display fighters"));
  _display_armies (utils_context, flat_context, center_x, center_y, look);
}

void
_mod_gl_view_flat_display_fighters (mod_gl_utils_context_t * utils_context,
				    _mod_gl_view_flat_context_t *
				    flat_context,
				    lw6gui_look_t * look,
				    lw6ker_game_state_t * game_state,
				    lw6gui_main_cursor_t * main_cursor)
{
  if (utils_context && flat_context && game_state)
    {
      lw6map_level_t *level;

      level = game_state->game_struct->level;

      _mod_gl_view_flat_game_context_update (utils_context,
					     flat_context,
					     &flat_context->game_context,
					     look, level, game_state);

      mod_gl_utils_set_render_mode_2d_blend (utils_context);

      glColor3f (1.0, 1.0, 1.0);
      glEnable (GL_TEXTURE_2D);	// for texture

      _mod_gl_view_flat_viewport_update (utils_context,
					 flat_context, look, game_state,
					 main_cursor);
      _display_fighters (utils_context, flat_context, look, game_state,
			 main_cursor);
    }
}

void
mod_gl_view_flat_display_fighters (mod_gl_utils_context_t * utils_context,
				   void *flat_context,
				   lw6gui_look_t * look,
				   lw6ker_game_state_t * game_state,
				   lw6gui_main_cursor_t * main_cursor)
{
  _mod_gl_view_flat_display_fighters (utils_context,
				      (_mod_gl_view_flat_context_t *)
				      flat_context, look, game_state,
				      main_cursor);
}

static void
_display_cursor_texture (mod_gl_utils_context_t * utils_context,
			 _mod_gl_view_flat_context_t * flat_context,
			 float x, float y, float w, float h, GLuint texture)
{
  _set_cursor_rules (utils_context, flat_context);
  mod_gl_utils_display_texture (utils_context,
				texture, x - w / 2.0f, y - h / 2.0f,
				x + w / 2.0f, y + h / 2.0f, 0.0f, 0.0f, 1.0f,
				1.0f);
}

static void
_display_cursor (mod_gl_utils_context_t * utils_context,
		 _mod_gl_view_flat_context_t * flat_context,
		 lw6gui_look_t * look, lw6gui_main_cursor_t * main_cursor,
		 int i, int x, int y, int even_odd, int is_main_cursor)
{

  float cursor_x = 0.0f;
  float cursor_y = 0.0f;
  float cursor_w = 0.0f;
  float cursor_h = 0.0f;

  if (is_main_cursor)
    {
      if (!main_cursor->mouse_controlled)
	{
	  x = main_cursor->x;
	  y = main_cursor->y;
	}
    }

  lw6gui_viewport_map_to_screen (&(flat_context->viewport), &cursor_x,
				 &cursor_y, x, y, 0);
  if (is_main_cursor)
    {
      if (main_cursor->mouse_controlled)
	{
	  cursor_x = utils_context->input.mouse.x;
	  cursor_y = utils_context->input.mouse.y;
	  cursor_x =
	    lw6sys_max (cursor_x, flat_context->viewport.map_visible.x1);
	  cursor_x =
	    lw6sys_min (cursor_x, flat_context->viewport.map_visible.x2);
	  cursor_y =
	    lw6sys_max (cursor_y, flat_context->viewport.map_visible.y1);
	  cursor_y =
	    lw6sys_min (cursor_y, flat_context->viewport.map_visible.y2);
	}
    }

  if (cursor_x >= flat_context->viewport.map_visible.x1 &&
      cursor_y >= flat_context->viewport.map_visible.y1 &&
      cursor_x <= flat_context->viewport.map_visible.x2 &&
      cursor_y <= flat_context->viewport.map_visible.y2)
    {
      cursor_w = cursor_h =
	(utils_context->video_mode.width +
	 utils_context->video_mode.height) *
	lw6sys_math_heartbeat (mod_gl_utils_timer_uptime (utils_context),
			       flat_context->const_data.
			       cursor_heartbeat_period,
			       flat_context->const_data.cursor_size_min,
			       flat_context->const_data.cursor_size_max) *
	look->style.cursor_size;
      lw6sys_log (LW6SYS_LOG_DEBUG,
		  _("display cursor %d %0.1f , %0.1f - %0.1f x %0.1f"), i,
		  cursor_x, cursor_y, cursor_w, cursor_h);
      _display_cursor_texture (utils_context, flat_context, cursor_x,
			       cursor_y, cursor_w, cursor_h,
			       even_odd ? flat_context->cursors_context.
			       cursor[i].texture_even : flat_context->
			       cursors_context.cursor[i].texture_odd);
    }
}

static void
_display_cursors (mod_gl_utils_context_t * utils_context,
		  _mod_gl_view_flat_context_t *
		  flat_context,
		  lw6gui_look_t * look, lw6ker_game_state_t * game_state,
		  lw6gui_main_cursor_t * main_cursor)
{
  int i;
  lw6ker_cursor_t *cursor;
  int blink_state;

  lw6sys_log (LW6SYS_LOG_DEBUG, _("display cursors"));
  for (i = 0; i < LW6MAP_MAX_NB_CURSORS; ++i)
    {
      cursor = &(game_state->map_state.cursor_array.cursors[i]);
      if (cursor->enabled)
	{
	  blink_state =
	    lw6sys_math_blink (mod_gl_utils_timer_uptime (utils_context),
			       flat_context->const_data.cursor_blink_period);
	  _display_cursor (utils_context, flat_context, look, main_cursor, i,
			   cursor->pos.x, cursor->pos.y, blink_state,
			   main_cursor->cursor_id == cursor->cursor_id);
	}
    }
}

void
_mod_gl_view_flat_display_cursors (mod_gl_utils_context_t * utils_context,
				   _mod_gl_view_flat_context_t *
				   flat_context,
				   lw6gui_look_t * look,
				   lw6ker_game_state_t * game_state,
				   lw6gui_main_cursor_t * main_cursor)
{
  if (utils_context && flat_context && game_state)
    {
      _mod_gl_view_flat_cursors_context_update (utils_context,
						&flat_context->
						cursors_context,
						&flat_context->const_data,
						look, game_state);

      mod_gl_utils_set_render_mode_2d_blend (utils_context);

      glColor3f (1.0, 1.0, 1.0);
      glEnable (GL_TEXTURE_2D);	// for texture

      _mod_gl_view_flat_viewport_update (utils_context,
					 flat_context, look, game_state,
					 main_cursor);

      _display_cursors (utils_context, flat_context, look, game_state,
			main_cursor);
    }
}

void
mod_gl_view_flat_display_cursors (mod_gl_utils_context_t *
				  utils_context,
				  void *flat_context,
				  lw6gui_look_t * look,
				  lw6ker_game_state_t * game_state,
				  lw6gui_main_cursor_t * main_cursor)
{
  _mod_gl_view_flat_display_cursors (utils_context,
				     (_mod_gl_view_flat_context_t *)
				     flat_context, look, game_state,
				     main_cursor);
}
