; liquidwar.nsi
;
; This script is based on example2.nsi

;--------------------------------

; The name of the installer
Name "Liquid War 6 0.0.8beta"

; The file to write
OutFile "liquidwar6-0.0.8beta-ms-windows-installer.exe"

; The default installation directory
InstallDir "$PROGRAMFILES\Liquid War 6"

; Registry key to check for directory (so if you install again, it will 
; overwrite the old one automatically)
InstallDirRegKey HKLM "Software\Liquid_War_6" "Install_Dir"

;--------------------------------

; Pages

Page components
Page directory
Page instfiles

UninstPage uninstConfirm
UninstPage instfiles

;--------------------------------

; The stuff to install
Section "Liquid War 6 (required)"

  SectionIn RO
  
  ; Set output path to the installation directory.
  SetOutPath $INSTDIR

  ; Put file there
  File "liquidwar6.exe"
  File "*.txt"
  File "*.dll"
  File /r "script"
  File /r "data"
  File /r "map"
  File /r "music"
  File /r "doc"
  File /r "guile"
  
  ; Write the installation path into the registry
  WriteRegStr HKLM "SOFTWARE\Liquid_War_6" "Install_Dir" "$INSTDIR"
  
  ; Write the uninstall keys for Windows
  WriteRegStr HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\Liquid_War_6" "DisplayName" "Liquid War 6 0.0.8beta"
  WriteRegStr HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\Liquid_War_6" "UninstallString" '"$INSTDIR\uninstall.exe"'
  WriteRegDWORD HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\Liquid_War_6" "NoModify" 1
  WriteRegDWORD HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\Liquid_War_6" "NoRepair" 1
  WriteUninstaller "uninstall.exe"
  
SectionEnd

; Optional section (can be disabled by the user)
Section "Start Menu Shortcuts"

  CreateDirectory "$SMPROGRAMS\Liquid War 6"
  CreateShortCut "$SMPROGRAMS\Liquid War 6\Uninstall.lnk" "$INSTDIR\uninstall.exe" "" "$INSTDIR\uninstall.exe" 0
  CreateShortCut "$SMPROGRAMS\Liquid War 6\Liquid War 6.lnk" "$INSTDIR\liquidwar6.exe" "" "$INSTDIR\lwwin.exe" 0
  CreateShortCut "$SMPROGRAMS\Liquid War 6\Documentation.lnk" "$INSTDIR\doc\html\index.html" "" "$INSTDIR\doc\html\index.html" 0
  
SectionEnd

;--------------------------------

; Uninstaller

Section "Uninstall"
  
  ; Remove registry keys
  DeleteRegKey HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\Liquid_War_6"
  DeleteRegKey HKLM "SOFTWARE\Liquid_War_6"

  ; Remove shortcuts, if any
  RMDir /r "$SMPROGRAMS\Liquid War 6"

  ; Remove directories used
  RMDir /r "$INSTDIR"

SectionEnd
