/*
  Liquid War 6 is a unique multiplayer wargame.
  Copyright (C)  2005, 2006, 2007, 2008, 2009, 2010  Christian Mauduit <ufoot@ufoot.org>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.
  

  Liquid War 6 homepage : http://www.gnu.org/software/liquidwar6/
  Contact author        : ufoot@ufoot.org
*/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "../bot.h"
#include "mod-idiot-internal.h"

_mod_idiot_context_t *
_mod_idiot_init (int argc, char *argv[], lw6bot_data_t * data)
{
  _mod_idiot_context_t *idiot_context = NULL;

  lw6sys_log (LW6SYS_LOG_INFO, _("idiot init"));

  idiot_context =
    (_mod_idiot_context_t *) LW6SYS_CALLOC (sizeof (_mod_idiot_context_t));
  if (idiot_context)
    {
      idiot_context->last_move_round = -1;
      idiot_context->start_pos_x = -1;
      idiot_context->start_pos_y = -1;
      idiot_context->target_pos_x = -1;
      idiot_context->target_pos_y = -1;
    }

  return idiot_context;
}

void
_mod_idiot_quit (_mod_idiot_context_t * idiot_context)
{
  lw6sys_log (LW6SYS_LOG_INFO, _("idiot quit"));
  LW6SYS_FREE (idiot_context);
}
