//  Copyright (C) 2010 Ben Asselstine
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 3 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU Library General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 
//  02110-1301, USA.

#include <assert.h>
#include "event-box.h"
#include "file.h"
#include "event.h"
#include "boxcompose.h"
#include "listerola.h"
#include "host-box.h"

const int left_arrow_pos = 0;
const int contents_pos = 1;
const int right_arrow_pos = 2;

EventBox::EventBox(Event* event, double row_height, double column_width)
  :FrameBox(new Gtk::HBox(), Gdk::Color("blue"), row_height, column_width), 
    show_left_arrow(true), show_right_arrow(true)
{
  Gtk::HBox *contents = get_contents();
  Gtk::Image *left_arrow_image = new Gtk::Image();
  contents->pack_start(*manage(left_arrow_image), Gtk::PACK_SHRINK, 0);
  Gtk::HBox *box_contents = Box::ucompose("%1", event->get_name());
  contents->pack_start(*manage(box_contents), true, true, 0);
  Gtk::Image *right_arrow_image = new Gtk::Image();
  contents->pack_start(*manage(right_arrow_image), Gtk::PACK_SHRINK, 0);
  set_event(event);
}

EventBox::~EventBox()
{
}

void EventBox::set_show_left_arrow(bool show_arrow)
{
  if (show_left_arrow != show_arrow)
    {
      show_left_arrow = show_arrow;
      update_left_arrow();
    }
}

void EventBox::set_show_right_arrow(bool show_arrow)
{
  if (show_arrow != show_right_arrow)
    {
      show_right_arrow = show_arrow;
      update_right_arrow();
    }
}

void EventBox::update_arrow(int pos, std::string file, bool show_arrow)
{
  Gtk::HBox *contents = get_contents();
  Gtk::Widget *widget = contents->children()[pos].get_widget();
  Gtk::Image *image = dynamic_cast<Gtk::Image*>(widget);
  Glib::RefPtr<Gdk::Pixbuf> buf = Gdk::Pixbuf::create_from_file(file);
  image->property_pixbuf() = buf;
  if (show_arrow == false)
    {
      image->clear();
      image->set_size_request(buf->get_width(), buf->get_height());
    }
  image->show_all();
}

void EventBox::update_left_arrow()
{
  update_arrow(left_arrow_pos, File::get_data_path() + "/left.png", show_left_arrow);
}
    
void EventBox::update_right_arrow()
{
  update_arrow(right_arrow_pos, File::get_data_path() + "/right.png", show_right_arrow);
}
    
void EventBox::set_event(Event *event)
{
  if (is_realized())
    {
      Gtk::HBox *box_contents = Box::ucompose("%1", event->get_name());
      set_box_contents(box_contents);
    }
  Listerola *l = Listerola::getInstance();
  if (event->get_date().straddles(l->get_current_date()) == true)
    {
      if (event->get_date().overlap_start(l->get_current_date()) > 1.0)
        show_left_arrow = true;
      else
        show_left_arrow = false;

    }
  else
    show_left_arrow = false;

  if (event->get_date().straddles(l->get_current_date().get_ending_date()))
    {
      if (event->get_date().overlap_end(l->get_current_date().get_ending_date()) > 1.0)
        show_right_arrow = true;
      else
        show_right_arrow = false;
    }
  else
    show_right_arrow = false;
  set_background_colour(Gdk::Color(event->get_genre()));
  update_left_arrow ();
  update_right_arrow ();
}

